/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1;

import com.koalii.asn1.ASN1ObjectParser;
import com.koalii.asn1.ASN1OctetStringParser;
import com.koalii.asn1.BERConstructedOctetString;
import com.koalii.asn1.ConstructedOctetStream;
import com.koalii.asn1.DERObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BEROctetStringParser
implements ASN1OctetStringParser {
    private ASN1ObjectParser _parser;

    protected BEROctetStringParser(ASN1ObjectParser parser) {
        this._parser = parser;
    }

    @Override
    public InputStream getOctetStream() {
        return new ConstructedOctetStream(this._parser);
    }

    @Override
    public DERObject getDERObject() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        InputStream in = this.getOctetStream();
        try {
            int ch;
            while ((ch = in.read()) >= 0) {
                bOut.write(ch);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException converting stream to byte array: " + e.getMessage());
        }
        return new BERConstructedOctetString(bOut.toByteArray());
    }
}

