/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1;

import com.koalii.asn1.ASN1InputStream;
import com.koalii.asn1.ASN1Object;
import com.koalii.asn1.DEREncodable;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Object {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int tag, byte[] octets) {
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this.tag = tag | 0x20;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(baos);
        dos.writeObject(object);
        this.octets = baos.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.octets.length != other.octets.length) {
            return false;
        }
        int i = 0;
        while (i < this.octets.length) {
            if (this.octets[i] != other.octets[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] b = this.getContents();
        int value = 0;
        int i = 0;
        while (i != b.length) {
            value ^= (b[i] & 0xFF) << i % 4;
            ++i;
        }
        return value ^ this.getApplicationTag();
    }
}

