/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1;

import com.koalii.asn1.ASN1Object;
import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.ASN1TaggedObject;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DEROutputStream;
import java.io.IOException;

public class DERBoolean
extends ASN1Object {
    byte value;
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);

    public static DERBoolean getInstance(Object obj) {
        if (obj == null || obj instanceof DERBoolean) {
            return (DERBoolean)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERBoolean(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERBoolean.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERBoolean.getInstance(obj.getObject());
    }

    public DERBoolean(byte[] value) {
        this.value = value[0];
    }

    public DERBoolean(boolean value) {
        this.value = (byte)(value ? -1 : 0);
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        byte[] bytes = new byte[]{this.value};
        out.writeEncoded(1, bytes);
    }

    @Override
    protected boolean asn1Equals(DERObject o) {
        if (o == null || !(o instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)o).value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.value != 0 ? "TRUE" : "FALSE";
    }
}

