/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.cms;

import com.koalii.asn1.ASN1SequenceParser;
import com.koalii.asn1.DERInteger;
import com.koalii.asn1.cms.ContentInfoParser;
import com.koalii.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class CompressedDataParser {
    private DERInteger _version;
    private AlgorithmIdentifier _compressionAlgorithm;
    private ContentInfoParser _encapContentInfo;

    public CompressedDataParser(ASN1SequenceParser seq) throws IOException {
        this._version = (DERInteger)seq.readObject();
        this._compressionAlgorithm = AlgorithmIdentifier.getInstance(seq.readObject().getDERObject());
        this._encapContentInfo = new ContentInfoParser((ASN1SequenceParser)seq.readObject());
    }

    public DERInteger getVersion() {
        return this._version;
    }

    public AlgorithmIdentifier getCompressionAlgorithmIdentifier() {
        return this._compressionAlgorithm;
    }

    public ContentInfoParser getEncapContentInfo() {
        return this._encapContentInfo;
    }
}

