/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.cms;

import com.koalii.asn1.ASN1SequenceParser;
import com.koalii.asn1.ASN1SetParser;
import com.koalii.asn1.ASN1TaggedObjectParser;
import com.koalii.asn1.DEREncodable;
import com.koalii.asn1.DERInteger;
import com.koalii.asn1.cms.EncryptedContentInfoParser;
import java.io.IOException;

public class EnvelopedDataParser {
    private ASN1SequenceParser _seq;
    private DERInteger _version;
    private DEREncodable _nextObject;

    public EnvelopedDataParser(ASN1SequenceParser seq) throws IOException {
        this._seq = seq;
        this._version = (DERInteger)seq.readObject();
    }

    public DERInteger getVersion() {
        return this._version;
    }

    public ASN1SetParser getCertificates() throws IOException {
        this._nextObject = this._seq.readObject();
        if (this._nextObject instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)this._nextObject).getTagNo() == 0) {
            ASN1SetParser certs = (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
            this._nextObject = null;
            return certs;
        }
        return null;
    }

    public ASN1SetParser getCrls() throws IOException {
        if (this._nextObject == null) {
            this._nextObject = this._seq.readObject();
        }
        if (this._nextObject instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)this._nextObject).getTagNo() == 1) {
            ASN1SetParser crls = (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
            this._nextObject = null;
            return crls;
        }
        return null;
    }

    public ASN1SetParser getRecipientInfos() throws IOException {
        return (ASN1SetParser)this._seq.readObject();
    }

    public EncryptedContentInfoParser getEncryptedContentInfo() throws IOException {
        return new EncryptedContentInfoParser((ASN1SequenceParser)this._seq.readObject());
    }

    public ASN1SetParser getUnprotectedAttrs() throws IOException {
        DEREncodable o = this._seq.readObject();
        if (o != null) {
            return (ASN1SetParser)((ASN1TaggedObjectParser)o).getObjectParser(17, false);
        }
        return null;
    }
}

