/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.cms;

import com.koalii.asn1.ASN1Encodable;
import com.koalii.asn1.ASN1EncodableVector;
import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.ASN1Sequence;
import com.koalii.asn1.ASN1TaggedObject;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DERSequence;
import com.koalii.asn1.cms.KeyAgreeRecipientIdentifier;

public class RecipientEncryptedKey
extends ASN1Encodable {
    private KeyAgreeRecipientIdentifier identifier;
    private ASN1OctetString encryptedKey;

    private RecipientEncryptedKey(ASN1Sequence seq) {
        this.identifier = KeyAgreeRecipientIdentifier.getInstance(seq.getObjectAt(0));
        this.encryptedKey = (ASN1OctetString)seq.getObjectAt(1);
    }

    public static RecipientEncryptedKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RecipientEncryptedKey.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static RecipientEncryptedKey getInstance(Object obj) {
        if (obj == null || obj instanceof RecipientEncryptedKey) {
            return (RecipientEncryptedKey)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RecipientEncryptedKey((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKey: " + obj.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier getIdentifier() {
        return this.identifier;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.encryptedKey;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.identifier);
        v.add(this.encryptedKey);
        return new DERSequence(v);
    }
}

