/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.oiw;

import com.koalii.asn1.ASN1Encodable;
import com.koalii.asn1.ASN1EncodableVector;
import com.koalii.asn1.ASN1Sequence;
import com.koalii.asn1.DERInteger;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class ElGamalParameter
extends ASN1Encodable {
    DERInteger p;
    DERInteger g;

    public ElGamalParameter(BigInteger p, BigInteger g) {
        this.p = new DERInteger(p);
        this.g = new DERInteger(g);
    }

    public ElGamalParameter(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.p = (DERInteger)e.nextElement();
        this.g = (DERInteger)e.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.p);
        v.add(this.g);
        return new DERSequence(v);
    }
}

