/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.util;

import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.ASN1Sequence;
import com.koalii.asn1.ASN1Set;
import com.koalii.asn1.BERConstructedOctetString;
import com.koalii.asn1.BERConstructedSequence;
import com.koalii.asn1.BERSequence;
import com.koalii.asn1.BERSet;
import com.koalii.asn1.BERTaggedObject;
import com.koalii.asn1.DERBMPString;
import com.koalii.asn1.DERBitString;
import com.koalii.asn1.DERBoolean;
import com.koalii.asn1.DERConstructedSequence;
import com.koalii.asn1.DERConstructedSet;
import com.koalii.asn1.DEREncodable;
import com.koalii.asn1.DERGeneralizedTime;
import com.koalii.asn1.DERIA5String;
import com.koalii.asn1.DERInteger;
import com.koalii.asn1.DERNull;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DERObjectIdentifier;
import com.koalii.asn1.DEROctetString;
import com.koalii.asn1.DERPrintableString;
import com.koalii.asn1.DERSequence;
import com.koalii.asn1.DERSet;
import com.koalii.asn1.DERT61String;
import com.koalii.asn1.DERTaggedObject;
import com.koalii.asn1.DERUTCTime;
import com.koalii.asn1.DERUTF8String;
import com.koalii.asn1.DERUnknownTag;
import com.koalii.asn1.DERVisibleString;
import com.koalii.util.encoders.Hex;
import java.util.Enumeration;

public class ASN1Dump {
    private static final String TAB = "    ";

    static String _dumpAsString(String indent, DERObject obj) {
        if (obj instanceof ASN1Sequence) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            if (obj instanceof BERConstructedSequence) {
                buf.append("BER ConstructedSequence");
            } else if (obj instanceof DERConstructedSequence) {
                buf.append("DER ConstructedSequence");
            } else if (obj instanceof BERSequence) {
                buf.append("BER Sequence");
            } else if (obj instanceof DERSequence) {
                buf.append("DER Sequence");
            } else {
                buf.append("Sequence");
            }
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null || o.equals(new DERNull())) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERTaggedObject) {
            StringBuffer buf = new StringBuffer();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            if (obj instanceof BERTaggedObject) {
                buf.append("BER Tagged [");
            } else {
                buf.append("Tagged [");
            }
            DERTaggedObject o = (DERTaggedObject)obj;
            buf.append(Integer.toString(o.getTagNo()));
            buf.append(']');
            if (!o.isExplicit()) {
                buf.append(" IMPLICIT ");
            }
            buf.append(System.getProperty("line.separator"));
            if (o.isEmpty()) {
                buf.append(tab);
                buf.append("EMPTY");
                buf.append(System.getProperty("line.separator"));
            } else {
                buf.append(ASN1Dump._dumpAsString(tab, o.getObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERConstructedSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            buf.append("ConstructedSet");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof BERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            buf.append("BER Set");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            buf.append("DER Set");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERObjectIdentifier) {
            return String.valueOf(indent) + "ObjectIdentifier(" + ((DERObjectIdentifier)obj).getId() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof DERBoolean) {
            return String.valueOf(indent) + "Boolean(" + ((DERBoolean)obj).isTrue() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof DERInteger) {
            return String.valueOf(indent) + "Integer(" + ((DERInteger)obj).getValue() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof BERConstructedOctetString) {
            return String.valueOf(indent) + "BER Constructed Octet String" + "[" + ((ASN1OctetString)obj).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DEROctetString) {
            return String.valueOf(indent) + "DER Octet String" + "[" + ((ASN1OctetString)obj).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DERBitString) {
            return String.valueOf(indent) + "DER Bit String" + "[" + ((DERBitString)obj).getBytes().length + ", " + ((DERBitString)obj).getPadBits() + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DERIA5String) {
            return String.valueOf(indent) + "IA5String(" + ((DERIA5String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUTF8String) {
            return String.valueOf(indent) + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERPrintableString) {
            return String.valueOf(indent) + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERVisibleString) {
            return String.valueOf(indent) + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERBMPString) {
            return String.valueOf(indent) + "BMPString(" + ((DERBMPString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERT61String) {
            return String.valueOf(indent) + "T61String(" + ((DERT61String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUTCTime) {
            return String.valueOf(indent) + "UTCTime(" + ((DERUTCTime)obj).getTime() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERGeneralizedTime) {
            return String.valueOf(indent) + "GeneralizedTime(" + ((DERGeneralizedTime)obj).getTime() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUnknownTag) {
            return String.valueOf(indent) + "Unknown " + Integer.toString(((DERUnknownTag)obj).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)obj).getData())) + System.getProperty("line.separator");
        }
        return String.valueOf(indent) + obj.toString() + System.getProperty("line.separator");
    }

    public static String dumpAsString(Object obj) {
        if (obj instanceof DERObject) {
            return ASN1Dump._dumpAsString("", (DERObject)obj);
        }
        if (obj instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", ((DEREncodable)obj).getDERObject());
        }
        return "unknown object type " + obj.toString();
    }
}

