/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.x509;

import com.koalii.asn1.ASN1Encodable;
import com.koalii.asn1.ASN1EncodableVector;
import com.koalii.asn1.ASN1Sequence;
import com.koalii.asn1.ASN1TaggedObject;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DERSequence;
import com.koalii.asn1.DERTaggedObject;
import com.koalii.asn1.x509.GeneralNames;
import com.koalii.asn1.x509.IssuerSerial;
import com.koalii.asn1.x509.ObjectDigestInfo;

public class Holder
extends ASN1Encodable {
    IssuerSerial baseCertificateID;
    GeneralNames entityName;
    ObjectDigestInfo objectDigestInfo;

    public static Holder getInstance(Object obj) {
        if (obj instanceof Holder) {
            return (Holder)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Holder((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public Holder(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(seq.getObjectAt(i));
            switch (tObj.getTagNo()) {
                case 0: {
                    this.baseCertificateID = IssuerSerial.getInstance(tObj, false);
                    break;
                }
                case 1: {
                    this.entityName = GeneralNames.getInstance(tObj, false);
                    break;
                }
                case 2: {
                    this.objectDigestInfo = ObjectDigestInfo.getInstance(tObj, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in Holder");
                }
            }
            ++i;
        }
    }

    public Holder(IssuerSerial baseCertificateID) {
        this.baseCertificateID = baseCertificateID;
    }

    public Holder(GeneralNames entityName) {
        this.entityName = entityName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public GeneralNames getEntityName() {
        return this.entityName;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.baseCertificateID != null) {
            v.add(new DERTaggedObject(false, 0, this.baseCertificateID));
        }
        if (this.entityName != null) {
            v.add(new DERTaggedObject(false, 1, this.entityName));
        }
        if (this.objectDigestInfo != null) {
            v.add(new DERTaggedObject(false, 2, this.objectDigestInfo));
        }
        return new DERSequence(v);
    }
}

