/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.x509;

import com.koalii.asn1.ASN1Object;
import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.DERBoolean;
import java.io.IOException;

public class X509Extension {
    boolean critical;
    ASN1OctetString value;

    public X509Extension(DERBoolean critical, ASN1OctetString value) {
        this.critical = critical.isTrue();
        this.value = value;
    }

    public X509Extension(boolean critical, ASN1OctetString value) {
        this.critical = critical;
        this.value = value;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.isCritical()) {
            return this.getValue().hashCode();
        }
        return ~this.getValue().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof X509Extension)) {
            return false;
        }
        X509Extension other = (X509Extension)o;
        return other.getValue().equals(this.getValue()) && other.isCritical() == this.isCritical();
    }

    public static ASN1Object convertValueToObject(X509Extension ext) throws IllegalArgumentException {
        try {
            return ASN1Object.fromByteArray(ext.getValue().getOctets());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't convert extension: " + e);
        }
    }
}

