/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.asn1.x509;

import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.DEREncodable;
import com.koalii.asn1.DERObjectIdentifier;
import com.koalii.asn1.DEROctetString;
import com.koalii.asn1.DEROutputStream;
import com.koalii.asn1.x509.X509Extension;
import com.koalii.asn1.x509.X509Extensions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class X509ExtensionsGenerator {
    private Hashtable extensions = new Hashtable();
    private Vector extOrdering = new Vector();

    public void reset() {
        this.extensions = new Hashtable();
        this.extOrdering = new Vector();
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, DEREncodable value) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error encoding value: " + e);
        }
        this.addExtension(oid, critical, bOut.toByteArray());
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, byte[] value) {
        if (this.extensions.containsKey(oid)) {
            throw new IllegalArgumentException("extension " + oid + " already added");
        }
        this.extOrdering.addElement(oid);
        this.extensions.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
    }

    public boolean isEmpty() {
        return this.extOrdering.isEmpty();
    }

    public X509Extensions generate() {
        return new X509Extensions(this.extOrdering, this.extensions);
    }
}

