/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1;

import com.koalii.bc.asn1.ASN1Object;
import com.koalii.bc.asn1.ASN1OctetStringParser;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.ASN1TaggedObject;
import com.koalii.bc.asn1.BERConstructedOctetString;
import com.koalii.bc.asn1.DEREncodable;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DEROutputStream;
import com.koalii.bc.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1OctetString
extends ASN1Object
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ASN1OctetString.getInstance(obj.getObject());
    }

    public static ASN1OctetString getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        if (obj instanceof ASN1Sequence) {
            Vector v = new Vector();
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
            return new BERConstructedOctetString(v);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public ASN1OctetString(byte[] string) {
        this.string = string;
    }

    public ASN1OctetString(DEREncodable obj) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(obj);
            dOut.close();
            this.string = bOut.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error processing object : " + e.toString());
        }
    }

    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.string;
    }

    public int hashCode() {
        byte[] b = this.getOctets();
        int value = 0;
        int i = 0;
        while (i != b.length) {
            value ^= (b[i] & 0xFF) << i % 4;
            ++i;
        }
        return value;
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString other = (ASN1OctetString)o;
        byte[] b1 = other.string;
        byte[] b2 = this.string;
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i != b1.length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return "#" + new String(Hex.encode(this.string));
    }
}

