/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1;

import com.koalii.bc.asn1.BERGenerator;
import com.koalii.bc.asn1.DEROctetString;
import java.io.IOException;
import java.io.OutputStream;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream out) throws IOException {
        super(out);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream out, int tagNo, boolean isExplicit) throws IOException {
        super(out, tagNo, isExplicit);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return new BEROctetStream();
    }

    public OutputStream getOctetOutputStream(byte[] buf) {
        return new BufferedBEROctetStream(buf);
    }

    private class BEROctetStream
    extends OutputStream {
        private byte[] _buf = new byte[1];

        private BEROctetStream() {
        }

        public void write(int b) throws IOException {
            this._buf[0] = (byte)b;
            BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
        }

        public void write(byte[] buf) throws IOException {
            BEROctetStringGenerator.this._out.write(new DEROctetString(buf).getEncoded());
        }

        public void write(byte[] buf, int offSet, int len) throws IOException {
            byte[] bytes = new byte[len];
            System.arraycopy(buf, offSet, bytes, 0, len);
            BEROctetStringGenerator.this._out.write(new DEROctetString(bytes).getEncoded());
        }

        public void close() throws IOException {
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;

        BufferedBEROctetStream(byte[] buf) {
            this._buf = buf;
            this._off = 0;
        }

        public void write(int b) throws IOException {
            this._buf[this._off++] = (byte)b;
            if (this._off == this._buf.length) {
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
            }
        }

        public void close() throws IOException {
            if (this._off != 0) {
                byte[] bytes = new byte[this._off];
                System.arraycopy(this._buf, 0, bytes, 0, this._off);
                BEROctetStringGenerator.this._out.write(new DEROctetString(bytes).getEncoded());
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

