/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.cms;

import com.koalii.bc.asn1.ASN1Encodable;
import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.ASN1TaggedObject;
import com.koalii.bc.asn1.DERInteger;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DERSequence;
import com.koalii.bc.asn1.cms.KEKIdentifier;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;

public class KEKRecipientInfo
extends ASN1Encodable {
    private DERInteger version;
    private KEKIdentifier kekid;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1OctetString encryptedKey;

    public KEKRecipientInfo(KEKIdentifier kekid, AlgorithmIdentifier keyEncryptionAlgorithm, ASN1OctetString encryptedKey) {
        this.version = new DERInteger(4);
        this.kekid = kekid;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.encryptedKey = encryptedKey;
    }

    public KEKRecipientInfo(ASN1Sequence seq) {
        this.version = (DERInteger)seq.getObjectAt(0);
        this.kekid = KEKIdentifier.getInstance(seq.getObjectAt(1));
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(2));
        this.encryptedKey = (ASN1OctetString)seq.getObjectAt(3);
    }

    public static KEKRecipientInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KEKRecipientInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KEKRecipientInfo getInstance(Object obj) {
        if (obj == null || obj instanceof KEKRecipientInfo) {
            return (KEKRecipientInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KEKRecipientInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid KEKRecipientInfo: " + obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public KEKIdentifier getKekid() {
        return this.kekid;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.encryptedKey;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.kekid);
        v.add(this.keyEncryptionAlgorithm);
        v.add(this.encryptedKey);
        return new DERSequence(v);
    }
}

