/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.cms;

import com.koalii.bc.asn1.ASN1Encodable;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.ASN1TaggedObject;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DERTaggedObject;
import com.koalii.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.bc.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends ASN1Encodable {
    private IssuerAndSerialNumber issuerSerial;
    private RecipientKeyIdentifier rKeyID;

    private KeyAgreeRecipientIdentifier(ASN1Sequence seq) {
        this.issuerSerial = IssuerAndSerialNumber.getInstance(seq);
        this.rKeyID = null;
    }

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyAgreeRecipientIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KeyAgreeRecipientIdentifier((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + obj.getClass().getName());
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerSerial;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.rKeyID;
    }

    public DERObject toASN1Object() {
        if (this.issuerSerial != null) {
            return this.issuerSerial.toASN1Object();
        }
        return new DERTaggedObject(false, 0, this.rKeyID);
    }
}

