/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.x509;

import com.koalii.bc.asn1.ASN1Encodable;
import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.ASN1TaggedObject;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DERSequence;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class DigestInfo
extends ASN1Encodable {
    private byte[] digest;
    private AlgorithmIdentifier algId;

    public static DigestInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DigestInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DigestInfo getInstance(Object obj) {
        if (obj instanceof DigestInfo) {
            return (DigestInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DigestInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DigestInfo(AlgorithmIdentifier algId, byte[] digest) {
        this.digest = digest;
        this.algId = algId;
    }

    public DigestInfo(ASN1Sequence obj) {
        Enumeration e = obj.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(e.nextElement());
        this.digest = ASN1OctetString.getInstance(e.nextElement()).getOctets();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.algId);
        v.add(new DEROctetString(this.digest));
        return new DERSequence(v);
    }
}

