/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.x509;

import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.DERGeneralizedTime;
import com.koalii.bc.asn1.DERInteger;
import com.koalii.bc.asn1.DERObjectIdentifier;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DERSequence;
import com.koalii.bc.asn1.DERTaggedObject;
import com.koalii.bc.asn1.DERUTCTime;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.bc.asn1.x509.CRLReason;
import com.koalii.bc.asn1.x509.TBSCertList;
import com.koalii.bc.asn1.x509.Time;
import com.koalii.bc.asn1.x509.X509Extension;
import com.koalii.bc.asn1.x509.X509Extensions;
import com.koalii.bc.asn1.x509.X509Name;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class V2TBSCertListGenerator {
    DERInteger version = new DERInteger(1);
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate = null;
    X509Extensions extensions = null;
    private Vector crlentries = null;

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.issuer = issuer;
    }

    public void setThisUpdate(DERUTCTime thisUpdate) {
        this.thisUpdate = new Time(thisUpdate);
    }

    public void setNextUpdate(DERUTCTime nextUpdate) {
        this.nextUpdate = new Time(nextUpdate);
    }

    public void setThisUpdate(Time thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public void addCRLEntry(ASN1Sequence crlEntry) {
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(crlEntry);
    }

    public void addCRLEntry(DERInteger userCertificate, DERUTCTime revocationDate, int reason) {
        this.addCRLEntry(userCertificate, new Time(revocationDate), reason);
    }

    public void addCRLEntry(DERInteger userCertificate, Time revocationDate, int reason) {
        this.addCRLEntry(userCertificate, revocationDate, reason, null);
    }

    public void addCRLEntry(DERInteger userCertificate, Time revocationDate, int reason, DERGeneralizedTime invalidityDate) {
        Vector<DERObjectIdentifier> extOids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> extValues = new Vector<X509Extension>();
        if (reason != 0) {
            CRLReason crlReason = new CRLReason(reason);
            try {
                extOids.addElement(X509Extensions.ReasonCode);
                extValues.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(crlReason.getEncoded())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("error encoding reason: " + e);
            }
        }
        if (invalidityDate != null) {
            try {
                extOids.addElement(X509Extensions.InvalidityDate);
                extValues.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(invalidityDate.getEncoded())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("error encoding invalidityDate: " + e);
            }
        }
        if (extOids.size() != 0) {
            this.addCRLEntry(userCertificate, revocationDate, new X509Extensions(extOids, extValues));
        } else {
            this.addCRLEntry(userCertificate, revocationDate, null);
        }
    }

    public void addCRLEntry(DERInteger userCertificate, Time revocationDate, X509Extensions extensions) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(userCertificate);
        v.add(revocationDate);
        if (extensions != null) {
            v.add(extensions);
        }
        this.addCRLEntry(new DERSequence(v));
    }

    public void setExtensions(X509Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.signature);
        v.add(this.issuer);
        v.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            v.add(this.nextUpdate);
        }
        if (this.crlentries != null) {
            ASN1EncodableVector certs = new ASN1EncodableVector();
            Enumeration it = this.crlentries.elements();
            while (it.hasMoreElements()) {
                certs.add((ASN1Sequence)it.nextElement());
            }
            v.add(new DERSequence(certs));
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(new DERSequence(v));
    }
}

