/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.x509;

import com.koalii.bc.asn1.DERGeneralizedTime;
import com.koalii.bc.asn1.DERIA5String;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DERObjectIdentifier;
import com.koalii.bc.asn1.DERPrintableString;
import com.koalii.bc.asn1.DERUTF8String;
import com.koalii.bc.asn1.x509.X509Name;
import com.koalii.bc.asn1.x509.X509NameEntryConverter;
import java.io.IOException;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    public DERObject getConvertedValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (oid.equals(X509Name.EmailAddress) || oid.equals(X509Name.DC)) {
            return new DERIA5String(value);
        }
        if (oid.equals(X509Name.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(value);
        }
        if (oid.equals(X509Name.C) || oid.equals(X509Name.SN) || oid.equals(X509Name.DN_QUALIFIER)) {
            return new DERPrintableString(value);
        }
        return new DERUTF8String(value);
    }
}

