/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.bc.asn1.x509;

import com.koalii.bc.asn1.ASN1Encodable;
import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.ASN1TaggedObject;
import com.koalii.bc.asn1.DERBoolean;
import com.koalii.bc.asn1.DERObject;
import com.koalii.bc.asn1.DERObjectIdentifier;
import com.koalii.bc.asn1.DERSequence;
import com.koalii.bc.asn1.x509.X509Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Extensions
extends ASN1Encodable {
    public static final DERObjectIdentifier SubjectDirectoryAttributes = new DERObjectIdentifier("2.5.29.9");
    public static final DERObjectIdentifier SubjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
    public static final DERObjectIdentifier KeyUsage = new DERObjectIdentifier("2.5.29.15");
    public static final DERObjectIdentifier PrivateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
    public static final DERObjectIdentifier SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
    public static final DERObjectIdentifier IssuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
    public static final DERObjectIdentifier BasicConstraints = new DERObjectIdentifier("2.5.29.19");
    public static final DERObjectIdentifier CRLNumber = new DERObjectIdentifier("2.5.29.20");
    public static final DERObjectIdentifier ReasonCode = new DERObjectIdentifier("2.5.29.21");
    public static final DERObjectIdentifier InstructionCode = new DERObjectIdentifier("2.5.29.23");
    public static final DERObjectIdentifier InvalidityDate = new DERObjectIdentifier("2.5.29.24");
    public static final DERObjectIdentifier DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
    public static final DERObjectIdentifier IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
    public static final DERObjectIdentifier CertificateIssuer = new DERObjectIdentifier("2.5.29.29");
    public static final DERObjectIdentifier NameConstraints = new DERObjectIdentifier("2.5.29.30");
    public static final DERObjectIdentifier CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
    public static final DERObjectIdentifier CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
    public static final DERObjectIdentifier PolicyMappings = new DERObjectIdentifier("2.5.29.33");
    public static final DERObjectIdentifier AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
    public static final DERObjectIdentifier PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
    public static final DERObjectIdentifier ExtendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
    public static final DERObjectIdentifier FreshestCRL = new DERObjectIdentifier("2.5.29.46");
    public static final DERObjectIdentifier InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
    public static final DERObjectIdentifier AuthorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    public static final DERObjectIdentifier SubjectInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.11");
    public static final DERObjectIdentifier LogoType = new DERObjectIdentifier("1.3.6.1.5.5.7.1.12");
    public static final DERObjectIdentifier BiometricInfo = new DERObjectIdentifier("1.3.6.1.5.5.7.1.2");
    public static final DERObjectIdentifier QCStatements = new DERObjectIdentifier("1.3.6.1.5.5.7.1.3");
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static X509Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509Extensions getInstance(Object obj) {
        if (obj == null || obj instanceof X509Extensions) {
            return (X509Extensions)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Extensions((ASN1Sequence)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            return X509Extensions.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public X509Extensions(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = ASN1Sequence.getInstance(e.nextElement());
            if (s.size() == 3) {
                this.extensions.put(s.getObjectAt(0), new X509Extension(DERBoolean.getInstance(s.getObjectAt(1)), ASN1OctetString.getInstance(s.getObjectAt(2))));
            } else if (s.size() == 2) {
                this.extensions.put(s.getObjectAt(0), new X509Extension(false, ASN1OctetString.getInstance(s.getObjectAt(1))));
            } else {
                throw new IllegalArgumentException("Bad sequence size: " + s.size());
            }
            this.ordering.addElement(s.getObjectAt(0));
        }
    }

    public X509Extensions(Hashtable extensions) {
        this(null, extensions);
    }

    public X509Extensions(Vector ordering, Hashtable extensions) {
        Enumeration<Object> e = ordering == null ? extensions.keys() : ordering.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)extensions.get(oid);
            this.extensions.put(oid, ext);
        }
    }

    public X509Extensions(Vector objectIDs, Vector values) {
        Enumeration e = objectIDs.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        int count = 0;
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)values.elementAt(count);
            this.extensions.put(oid, ext);
            ++count;
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public X509Extension getExtension(DERObjectIdentifier oid) {
        return (X509Extension)this.extensions.get(oid);
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)this.extensions.get(oid);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(oid);
            if (ext.isCritical()) {
                v.add(new DERBoolean(true));
            }
            v.add(ext.getValue());
            vec.add(new DERSequence(v));
        }
        return new DERSequence(vec);
    }

    public boolean equivalent(X509Extensions other) {
        if (this.extensions.size() != other.extensions.size()) {
            return false;
        }
        Enumeration e1 = this.extensions.keys();
        while (e1.hasMoreElements()) {
            Object key = e1.nextElement();
            if (this.extensions.get(key).equals(other.extensions.get(key))) continue;
            return false;
        }
        return true;
    }
}

