/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.cert;

import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.DERBitString;
import com.koalii.bc.asn1.DEREncodable;
import com.koalii.bc.asn1.DERInteger;
import com.koalii.bc.asn1.DERNull;
import com.koalii.bc.asn1.DERObjectIdentifier;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DEROutputStream;
import com.koalii.bc.asn1.DERSequence;
import com.koalii.bc.asn1.DERUTCTime;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.bc.asn1.x509.BasicConstraints;
import com.koalii.bc.asn1.x509.KeyUsage;
import com.koalii.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.bc.asn1.x509.TBSCertificateStructure;
import com.koalii.bc.asn1.x509.Time;
import com.koalii.bc.asn1.x509.V3TBSCertificateGenerator;
import com.koalii.bc.asn1.x509.X509CertificateStructure;
import com.koalii.bc.asn1.x509.X509Extension;
import com.koalii.bc.asn1.x509.X509Extensions;
import com.koalii.bc.asn1.x509.X509Name;
import com.koalii.bc.util.encoders.Base64;
import com.koalii.cert.PfxStore;
import com.koalii.cert.SecretStore;
import com.koalii.cert.X509CertException;
import com.koalii.cert.X509NameUtil;
import com.koalii.openssl.PEMWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class X509CertGentor {
    public static final int KeyUsage_CA = 6;
    public static final int KeyUsage_UserSign = 232;
    public static final int KeyUsage_UserEncy = 48;
    public static final int KeyUsage_User = 248;
    public static final int CertFile_Der = 0;
    public static final int CertFile_Base64 = 1;
    public static final int CertFile_Pem = 2;
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private X509Name subjectDn = null;
    private Hashtable extensions = new Hashtable();
    private SecretStore issuerStore;

    public X509CertGentor() {
        this.issuerStore = null;
    }

    public X509CertGentor(SecretStore issuer) {
        this.issuerStore = issuer;
    }

    public void reset() {
        this.tbsGen = new V3TBSCertificateGenerator();
        this.subjectDn = null;
        this.extensions.clear();
        this.issuerStore = null;
    }

    public void setSubjectDN(String dn) {
        this.subjectDn = X509NameUtil.toX509Name(dn);
        this.tbsGen.setSubject(this.subjectDn);
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.tbsGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setPublicKey(PublicKey pubkey) {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(pubkey.getEncoded())).readObject()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to process key - " + e.toString());
        }
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new DERUTCTime(date));
    }

    public void setNotBefore() {
        Calendar cd = Calendar.getInstance();
        cd.add(10, -1);
        this.tbsGen.setStartDate(new DERUTCTime(cd.getTime()));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setValidPeriod(int months) {
        Calendar cd = Calendar.getInstance();
        cd.add(10, -1);
        this.tbsGen.setStartDate(new DERUTCTime(cd.getTime()));
        cd.add(2, months);
        this.tbsGen.setEndDate(new DERUTCTime(cd.getTime()));
    }

    public void addExtension(String stroid, boolean critical, DEREncodable value) {
        DERObjectIdentifier oid = new DERObjectIdentifier(stroid);
        this.extensions.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
    }

    public void addKeyUsageExt(int keyUsage) {
        KeyUsage usage = new KeyUsage(keyUsage);
        this.extensions.put(X509Extensions.KeyUsage, new X509Extension(true, (ASN1OctetString)new DEROctetString(usage)));
    }

    public void addBasicConstraints(boolean isCA) {
        BasicConstraints bc = new BasicConstraints(isCA);
        this.extensions.put(X509Extensions.BasicConstraints, new X509Extension(true, (ASN1OctetString)new DEROctetString(bc)));
    }

    public X509Certificate createX509Cert() throws X509CertException {
        X509Name issuerDn = X509NameUtil.toX509Name(this.issuerStore.getCert().getSubjectDN());
        this.tbsGen.setIssuer(issuerDn);
        if (this.extensions != null) {
            this.tbsGen.setExtensions(new X509Extensions(this.extensions));
        }
        DERObjectIdentifier sigOID = new DERObjectIdentifier("1.2.840.113549.1.1.5");
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(sigOID, new DERNull());
        this.tbsGen.setSignature(sigAlgId);
        TBSCertificateStructure tbsCert = this.tbsGen.generateTBSCertificate();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(tbsCert);
            byte[] signData = this.issuerStore.signData(bOut.toByteArray());
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(tbsCert);
            v.add(sigAlgId);
            v.add(new DERBitString(signData));
            X509CertificateStructure x509struct = new X509CertificateStructure(new DERSequence(v));
            ByteArrayInputStream bIn = new ByteArrayInputStream(x509struct.getDEREncoded());
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new X509CertException("exception encoding and sign TBS cert - " + e);
        }
    }

    public X509Certificate createRootCert(KeyPair pair) throws X509CertException {
        this.tbsGen.setIssuer(this.subjectDn);
        try {
            this.tbsGen.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(pair.getPublic().getEncoded())).readObject()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to process key - " + e.toString());
        }
        if (this.extensions != null) {
            this.tbsGen.setExtensions(new X509Extensions(this.extensions));
        }
        DERObjectIdentifier sigOID = new DERObjectIdentifier("1.2.840.113549.1.1.5");
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(sigOID, new DERNull());
        this.tbsGen.setSignature(sigAlgId);
        TBSCertificateStructure tbsCert = this.tbsGen.generateTBSCertificate();
        this.issuerStore = new PfxStore();
        this.issuerStore.setKey(pair.getPrivate());
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(tbsCert);
            byte[] signData = this.issuerStore.signData(bOut.toByteArray());
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(tbsCert);
            v.add(sigAlgId);
            v.add(new DERBitString(signData));
            X509CertificateStructure x509struct = new X509CertificateStructure(new DERSequence(v));
            ByteArrayInputStream bIn = new ByteArrayInputStream(x509struct.getDEREncoded());
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new X509CertException("exception encoding and sign TBS cert - " + e);
        }
    }

    public X509Certificate getIssuerCert() {
        return this.issuerStore.getCert();
    }

    public static void saveX509CertToFile(X509Certificate cert, int fileType, String baseFilename) throws IOException {
        switch (fileType) {
            case 0: {
                FileOutputStream fout = new FileOutputStream(String.valueOf(baseFilename) + ".cer");
                try {
                    fout.write(cert.getEncoded());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fout.flush();
                fout.close();
                break;
            }
            case 1: {
                FileWriter fw = new FileWriter(String.valueOf(baseFilename) + ".b64.cer");
                try {
                    fw.write(new String(Base64.encode(cert.getEncoded())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fw.flush();
                fw.close();
                break;
            }
            case 2: {
                FileWriter fw = new FileWriter(String.valueOf(baseFilename) + ".pem");
                PEMWriter pw = new PEMWriter(new BufferedWriter(fw));
                pw.writeObject(cert);
                pw.flush();
                pw.close();
                break;
            }
            default: {
                throw new IllegalArgumentException("save x509 cert to file " + baseFilename + " error.");
            }
        }
    }

    public static BigInteger generateDefaultSN() {
        long ms = System.currentTimeMillis();
        BigInteger sn = BigInteger.valueOf(ms / 1000L);
        sn = sn.multiply(BigInteger.valueOf(10000L));
        BigInteger random = BigInteger.valueOf(new SecureRandom().nextLong());
        random = random.abs();
        sn = sn.add(random.mod(BigInteger.valueOf(10000L)));
        return sn;
    }

    public static KeyPair generateRsaKeyPair(int strength) throws X509CertException {
        KeyPairGenerator pairgen = null;
        try {
            pairgen = KeyPairGenerator.getInstance("RSA");
        }
        catch (Exception exp) {
            throw new X509CertException(exp);
        }
        pairgen.initialize(strength, new SecureRandom());
        return pairgen.generateKeyPair();
    }
}

