/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.cert;

import com.koalii.bc.util.encoders.Base64;
import com.koalii.openssl.PEMReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class X509CertParser {
    public static X509Certificate[] parseCertFile(String fileName) throws IOException {
        if (fileName.endsWith(".pem") || fileName.endsWith(".PEM")) {
            return X509CertParser.parsePemCertFile(fileName);
        }
        if (fileName.endsWith(".b64.cer")) {
            return X509CertParser.parseB64CertFile(fileName);
        }
        if (fileName.endsWith(".cer") || fileName.endsWith(".cert")) {
            return X509CertParser.parseDerCertFile(fileName);
        }
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        int nlen = bin.available();
        byte[] certData = new byte[nlen];
        bin.read(certData);
        fin.close();
        return X509CertParser.parseCert(certData);
    }

    public static X509Certificate[] parseB64CertFile(String fileName) throws IOException {
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        int nlen = bin.available();
        byte[] b64data = new byte[nlen];
        bin.read(b64data);
        fin.close();
        return X509CertParser.parseB64Cert(new String(b64data));
    }

    public static X509Certificate[] parsePemCertFile(String fileName) throws IOException {
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        int nlen = bin.available();
        byte[] data = new byte[nlen];
        bin.read(data);
        fin.close();
        return X509CertParser.parsePemCert(new String(data));
    }

    public static X509Certificate[] parseDerCertFile(String fileName) throws IOException {
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        int nlen = bin.available();
        byte[] data = new byte[nlen];
        bin.read(data);
        fin.close();
        return X509CertParser.parseDerCert(data);
    }

    public static X509Certificate[] parseCert(byte[] certData) {
        byte abyte = certData[0];
        if (48 == abyte) {
            return X509CertParser.parseDerCert(certData);
        }
        if (77 == abyte) {
            return X509CertParser.parseB64Cert(new String(certData));
        }
        try {
            return X509CertParser.parsePemCert(new String(certData));
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("parse cert error.");
        }
    }

    public static X509Certificate[] parsePemCert(String pemCert) {
        PEMReader reader = new PEMReader(new CharArrayReader(pemCert.toCharArray()));
        Object obj = null;
        ArrayList<Object> certlist = new ArrayList<Object>();
        try {
            while ((obj = reader.readObject()) != null && obj instanceof X509Certificate) {
                certlist.add(obj);
            }
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("parse pem cert error - " + exp.getMessage());
        }
        if (certlist.size() == 0) {
            throw new IllegalArgumentException("no cert in pem");
        }
        X509Certificate[] certs = new X509Certificate[certlist.size()];
        certlist.toArray(certs);
        return certs;
    }

    public static X509Certificate[] parseB64Cert(String b64Cert) {
        return X509CertParser.parseDerCert(Base64.decode(b64Cert.getBytes()));
    }

    public static X509Certificate[] parseDerCert(byte[] derCert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> col = cf.generateCertificates(new ByteArrayInputStream(derCert));
            int clen = col.size();
            X509Certificate[] x509s = new X509Certificate[clen];
            col.toArray(x509s);
            return x509s;
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("parse der cert  - " + exp);
        }
    }
}

