/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.cert;

import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.DERBitString;
import com.koalii.bc.asn1.x509.TBSCertificateStructure;
import com.koalii.bc.asn1.x509.X509CertificateStructure;
import com.koalii.bc.asn1.x509.X509Extension;
import com.koalii.bc.asn1.x509.X509Extensions;
import com.koalii.cert.X509CertException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

public class X509CertVerifier {
    public static final int CertUsage_CA = 6;
    public static final int CertUsage_Sign = 192;
    public static final int CertUsage_Ency = 16;
    private ArrayList certChains = new ArrayList();

    public void reset() {
        this.certChains.clear();
    }

    public void addChain(X509Certificate[] certs) throws X509CertException {
        int nret = X509CertVerifier.checkCertChain(certs);
        if (nret != 0) {
            throw new X509CertException("Illegal trsut cert chain " + nret);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < certs.length) {
            certList.add(certs[i]);
            ++i;
        }
        this.certChains.add(certList);
    }

    public String listCertChains() {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.certChains.size()) {
            ArrayList achain = (ArrayList)this.certChains.get(i);
            int j = 0;
            while (j < achain.size()) {
                X509Certificate cert = (X509Certificate)achain.get(j);
                sbuf.append(cert.getSubjectDN());
                sbuf.append(j == achain.size() - 1 ? "" : " --> ");
                ++j;
            }
            sbuf.append("\n");
            ++i;
        }
        return sbuf.toString();
    }

    public void generateCertChain(X509Certificate[] certs) throws X509CertException {
        int i = 0;
        int j = 0;
        ArrayList<X509Certificate> oriList = new ArrayList<X509Certificate>();
        i = 0;
        while (i < certs.length) {
            j = 0;
            while (j < oriList.size()) {
                if (certs[i].equals((X509Certificate)oriList.get(j))) break;
                ++j;
            }
            if (oriList.size() == j) {
                oriList.add(certs[i]);
            }
            ++i;
        }
        this.certChains.clear();
        while (oriList.size() > 0) {
            X509Certificate first;
            ArrayList<X509Certificate> targetList = new ArrayList<X509Certificate>();
            X509Certificate last = first = (X509Certificate)oriList.get(0);
            targetList.add(first);
            i = 1;
            while (i < oriList.size()) {
                X509Certificate cert = (X509Certificate)oriList.get(i);
                if (cert.getIssuerDN().equals(first.getSubjectDN())) {
                    if (X509CertVerifier.verifyCertSignature(cert, first.getPublicKey()) == 0) {
                        targetList.add(0, cert);
                        first = cert;
                    }
                } else if (cert.getSubjectDN().equals(last.getIssuerDN()) && X509CertVerifier.verifyCertSignature(last, cert.getPublicKey()) == 0) {
                    targetList.add(cert);
                    last = cert;
                }
                ++i;
            }
            X509Certificate[] rescerts = new X509Certificate[targetList.size()];
            targetList.toArray(rescerts);
            this.addChain(rescerts);
            oriList.remove(first);
        }
    }

    public X509Certificate[] getCertChain(int index) {
        ArrayList list = (ArrayList)this.certChains.get(index);
        X509Certificate[] certs = new X509Certificate[list.size()];
        list.toArray(certs);
        return certs;
    }

    public int getCertChainNum() {
        return this.certChains.size();
    }

    public int verifyCertTrust(X509Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("input cert is null");
        }
        if (this.certChains.size() == 0) {
            return 6;
        }
        int i = 0;
        while (i < this.certChains.size()) {
            ArrayList chain = (ArrayList)this.certChains.get(i);
            X509Certificate issuerCert = (X509Certificate)chain.get(0);
            if (cert.getIssuerDN().equals(issuerCert.getSubjectDN())) {
                return X509CertVerifier.verifyCertSignature(cert, issuerCert.getPublicKey());
            }
            ++i;
        }
        return 6;
    }

    public static int checkCertChain(X509Certificate[] certs) {
        int nret;
        if (certs == null || certs.length <= 0) {
            return -1;
        }
        int nCert = certs.length;
        int i = 0;
        while (i < nCert - 1) {
            nret = X509CertVerifier.verifyCertValidity(certs[i]);
            if (nret != 0) {
                return 300 + i;
            }
            if (!certs[i].getIssuerDN().equals(certs[i + 1].getSubjectDN())) {
                return 600 + i;
            }
            nret = X509CertVerifier.verifyCertSignature(certs[i], certs[i + 1].getPublicKey());
            if (nret != 0) {
                return 900 + i;
            }
            ++i;
        }
        nret = X509CertVerifier.verifyCertValidity(certs[nCert - 1]);
        if (nret != 0) {
            return 300 + nCert - 1;
        }
        return 0;
    }

    public static int verifyCertValidity(X509Certificate cert, Date d) {
        if (cert == null) {
            return -1;
        }
        try {
            cert.checkValidity(d);
        }
        catch (CertificateExpiredException exp) {
            return 1;
        }
        catch (CertificateNotYetValidException exp) {
            return 2;
        }
        return 0;
    }

    public static int verifyCertValidity(X509Certificate cert) {
        if (cert == null) {
            return -1;
        }
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException exp) {
            return 1;
        }
        catch (CertificateNotYetValidException exp) {
            return 2;
        }
        return 0;
    }

    public static int verifyCertSignature(X509Certificate cert, PublicKey pubKey) {
        if (cert == null || pubKey == null) {
            return -1;
        }
        try {
            cert.verify(pubKey);
        }
        catch (SignatureException exp) {
            return 1;
        }
        catch (CertificateException exp) {
            return 2;
        }
        catch (InvalidKeyException exp) {
            return 3;
        }
        catch (NoSuchAlgorithmException exp) {
            return 4;
        }
        catch (NoSuchProviderException exp) {
            return 5;
        }
        return 0;
    }

    public static int verifyCertUsage(X509Certificate cert, int targetUsage) {
        try {
            ASN1InputStream ain = new ASN1InputStream(cert.getEncoded());
            X509CertificateStructure x509 = X509CertificateStructure.getInstance(ain.readObject());
            TBSCertificateStructure tbs = x509.getTBSCertificate();
            X509Extensions exts = tbs.getExtensions();
            X509Extension keyUsage = exts.getExtension(X509Extensions.KeyUsage);
            byte[] bs = keyUsage.getValue().getOctets();
            ain = new ASN1InputStream(bs);
            DERBitString bits = DERBitString.getInstance(ain.readObject());
            if ((bits.intValue() & targetUsage) == targetUsage) {
                return 0;
            }
            return -2;
        }
        catch (Exception exp) {
            return -1;
        }
    }
}

