/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.cert;

import com.koalii.bc.asn1.DERObjectIdentifier;
import com.koalii.bc.asn1.x509.X509Name;
import com.koalii.bc.asn1.x509.X509NameTokenizer;
import java.security.Principal;
import java.util.Vector;

public class X509NameUtil {
    public static X509Name toX509Name(Principal dirName) {
        return X509NameUtil.toX509Name(dirName.getName());
    }

    public static X509Name toX509Name(String dirName) {
        X509NameTokenizer nTok = new X509NameTokenizer(dirName);
        boolean isCnFirst = true;
        if (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String name = token.substring(0, index);
            isCnFirst = name.equalsIgnoreCase("CN");
            return new X509Name(!isCnFirst, dirName);
        }
        throw new IllegalArgumentException("badly formated directory string");
    }

    public static String[] getCn(X509Name dn) {
        return X509NameUtil.getRdn(dn, X509Name.CN);
    }

    public static String[] getOu(X509Name dn) {
        return X509NameUtil.getRdn(dn, X509Name.OU);
    }

    public static String[] getO(X509Name dn) {
        return X509NameUtil.getRdn(dn, X509Name.O);
    }

    public static String[] getRdn(X509Name dn, DERObjectIdentifier oid) {
        Vector cns = dn.getValues(oid);
        String[] ss = new String[cns.size()];
        return cns.toArray(ss);
    }

    public static void main(String[] args) throws Exception {
        X509Name dn = X509NameUtil.toX509Name("CN=root, OU=lily");
        System.out.println(dn);
    }
}

