/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.commons.pool.impl;

import com.koalii.commons.pool.BaseObjectPool;
import com.koalii.commons.pool.ObjectPool;
import com.koalii.commons.pool.PoolableObjectFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class StackObjectPool
extends BaseObjectPool
implements ObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected Stack _pool = null;
    protected PoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _numActive = 0;

    public StackObjectPool() {
        this(null, 8, 4);
    }

    public StackObjectPool(int maxIdle) {
        this(null, maxIdle, 4);
    }

    public StackObjectPool(int maxIdle, int initIdleCapacity) {
        this(null, maxIdle, initIdleCapacity);
    }

    public StackObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int maxIdle) {
        this(factory, maxIdle, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int maxIdle, int initIdleCapacity) {
        this._factory = factory;
        this._maxSleeping = maxIdle < 0 ? 8 : maxIdle;
        int initcapacity = initIdleCapacity < 1 ? 4 : initIdleCapacity;
        this._pool = new Stack();
        this._pool.ensureCapacity(initcapacity > this._maxSleeping ? this._maxSleeping : initcapacity);
    }

    public synchronized Object borrowObject() throws Exception {
        this.assertOpen();
        Object obj = null;
        while (obj == null) {
            if (!this._pool.empty()) {
                obj = this._pool.pop();
            } else {
                if (this._factory == null) {
                    throw new NoSuchElementException();
                }
                obj = this._factory.makeObject();
            }
            if (this._factory != null && obj != null) {
                this._factory.activateObject(obj);
            }
            if (this._factory == null || obj == null || this._factory.validateObject(obj)) continue;
            this._factory.destroyObject(obj);
            obj = null;
        }
        ++this._numActive;
        return obj;
    }

    public synchronized void returnObject(Object obj) throws Exception {
        this.assertOpen();
        boolean success = true;
        if (this._factory != null) {
            if (!this._factory.validateObject(obj)) {
                success = false;
            } else {
                try {
                    this._factory.passivateObject(obj);
                }
                catch (Exception e) {
                    success = false;
                }
            }
        }
        boolean shouldDestroy = !success;
        --this._numActive;
        if (success) {
            Object toBeDestroyed = null;
            if (this._pool.size() >= this._maxSleeping) {
                shouldDestroy = true;
                toBeDestroyed = this._pool.remove(0);
            }
            this._pool.push(obj);
            obj = toBeDestroyed;
        }
        this.notifyAll();
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void invalidateObject(Object obj) throws Exception {
        this.assertOpen();
        --this._numActive;
        if (this._factory != null) {
            this._factory.destroyObject(obj);
        }
        this.notifyAll();
    }

    public synchronized int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    public synchronized int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    public synchronized void clear() {
        this.assertOpen();
        if (this._factory != null) {
            Iterator it = this._pool.iterator();
            while (it.hasNext()) {
                try {
                    this._factory.destroyObject(it.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        super.close();
    }

    public synchronized void addObject() throws Exception {
        this.assertOpen();
        Object obj = this._factory.makeObject();
        ++this._numActive;
        this.returnObject(obj);
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

