/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.crypto;

import com.koalii.bc.crypto.KeyGenerationParameters;
import com.koalii.bc.crypto.engines.DESedeEngine;
import com.koalii.bc.crypto.generators.DESedeKeyGenerator;
import com.koalii.bc.crypto.modes.CBCBlockCipher;
import com.koalii.bc.crypto.paddings.PaddedBufferedBlockCipher;
import com.koalii.bc.crypto.params.KeyParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public class DESUtil {
    public static byte[] generateKey(byte[] seed) {
        SecureRandom sr = new SecureRandom();
        if (seed != null) {
            sr.setSeed(seed);
        } else {
            sr.setSeed(System.currentTimeMillis());
        }
        KeyGenerationParameters kgp = new KeyGenerationParameters(sr, 192);
        DESedeKeyGenerator kg = new DESedeKeyGenerator();
        kg.init(kgp);
        return kg.generateKey();
    }

    public static byte[] encrypt(byte[] key, byte[] oridata) throws Exception {
        int outlen;
        int inlen;
        if (key == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        cipher.init(true, new KeyParameter(key));
        int inBlockSize = cipher.getBlockSize() * 10;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        ByteArrayInputStream bin = new ByteArrayInputStream(oridata);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((inlen = bin.read(inblock, 0, inBlockSize)) > 0) {
            outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
            if (outlen <= 0) continue;
            bout.write(outblock, 0, outlen);
        }
        outlen = cipher.doFinal(outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        return bout.toByteArray();
    }

    public static byte[] decrypt(byte[] key, byte[] secretdata) throws Exception {
        if (key == null || secretdata == null) {
            throw new IllegalArgumentException();
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        cipher.init(false, new KeyParameter(key));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] outblock = new byte[cipher.getOutputSize(secretdata.length)];
        int outlen = cipher.processBytes(secretdata, 0, secretdata.length, outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        if ((outlen = cipher.doFinal(outblock, 0)) > 0) {
            bout.write(outblock, 0, outlen);
        }
        return bout.toByteArray();
    }
}

