/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.crypto;

import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.ASN1Sequence;
import com.koalii.bc.asn1.pkcs.PrivateKeyInfo;
import com.koalii.bc.asn1.pkcs.RSAPrivateKeyStructure;
import com.koalii.bc.asn1.x509.RSAPublicKeyStructure;
import com.koalii.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.bc.crypto.encodings.PKCS1Encoding;
import com.koalii.bc.crypto.engines.RSAEngine;
import com.koalii.bc.crypto.params.RSAKeyParameters;
import com.koalii.bc.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RSAUtil {
    private static RSAKeyParameters pubKeyToRSAKey(PublicKey pubkey) throws Exception {
        ASN1InputStream aIn = new ASN1InputStream(pubkey.getEncoded());
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(aIn.readObject());
        RSAPublicKeyStructure pubKey = new RSAPublicKeyStructure((ASN1Sequence)keyInfo.getPublicKey());
        return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
    }

    private static RSAPrivateCrtKeyParameters privKeyToRSAKey(PrivateKey privkey) throws Exception {
        ASN1InputStream aIn = new ASN1InputStream(privkey.getEncoded());
        PrivateKeyInfo keyInfo = PrivateKeyInfo.getInstance(aIn.readObject());
        RSAPrivateKeyStructure keyStructure = new RSAPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
        return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
    }

    private static byte[] engineProcess(PKCS1Encoding engine, byte[] indata) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(indata);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] inblock = new byte[engine.getInputBlockSize()];
        byte[] outblock = null;
        while (bin.available() > 0) {
            int nread = bin.read(inblock);
            outblock = engine.processBlock(inblock, 0, nread);
            bout.write(outblock);
        }
        return bout.toByteArray();
    }

    public static byte[] pubKeyEncrypt(PublicKey pubkey, byte[] oridata) throws Exception {
        if (pubkey == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        RSAKeyParameters rsakey = RSAUtil.pubKeyToRSAKey(pubkey);
        PKCS1Encoding cipher = new PKCS1Encoding(new RSAEngine());
        cipher.init(true, rsakey);
        return RSAUtil.engineProcess(cipher, oridata);
    }

    public static byte[] privKeyDecrypt(PrivateKey privkey, byte[] secretdata) throws Exception {
        if (privkey == null || secretdata == null) {
            throw new IllegalArgumentException();
        }
        RSAPrivateCrtKeyParameters rsakey = RSAUtil.privKeyToRSAKey(privkey);
        PKCS1Encoding cipher = new PKCS1Encoding(new RSAEngine());
        cipher.init(false, rsakey);
        return RSAUtil.engineProcess(cipher, secretdata);
    }

    public static byte[] pubKeyDecrypt(PublicKey pubkey, byte[] secretdata) throws Exception {
        if (pubkey == null || secretdata == null) {
            throw new IllegalArgumentException();
        }
        RSAKeyParameters rsakey = RSAUtil.pubKeyToRSAKey(pubkey);
        PKCS1Encoding cipher = new PKCS1Encoding(new RSAEngine());
        cipher.init(false, rsakey);
        return RSAUtil.engineProcess(cipher, secretdata);
    }

    public static byte[] privKeyEncrypt(PrivateKey privkey, byte[] oridata) throws Exception {
        if (privkey == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        RSAPrivateCrtKeyParameters rsakey = RSAUtil.privKeyToRSAKey(privkey);
        PKCS1Encoding cipher = new PKCS1Encoding(new RSAEngine());
        cipher.init(true, rsakey);
        return RSAUtil.engineProcess(cipher, oridata);
    }
}

