/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.crypto;

import com.koalii.crypto.DigestUtil;
import com.koalii.crypto.RSAUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SignUtil {
    public static byte[] JDKSign(byte[] oridata, PrivateKey privkey) throws Exception {
        return SignUtil.sha1WithRsaJDKSign(oridata, privkey);
    }

    public static byte[] sha1WithRsaJDKSign(byte[] oridata, PrivateKey privkey) throws Exception {
        if (oridata == null || privkey == null) {
            throw new IllegalArgumentException();
        }
        Signature sign = Signature.getInstance("SHA1WithRSA");
        sign.initSign(privkey);
        sign.update(oridata);
        return sign.sign();
    }

    public static boolean JDKVerify(byte[] oridata, byte[] signdata, PublicKey pubkey) throws Exception {
        return SignUtil.sha1WithRsaJDKVerify(oridata, signdata, pubkey);
    }

    public static boolean sha1WithRsaJDKVerify(byte[] oridata, byte[] signdata, PublicKey pubkey) throws Exception {
        if (oridata == null || signdata == null || pubkey == null) {
            throw new IllegalArgumentException();
        }
        Signature sign = Signature.getInstance("SHA1WithRSA");
        sign.initVerify(pubkey);
        sign.update(oridata);
        return sign.verify(signdata);
    }

    public static byte[] sign(byte[] oridata, PrivateKey privkey) throws Exception {
        return SignUtil.sha1WithRsaSign(oridata, privkey);
    }

    public static byte[] sha1WithRsaSign(byte[] oridata, PrivateKey privkey) throws Exception {
        if (oridata == null || privkey == null) {
            throw new IllegalArgumentException();
        }
        byte[] digest = DigestUtil.sha1(oridata);
        return RSAUtil.privKeyEncrypt(privkey, digest);
    }

    public static boolean verify(byte[] oridata, byte[] signdata, PublicKey pubkey) throws Exception {
        return SignUtil.sha1WithRsaVerify(oridata, signdata, pubkey);
    }

    public static boolean sha1WithRsaVerify(byte[] oridata, byte[] signdata, PublicKey pubkey) throws Exception {
        if (oridata == null || signdata == null || pubkey == null) {
            throw new IllegalArgumentException();
        }
        byte[] digest = DigestUtil.sha1(oridata);
        byte[] decryptdata = RSAUtil.pubKeyDecrypt(pubkey, signdata);
        byte[] decrypt = new byte[digest.length];
        if (35 == decryptdata.length) {
            int j = decryptdata.length - 15;
            int i = 0;
            while (i < j) {
                decrypt[i] = decryptdata[i + 15];
                ++i;
            }
            decryptdata = decrypt;
        }
        if (digest.length != decryptdata.length) {
            return false;
        }
        int i = 0;
        while (i < digest.length) {
            if (digest[i] != decryptdata[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

