/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.crypto.encodings;

import com.koalii.crypto.InvalidCipherTextException;
import java.security.SecureRandom;

public class PKCS1Encoding1 {
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private int bitSize;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private int inblockSize;
    private int outblockSize;

    public PKCS1Encoding1(int modulus, boolean forEncryption, boolean forPrivateKey) {
        this.bitSize = modulus;
        this.random = new SecureRandom();
        this.forPrivateKey = forPrivateKey;
        this.forEncryption = forEncryption;
        if (forEncryption) {
            this.inblockSize = (this.bitSize + 7) / 8 - 1;
            this.outblockSize = (this.bitSize + 7) / 8;
        } else {
            this.inblockSize = (this.bitSize + 7) / 8;
            this.outblockSize = (this.bitSize + 7) / 8 - 1;
        }
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return this.inblockSize - 10;
        }
        return this.inblockSize;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.outblockSize;
        }
        return this.outblockSize - 10;
    }

    public byte[] processBlock(byte[] inData, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(inData, inOff, inLen);
        }
        return this.decodeBlock(inData, inOff, inLen);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        block5: {
            block4: {
                if (inLen > this.getInputBlockSize()) {
                    throw new InvalidCipherTextException("input data too large");
                }
                block = new byte[this.inblockSize + 1];
                if (!this.forPrivateKey) break block4;
                block[0] = 0;
                block[1] = 1;
                i = 2;
                while (i != block.length - inLen - 1) {
                    block[i] = -1;
                    ++i;
                }
                break block5;
            }
            this.random.nextBytes(block);
            block[0] = 0;
            block[1] = 2;
            i = 2;
            ** GOTO lbl23
            {
                block[i] = (byte)this.random.nextInt();
                do {
                    if (block[i] == 0) continue block1;
                    ++i;
lbl23:
                    // 2 sources

                } while (i != block.length - inLen - 1);
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return block;
    }

    private byte[] decodeBlock(byte[] block, int inOff, int inLen) throws InvalidCipherTextException {
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        byte type = block[1];
        if (type != 1 && type != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (block.length != this.outblockSize + 1) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        int start = 2;
        while (start != block.length) {
            byte pad = block[start];
            if (pad == 0) break;
            if (type == 1 && pad != -1) {
                throw new InvalidCipherTextException("block padding incorrect");
            }
            ++start;
        }
        if (++start > block.length || start < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[block.length - start];
        System.arraycopy(block, start, result, 0, result.length);
        return result;
    }

    public static void main(String[] args) {
    }
}

