/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.openssl;

import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.util.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PEMReader
extends BufferedReader {
    public PEMReader(Reader reader) {
        super(reader);
    }

    public Object readObject() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (line.indexOf("-----BEGIN PKCS7") != -1) {
                return this.readPKCS7("-----END PKCS7");
            }
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (line.indexOf("-----BEGIN X509 CRL") == -1) continue;
            return this.readCRL("-----END X509 CRL");
        }
        return null;
    }

    private byte[] readBytes(String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(String.valueOf(endMarker) + " not found");
        }
        return Base64.decode(buf.toString());
    }

    private X509Certificate readCertificate(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private X509CRL readCRL(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private ContentInfo readPKCS7(String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) break;
            line = line.trim();
            buf.append(line.trim());
            Base64.decode(buf.substring(0, buf.length() / 4 * 4), bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(String.valueOf(endMarker) + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        try {
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            return ContentInfo.getInstance(aIn.readObject());
        }
        catch (Exception e) {
            throw new IOException("problem parsing PKCS7 object: " + e.toString());
        }
    }
}

