/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.openssl;

import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.util.encoders.Base64;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PEMWriter
extends BufferedWriter {
    public PEMWriter(Writer out) {
        super(out);
    }

    private void writeEncoded(byte[] bytes) throws IOException {
        char[] buf = new char[64];
        bytes = Base64.encode(bytes);
        int i = 0;
        while (i < bytes.length) {
            int index = 0;
            while (index != buf.length) {
                if (i + index >= bytes.length) break;
                buf[index] = (char)bytes[i + index];
                ++index;
            }
            this.write(buf, 0, index);
            this.newLine();
            i += buf.length;
        }
    }

    public void writeObject(Object o) throws IOException {
        byte[] encoding;
        String type;
        if (o instanceof X509Certificate) {
            type = "CERTIFICATE";
            try {
                encoding = ((X509Certificate)o).getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new IOException("Cannot encode object: " + e.toString());
            }
        } else if (o instanceof X509CRL) {
            type = "X509 CRL";
            try {
                encoding = ((X509CRL)o).getEncoded();
            }
            catch (CRLException e) {
                throw new IOException("Cannot encode object: " + e.toString());
            }
        } else if (o instanceof PublicKey) {
            type = "PUBLIC KEY";
            encoding = ((PublicKey)o).getEncoded();
        } else if (o instanceof ContentInfo) {
            type = "PKCS7";
            encoding = ((ContentInfo)o).getEncoded();
        } else {
            throw new IOException("unknown object passed - can't encode.");
        }
        this.write("-----BEGIN " + type + "-----");
        this.newLine();
        this.writeEncoded(encoding);
        this.write("-----END " + type + "-----");
        this.newLine();
    }
}

