/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.pkcs7;

import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DERSet;
import com.koalii.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.bc.asn1.cms.EnvelopedData;
import com.koalii.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.bc.asn1.cms.KeyTransRecipientInfo;
import com.koalii.bc.asn1.cms.RecipientIdentifier;
import com.koalii.bc.asn1.cms.RecipientInfo;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.bc.asn1.x509.X509Name;
import com.koalii.cert.SecretStore;
import com.koalii.cert.X509NameUtil;
import com.koalii.crypto.DESUtil;
import com.koalii.crypto.RSAUtil;
import com.koalii.pkcs7.PKCS7Exception;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

public class PKCS7EnvelopUtil {
    private SecretStore decryptStore;

    public PKCS7EnvelopUtil(SecretStore decrypt) {
        this.decryptStore = decrypt;
    }

    public static byte[] createEnvelop(X509Certificate encryptcert, byte[] oridata) throws PKCS7Exception {
        if (encryptcert == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name(encryptcert.getIssuerDN()), encryptcert.getSerialNumber());
        byte[] key = DESUtil.generateKey(null);
        byte[] encryptkey = null;
        try {
            encryptkey = RSAUtil.pubKeyEncrypt(encryptcert.getPublicKey(), key);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        KeyTransRecipientInfo recinfo = new KeyTransRecipientInfo(new RecipientIdentifier(isn), new AlgorithmIdentifier(CMSObjectIdentifiers.rsaEncryption), new DEROctetString(encryptkey));
        ASN1EncodableVector recinfos = new ASN1EncodableVector();
        recinfos.add(new RecipientInfo(recinfo));
        byte[] encdata = null;
        try {
            encdata = DESUtil.encrypt(key, oridata);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        EncryptedContentInfo enccont = new EncryptedContentInfo(CMSObjectIdentifiers.data, new AlgorithmIdentifier(CMSObjectIdentifiers.des_EDE3_CBC), new DEROctetString(encdata));
        EnvelopedData evpdata = new EnvelopedData(null, new DERSet(recinfos), enccont, null);
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.envelopedData, evpdata);
        return p7.getDEREncoded();
    }

    public byte[] parseEnvelop(byte[] evpdata) throws PKCS7Exception {
        if (evpdata == null) {
            throw new IllegalArgumentException();
        }
        if (this.decryptStore == null) {
            throw new PKCS7Exception("not find decrypt store");
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (edata == null) {
            throw new PKCS7Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new PKCS7Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        if (!recinfo.getKeyEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.rsaEncryption)) {
            throw new PKCS7Exception("unsupported encrypt key alg " + recinfo.getKeyEncryptionAlgorithm().getObjectId());
        }
        byte[] encryptkey = recinfo.getEncryptedKey().getOctets();
        byte[] key = null;
        try {
            key = RSAUtil.privKeyDecrypt(this.decryptStore.getPrivKey(), encryptkey);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        EncryptedContentInfo enccont = edata.getEncryptedContentInfo();
        if (!enccont.getContentEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.des_EDE3_CBC)) {
            throw new PKCS7Exception("unsupported encrypt content alg " + enccont.getContentEncryptionAlgorithm().getObjectId());
        }
        byte[] oridata = null;
        try {
            oridata = DESUtil.decrypt(key, enccont.getEncryptedContent().getOctets());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        return oridata;
    }

    public static byte[] parseEnvelop(SecretStore store, byte[] evpdata) throws PKCS7Exception {
        PKCS7EnvelopUtil envutil = new PKCS7EnvelopUtil(store);
        return envutil.parseEnvelop(evpdata);
    }

    public static X509Name getRecipientIssuerDN(byte[] evpdata) throws PKCS7Exception {
        return PKCS7EnvelopUtil.getIssuerDnAndSN(evpdata).getName();
    }

    public static BigInteger getRecipientSN(byte[] evpdata) throws PKCS7Exception {
        return PKCS7EnvelopUtil.getIssuerDnAndSN(evpdata).getSerialNumber().getPositiveValue();
    }

    protected static IssuerAndSerialNumber getIssuerDnAndSN(byte[] evpdata) throws PKCS7Exception {
        if (evpdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (edata == null) {
            throw new PKCS7Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new PKCS7Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        IssuerAndSerialNumber ias = null;
        try {
            ias = IssuerAndSerialNumber.getInstance(new ASN1InputStream(recinfo.getRecipientIdentifier().getDEREncoded()).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        return ias;
    }
}

