/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.pkcs7;

import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DERSet;
import com.koalii.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.bc.asn1.cms.SignedData;
import com.koalii.bc.asn1.cms.SignerIdentifier;
import com.koalii.bc.asn1.cms.SignerInfo;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.cert.SecretStore;
import com.koalii.cert.X509CertParser;
import com.koalii.cert.X509NameUtil;
import com.koalii.crypto.SignUtil;
import com.koalii.pkcs7.PKCS7Exception;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class PKCS7SignUtil {
    private SecretStore signerStore;

    public PKCS7SignUtil(SecretStore signer) {
        this.signerStore = signer;
    }

    public byte[] createSign(byte[] oriData) throws PKCS7Exception {
        if (oriData == null) {
            throw new IllegalArgumentException();
        }
        if (this.signerStore == null || this.signerStore.getCert() == null) {
            throw new PKCS7Exception("Not find signer store");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(new AlgorithmIdentifier("1.3.14.3.2.26"));
        String digestEncryptionAlgorithm = this.signerStore.getAlgorithm();
        if (digestEncryptionAlgorithm.equals("RSA")) {
            digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (digestEncryptionAlgorithm.equals("DSA")) {
            digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new PKCS7Exception("Unknown Key Algorithm " + digestEncryptionAlgorithm);
        }
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(this.signerStore.getCert().getEncoded()).readObject());
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        byte[] signedData = null;
        try {
            signedData = this.signerStore.signData(oriData);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        ContentInfo cinfo = new ContentInfo(CMSObjectIdentifiers.data, new DEROctetString(oriData));
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name(this.signerStore.getCert().getIssuerDN()), this.signerStore.getCert().getSerialNumber());
        SignerInfo signer = new SignerInfo(new SignerIdentifier(isn), new AlgorithmIdentifier("1.3.14.3.2.26"), null, new AlgorithmIdentifier(digestEncryptionAlgorithm), new DEROctetString(signedData), null);
        ASN1EncodableVector signers = new ASN1EncodableVector();
        signers.add(signer);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(signers));
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.signedData, sdata);
        return p7.getDEREncoded();
    }

    public static byte[] createSign(SecretStore signer, byte[] oriData) throws PKCS7Exception {
        PKCS7SignUtil p7util = new PKCS7SignUtil(signer);
        return p7util.createSign(oriData);
    }

    public byte[] createDetachSign(byte[] oriData) throws PKCS7Exception {
        if (oriData == null) {
            throw new IllegalArgumentException();
        }
        if (this.signerStore == null || this.signerStore.getCert() == null) {
            throw new PKCS7Exception("Not find signer store");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(new AlgorithmIdentifier("1.3.14.3.2.26"));
        String digestEncryptionAlgorithm = this.signerStore.getAlgorithm();
        if (digestEncryptionAlgorithm.equals("RSA")) {
            digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (digestEncryptionAlgorithm.equals("DSA")) {
            digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new PKCS7Exception("Unknown Key Algorithm " + digestEncryptionAlgorithm);
        }
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(this.signerStore.getCert().getEncoded()).readObject());
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        byte[] signedData = null;
        try {
            signedData = this.signerStore.signData(oriData);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        ContentInfo cinfo = new ContentInfo(CMSObjectIdentifiers.data, null);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name(this.signerStore.getCert().getIssuerDN()), this.signerStore.getCert().getSerialNumber());
        SignerInfo signer = new SignerInfo(new SignerIdentifier(isn), new AlgorithmIdentifier("1.3.14.3.2.26"), null, new AlgorithmIdentifier(digestEncryptionAlgorithm), new DEROctetString(signedData), null);
        ASN1EncodableVector signers = new ASN1EncodableVector();
        signers.add(signer);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(signers));
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.signedData, sdata);
        return p7.getDEREncoded();
    }

    public static byte[] createDetachSign(SecretStore signer, byte[] oriData) throws PKCS7Exception {
        PKCS7SignUtil p7util = new PKCS7SignUtil(signer);
        return p7util.createDetachSign(oriData);
    }

    public static boolean verifySign(byte[] signdata, byte[] oridata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.signedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        ContentInfo encapContent = sdata.getEncapContentInfo();
        if (!encapContent.getContentType().equals(CMSObjectIdentifiers.data)) {
            throw new PKCS7Exception("illegal encapture content type " + encapContent.getContentType().getId());
        }
        byte[] oriToSign = null;
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        if (octets == null) {
            if (oridata == null) {
                throw new IllegalArgumentException("no oridata");
            }
            oriToSign = oridata;
        } else if (oridata != null) {
            oriToSign = octets.getOctets();
            if (oriToSign.length != oridata.length) {
                return false;
            }
            int i = 0;
            i = 0;
            while (i < oriToSign.length) {
                if (oriToSign[i] != oridata[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            oriToSign = octets.getOctets();
        }
        SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
        if (!signer.getDigestAlgorithm().equals(new AlgorithmIdentifier("1.3.14.3.2.26"))) {
            throw new PKCS7Exception("unsupported hash alg " + signer.getDigestAlgorithm().toString());
        }
        if (sdata.getCertificates() == null || sdata.getCertificates().size() <= 0) {
            throw new PKCS7Exception("not find sign cert");
        }
        X509Certificate[] scerts = X509CertParser.parseDerCert(sdata.getCertificates().getObjectAt(0).getDERObject().getDEREncoded());
        try {
            return SignUtil.sha1WithRsaVerify(oriToSign, signer.getEncryptedDigest().getOctets(), scerts[0].getPublicKey());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
    }

    public static X509Certificate[] getSignCerts(byte[] signdata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        return X509CertParser.parseDerCert(sdata.getCertificates().getObjectAt(0).getDERObject().getDEREncoded());
    }

    public static byte[] getOriData(byte[] signdata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        ContentInfo encapContent = sdata.getEncapContentInfo();
        if (!encapContent.getContentType().equals(CMSObjectIdentifiers.data)) {
            throw new PKCS7Exception("illegal encapture content type " + encapContent.getContentType().getId());
        }
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        return octets.getOctets();
    }
}

