/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.sock.client;

import com.koalii.sock.client.TcpSockClient;
import com.koalii.util.encoders.Base64;
import com.koalii.util.log.LogUtil;

public class SockClientPool {
    private static final int SOCKCLIENTPOOL_MAX_SIZE = 200;
    private static final int SOCKCLIENTPOOL_DEFAULT_SIZE = 30;
    private static final int SOCKCLIENTPOOL_DEFAULT_IDLE_SEC = 300;
    private TcpSockClient[] m_socks = null;
    private int m_max_size = 200;
    private int m_max_idle_sec = 300;
    private String m_remote_host;
    private int m_remote_port;
    private int m_timeout_sec;
    private boolean m_is_set_retry = false;
    private int m_retry_times;
    private int m_retry_wait_sec;

    public synchronized void init(String host, int port, int timeout_sec) {
        int nsize = 30;
        this.m_socks = new TcpSockClient[nsize];
        int i = 0;
        while (i < nsize) {
            this.m_socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (this.m_is_set_retry) {
                this.m_socks[i].setRetry(this.m_retry_times, this.m_retry_wait_sec);
            }
            ++i;
        }
        this.m_remote_host = host;
        this.m_remote_port = port;
        this.m_timeout_sec = timeout_sec;
    }

    public synchronized void init(String host, int port, int timeout_sec, int nconcurrent) {
        int nsize = 0;
        if (nconcurrent <= 0) {
            nsize = 30;
        } else if (nconcurrent <= 200) {
            nsize = nconcurrent;
        } else {
            nsize = nconcurrent;
            this.m_max_size = nconcurrent;
        }
        this.m_socks = new TcpSockClient[nsize];
        int i = 0;
        while (i < nsize) {
            this.m_socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (this.m_is_set_retry) {
                this.m_socks[i].setRetry(this.m_retry_times, this.m_retry_wait_sec);
            }
            ++i;
        }
        this.m_remote_host = host;
        this.m_remote_port = port;
        this.m_timeout_sec = timeout_sec;
    }

    public synchronized void init(String host, int port, int timeout_sec, int nconcurrent, int nmax_size) {
        int nsize = 0;
        nsize = nconcurrent <= 0 ? 30 : nconcurrent;
        this.m_socks = new TcpSockClient[nsize];
        int i = 0;
        while (i < nsize) {
            this.m_socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (this.m_is_set_retry) {
                this.m_socks[i].setRetry(this.m_retry_times, this.m_retry_wait_sec);
            }
            ++i;
        }
        this.m_remote_host = host;
        this.m_remote_port = port;
        this.m_timeout_sec = timeout_sec;
        this.m_max_size = nmax_size > nconcurrent ? nmax_size : nconcurrent;
    }

    public void setRetry(int nretry, int retry_wait_sec) {
        this.m_is_set_retry = true;
        this.m_retry_times = nretry;
        this.m_retry_wait_sec = retry_wait_sec;
        if (this.m_socks != null) {
            int nsize = this.m_socks.length;
            int i = 0;
            while (i < nsize) {
                this.m_socks[i].setRetry(this.m_retry_times, this.m_retry_wait_sec);
                ++i;
            }
        }
    }

    public synchronized void clean() {
        if (this.m_socks == null) {
            return;
        }
        int i = 0;
        while (i < this.m_socks.length) {
            this.m_socks[i].close();
            this.m_socks[i] = null;
            ++i;
        }
        this.m_socks = null;
    }

    public synchronized void clean_idle() {
        if (this.m_socks == null || this.m_max_idle_sec <= 0) {
            return;
        }
        int i = 0;
        while (i < this.m_socks.length) {
            this.m_socks[i].close_timeout(this.m_max_idle_sec);
            ++i;
        }
    }

    public synchronized TcpSockClient pop() {
        if (this.m_socks == null) {
            return null;
        }
        this.clean_idle();
        int i = 0;
        while (i < this.m_socks.length) {
            if (!this.m_socks[i].isBusy()) {
                this.m_socks[i].setBusy(true);
                LogUtil.info(String.valueOf(this.toString()) + ", poped " + this.m_socks[i].toString());
                return this.m_socks[i];
            }
            ++i;
        }
        if (this.m_socks.length >= this.m_max_size) {
            LogUtil.info(String.valueOf(this.toString()) + ", pool is full");
            return null;
        }
        int nsize = this.m_socks.length * 2 < this.m_max_size ? this.m_socks.length * 2 : this.m_max_size;
        TcpSockClient[] tmp = new TcpSockClient[nsize];
        int i2 = 0;
        while (i2 < this.m_socks.length) {
            tmp[i2] = this.m_socks[i2];
            ++i2;
        }
        i2 = this.m_socks.length;
        while (i2 < nsize) {
            tmp[i2] = new TcpSockClient(this.m_remote_host, this.m_remote_port, this.m_timeout_sec);
            if (this.m_is_set_retry) {
                tmp[i2].setRetry(this.m_retry_times, this.m_retry_wait_sec);
            }
            ++i2;
        }
        int nindex = this.m_socks.length;
        this.m_socks = tmp;
        this.m_socks[nindex].setBusy(true);
        LogUtil.info(String.valueOf(this.toString()) + ", poped " + this.m_socks[nindex].toString());
        return this.m_socks[nindex];
    }

    public synchronized void push(TcpSockClient sock) {
        sock.setBusy(false);
        LogUtil.info(String.valueOf(this.toString()) + ", pushed " + sock.toString());
        this.clean_idle();
    }

    public void setConcurrent(int nconcurrent) {
        this.clean();
        int nsize = 0;
        if (nconcurrent <= 0) {
            nsize = 30;
        } else if (nconcurrent <= 200) {
            nsize = nconcurrent;
            this.m_max_size = 200;
        } else {
            nsize = nconcurrent;
            this.m_max_size = nconcurrent;
        }
        this.m_socks = new TcpSockClient[nsize];
        int i = 0;
        while (i < nsize) {
            this.m_socks[i] = new TcpSockClient(this.m_remote_host, this.m_remote_port, this.m_timeout_sec);
            if (this.m_is_set_retry) {
                this.m_socks[i].setRetry(this.m_retry_times, this.m_retry_wait_sec);
            }
            ++i;
        }
    }

    public void setMaxIdleTime(int seconds) {
        this.m_max_idle_sec = seconds;
    }

    public int getMaxIdleTime() {
        return this.m_max_idle_sec;
    }

    public synchronized int getBusySize() {
        if (this.m_socks == null) {
            return 0;
        }
        int nbusy = 0;
        int i = 0;
        while (i < this.m_socks.length) {
            if (this.m_socks[i].isBusy()) {
                ++nbusy;
            }
            ++i;
        }
        return nbusy;
    }

    public synchronized int getValidSize() {
        if (this.m_socks == null) {
            return 0;
        }
        int nvalid = 0;
        int i = 0;
        while (i < this.m_socks.length) {
            if (!this.m_socks[i].isClosed()) {
                ++nvalid;
            }
            ++i;
        }
        return nvalid;
    }

    public synchronized int getSize() {
        if (this.m_socks == null) {
            return 0;
        }
        return this.m_socks.length;
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.m_socks == null) {
            sbuf.append("[pool is null] ");
            return sbuf.toString();
        }
        sbuf.append("[pool total " + this.getSize() + ", busy " + this.getBusySize() + ", valid " + this.getValidSize() + "]");
        return sbuf.toString();
    }

    public synchronized String toMoreString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.m_socks == null) {
            sbuf.append("[pool is null] ");
            return sbuf.toString();
        }
        sbuf.append("[pool total " + this.getSize() + ", busy " + this.getBusySize() + ", valid " + this.getValidSize() + "]");
        int i = 0;
        while (i < this.m_socks.length) {
            if (this.m_socks[i].isBusy() || !this.m_socks[i].isClosed()) {
                if (this.m_socks[i].isBusy()) {
                    sbuf.append("\n[busy]");
                } else {
                    sbuf.append("\n[idle]");
                }
                if (this.m_socks[i].isClosed()) {
                    sbuf.append("[closed]");
                } else {
                    sbuf.append("[connected]");
                    sbuf.append(this.m_socks[i].toString());
                }
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        String oridata = "koalii";
        String b64ori = new String(Base64.encode(oridata.getBytes()));
        StringBuffer req = new StringBuffer();
        req.append("<?xml version=\"1.0\" encoding=\"gb2312\"?>");
        req.append("<msg><msg_head><msg_type>0</msg_type><msg_id>1007</msg_id><msg_sn>0</msg_sn><version>1</version></msg_head><msg_body>");
        req.append("<origin_data_len>");
        req.append(b64ori.length());
        req.append("</origin_data_len>");
        req.append("<origin_data>");
        req.append(b64ori);
        req.append("</origin_data>");
        req.append("</msg_body></msg>");
        SockClientPool scpool = new SockClientPool();
        scpool.init("192.168.171.8", 5000, 30, 10);
        System.out.println(scpool.toString());
        byte[] resp = null;
        TcpSockClient sclient = null;
        int i = 0;
        while (i < 30) {
            sclient = scpool.pop();
            resp = sclient.sendAndRecv(req.toString());
            System.out.println(scpool.toMoreString());
            scpool.push(sclient);
            ++i;
        }
        System.out.println(scpool.toMoreString());
        scpool.clean();
    }
}

