/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.sock.client;

import com.koalii.sock.client.TcpSockClientException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class TcpSockClient {
    public static final int DEFAULT_SOCKET_TIMEOUT_SEC = 3;
    public static final int DEFAULT_RECONNECT_WAITTIME_SEC = 3;
    private String m_remote_host = null;
    private int m_remote_port = 0;
    private int m_sock_timeout_sec = 3;
    private int m_wait_sec = 3;
    private Socket m_sock_fd = null;
    private OutputStream m_os = null;
    private InputStream m_is = null;

    public TcpSockClient(String host, int port) {
        this.m_remote_host = host;
        this.m_remote_port = port;
    }

    public TcpSockClient(String host, int port, int timeout_sec, int wait_sec) {
        this.m_remote_host = host;
        this.m_remote_port = port;
        if (timeout_sec >= 0) {
            this.m_sock_timeout_sec = timeout_sec;
        }
        if (wait_sec >= 0) {
            this.m_wait_sec = wait_sec;
        }
    }

    public boolean init() {
        this.close();
        try {
            this.m_sock_fd = new Socket(this.m_remote_host, this.m_remote_port);
            this.m_sock_fd.setSoTimeout(this.m_sock_timeout_sec * 1000);
            this.m_os = this.m_sock_fd.getOutputStream();
            this.m_is = this.m_sock_fd.getInputStream();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void close() {
        try {
            if (this.m_os != null) {
                this.m_os.flush();
                this.m_os.close();
                this.m_os = null;
            }
            if (this.m_is != null) {
                this.m_is.close();
                this.m_is = null;
            }
            if (this.m_sock_fd != null) {
                this.m_sock_fd.close();
                this.m_sock_fd = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send(byte[] data, int offset, int len) throws TcpSockClientException {
        if (data == null || offset < 0 || offset >= data.length) {
            throw new TcpSockClientException(1001);
        }
        if (this.m_os == null) {
            throw new TcpSockClientException(1003);
        }
        try {
            this.m_os.write(data, offset, len);
        }
        catch (IOException e) {
            throw new TcpSockClientException(1003, (Throwable)e);
        }
    }

    public byte[] recv() throws TcpSockClientException {
        if (this.m_is == null) {
            throw new TcpSockClientException(1004);
        }
        BufferedInputStream bufin = new BufferedInputStream(this.m_is);
        byte[] retdata = null;
        try {
            byte first = (byte)bufin.read();
            int nLen = bufin.available();
            retdata = new byte[1 + nLen];
            retdata[0] = first;
            bufin.read(retdata, 1, nLen);
        }
        catch (IOException e) {
            throw new TcpSockClientException(1004, (Throwable)e);
        }
        return retdata;
    }

    public byte[] sendAndRecv(String data) throws TcpSockClientException {
        return this.sendAndRecv(data.getBytes(), 0, data.getBytes().length);
    }

    public byte[] sendAndRecv(byte[] data) throws TcpSockClientException {
        return this.sendAndRecv(data, 0, data.length);
    }

    public byte[] sendAndRecv(byte[] data, int offset, int len) throws TcpSockClientException {
        int ntimes = 3;
        TcpSockClientException exp = null;
        int i = 0;
        while (i < ntimes) {
            try {
                this.send(data, offset, len);
                return this.recv();
            }
            catch (TcpSockClientException e) {
                if (1003 == e.getErrorNo() || 1004 == e.getErrorNo()) {
                    this.close();
                    exp = e;
                    if (i != ntimes - 1 && this.m_wait_sec > 0) {
                        try {
                            Thread.sleep(this.m_wait_sec * 1000);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } else {
                    throw new TcpSockClientException(e);
                }
                this.init();
                ++i;
            }
        }
        throw new TcpSockClientException(exp);
    }

    public int getRemotePort() {
        return this.m_remote_port;
    }

    public String getRemoteHost() {
        return this.m_remote_host;
    }

    public void setRemotePort(int i) {
        this.m_remote_port = i;
    }

    public void setIP(String host) {
        this.m_remote_host = host;
    }

    public void setSockTimeoutSec(int seconds) {
        this.m_sock_timeout_sec = seconds;
    }

    public int getSockTimeoutSec() {
        return this.m_sock_timeout_sec;
    }

    public void setWaitSec(int sec) {
        this.m_wait_sec = sec >= 0 ? sec : 3;
    }

    public int getWaitSec() {
        return this.m_wait_sec;
    }
}

