/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.sock.client;

import com.koalii.commons.pool.BasePoolableObjectFactory;
import com.koalii.sock.client.TcpSockClient;
import com.koalii.sock.client.TcpSockClientException;

public class TcpSockClientFactory
extends BasePoolableObjectFactory {
    private String m_remote_host = null;
    private int m_remote_port = 0;
    private int m_sock_timeout_sec = 3;
    private int m_wait_sec = 3;

    public TcpSockClientFactory(String host, int port) {
        this.m_remote_host = host;
        this.m_remote_port = port;
    }

    public TcpSockClientFactory(String host, int port, int timeout_sec, int wait_sec) {
        this.m_remote_host = host;
        this.m_remote_port = port;
        if (timeout_sec >= 0) {
            this.m_sock_timeout_sec = timeout_sec;
        }
        if (wait_sec >= 0) {
            this.m_wait_sec = wait_sec;
        }
    }

    public Object makeObject() throws Exception {
        TcpSockClient sockclient = new TcpSockClient(this.m_remote_host, this.m_remote_port, this.m_sock_timeout_sec, this.m_wait_sec);
        if (sockclient == null || !sockclient.init()) {
            throw new TcpSockClientException(1002);
        }
        return sockclient;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof TcpSockClient) {
            ((TcpSockClient)obj).close();
        }
    }

    public void passivateObject(Object obj) throws Exception {
    }

    public boolean validateObject(Object obj) {
        return true;
    }
}

