/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.crypto.RSAUtil;
import com.koalii.crypto.SignUtil;
import com.koalii.svs.SecretStore;
import com.koalii.svs.SecretStoreException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PfxStore
extends SecretStore {
    public PfxStore() {
    }

    public PfxStore(String pfxFileName, String passwd) throws SecretStoreException {
        this.setCertAndKey(pfxFileName, passwd);
    }

    public PfxStore(InputStream fileInputStream, String passwd) throws SecretStoreException {
        this.setCertAndKey(fileInputStream, passwd);
    }

    @Override
    public String getAlgorithm() {
        if (this.privKey != null) {
            return this.privKey.getAlgorithm();
        }
        return "";
    }

    public void setCertAndKey(String pfxFileName, String passwd) throws SecretStoreException {
        boolean bRet;
        String alias;
        KeyStore ks;
        if (passwd == null || passwd.length() <= 0) {
            throw new SecretStoreException("Password cannot be empty");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            FileInputStream fin = new FileInputStream(pfxFileName);
            ks.load(fin, passwd.toCharArray());
            Enumeration<String> en = ks.aliases();
            alias = en.nextElement();
            bRet = ks.isKeyEntry(alias);
        }
        catch (Exception exp) {
            throw new SecretStoreException("load pfx file " + pfxFileName + " - " + exp);
        }
        if (!bRet) {
            throw new SecretStoreException("No key is found in pfx file");
        }
        try {
            this.privKey = (PrivateKey)ks.getKey(alias, passwd.toCharArray());
            this.signCert = (X509Certificate)ks.getCertificate(alias);
        }
        catch (Exception exp) {
            throw new SecretStoreException(exp);
        }
    }

    public void setCertAndKey(InputStream fileInputStream, String passwd) throws SecretStoreException {
        boolean bRet;
        String alias;
        KeyStore ks;
        if (passwd == null || passwd.length() <= 0) {
            throw new SecretStoreException("Password cannot be empty");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(fileInputStream, passwd.toCharArray());
            Enumeration<String> en = ks.aliases();
            alias = en.nextElement();
            bRet = ks.isKeyEntry(alias);
        }
        catch (Exception exp) {
            throw new SecretStoreException("load pfx file  - " + exp);
        }
        if (!bRet) {
            throw new SecretStoreException("No key is found in pfx file");
        }
        try {
            this.privKey = (PrivateKey)ks.getKey(alias, passwd.toCharArray());
            this.signCert = (X509Certificate)ks.getCertificate(alias);
        }
        catch (Exception exp) {
            throw new SecretStoreException(exp);
        }
    }

    protected boolean isMatched() {
        if (this.signCert == null || this.privKey == null) {
            return false;
        }
        byte[] oriData = new String("123456").getBytes();
        try {
            byte[] signdata = SignUtil.sign(oriData, this.privKey);
            return SignUtil.verify(oriData, signdata, this.signCert.getPublicKey());
        }
        catch (Exception exp) {
            return false;
        }
    }

    @Override
    public byte[] encryptData(byte[] oriData) throws SecretStoreException {
        if (oriData == null) {
            throw new IllegalArgumentException();
        }
        byte[] secret = null;
        try {
            secret = RSAUtil.privKeyEncrypt(this.privKey, oriData);
        }
        catch (Exception exp) {
            throw new SecretStoreException(exp);
        }
        return secret;
    }

    @Override
    public byte[] decryptData(byte[] secretData) throws SecretStoreException {
        if (secretData == null) {
            throw new IllegalArgumentException();
        }
        byte[] plain = null;
        try {
            plain = RSAUtil.privKeyDecrypt(this.privKey, secretData);
        }
        catch (Exception exp) {
            throw new SecretStoreException(exp);
        }
        return plain;
    }

    @Override
    public byte[] signData(byte[] oridata) throws SecretStoreException {
        try {
            return SignUtil.sha1WithRsaSign(oridata, this.privKey);
        }
        catch (Exception exp) {
            throw new SecretStoreException(exp);
        }
    }

    public void toPfxFile(String filename, String passwd) throws SecretStoreException {
        try {
            Certificate[] certs = new Certificate[]{this.signCert};
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            ks.setKeyEntry("koalii", this.privKey, passwd.toCharArray(), certs);
            FileOutputStream fout = new FileOutputStream(filename);
            ks.store(fout, passwd.toCharArray());
            fout.close();
        }
        catch (Exception exp) {
            throw new SecretStoreException("Save cert and key to pfx file - " + exp);
        }
    }
}

