/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.svs.SecretStore;
import com.koalii.svs.X509CertChecker;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS7;

public class SvsBase {
    public static final String SHA1 = "SHA1";
    public static final String MD5 = "MD5";
    public static final String MD2 = "MD2";
    public static final String RSA = "RSA";
    public static final String DSA = "DSA";
    protected String cryptAlg = "RSA";
    protected String digestAlg = "SHA1";
    protected X509Certificate signCert;
    protected SecretStore signerStore;
    protected X509CertChecker certChecker;

    public static String version() {
        return new String("1.1");
    }

    public void initSignCertFile(String fileName) throws Exception {
        this.signCert = null;
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        if (bin.available() > 0) {
            this.signCert = (X509Certificate)cf.generateCertificate(bin);
        }
    }

    public void initSignCert(String szB64Cert) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(SvsBase.base64Decode(szB64Cert));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        if (bin.available() > 0) {
            this.signCert = (X509Certificate)cf.generateCertificate(bin);
        }
    }

    public void initSignCert(X509Certificate cert) {
        this.signCert = cert;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    public String getEncodedSignCert() throws Exception {
        return SvsBase.base64Encode(this.signCert.getEncoded());
    }

    public void setCertChecker(X509CertChecker checker) {
        this.certChecker = checker;
    }

    public X509CertChecker getCertChecker() {
        return this.certChecker;
    }

    public int checkSignCert() {
        return X509CertChecker.checkCertValidity(this.signCert);
    }

    public int checkSignCert(X509Certificate issuerCert) {
        if (issuerCert == null) {
            return -1;
        }
        int nret = X509CertChecker.checkCertValidity(this.signCert);
        if (nret != 0) {
            return nret;
        }
        return X509CertChecker.checkCertSignature(this.signCert, issuerCert.getPublicKey());
    }

    public int localCheckSignCert() {
        if (this.certChecker == null) {
            return -1;
        }
        return this.certChecker.localCheck(this.signCert);
    }

    public int remoteCheckSignCert() {
        if (this.certChecker == null) {
            return -1;
        }
        return this.certChecker.remoteCheck(this.signCert);
    }

    public void setDigestAlg(String algName) {
        if (algName.equalsIgnoreCase(SHA1) || algName.equalsIgnoreCase(MD5) || algName.equalsIgnoreCase(MD2)) {
            this.digestAlg = algName;
        }
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public static String base64Encode(byte[] data) {
        BASE64Encoder b64Enc = new BASE64Encoder();
        String strRet = b64Enc.encode(data);
        strRet = strRet.replaceAll("\r\n", "");
        strRet = strRet.replaceAll("\n", "");
        strRet = strRet.replaceAll(" ", "");
        strRet = strRet.replaceAll("\t", "");
        return strRet;
    }

    public static byte[] base64Decode(String strData) throws IOException {
        BASE64Decoder b64Dec = new BASE64Decoder();
        return b64Dec.decodeBuffer(strData);
    }

    public static X509Certificate parseX509CertFile(String szCertFileame) throws Exception {
        FileInputStream fin = new FileInputStream(szCertFileame);
        BufferedInputStream bin = new BufferedInputStream(fin);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        if (bin.available() > 0) {
            return (X509Certificate)cf.generateCertificate(bin);
        }
        return null;
    }

    public static X509Certificate parseX509Cert(String szB64Cert) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(SvsBase.base64Decode(szB64Cert));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        if (bin.available() > 0) {
            return (X509Certificate)cf.generateCertificate(bin);
        }
        return null;
    }

    public static void dumpPkcs7(byte[] pkcs7Data) throws Exception {
        PKCS7 p7 = new PKCS7(pkcs7Data);
        System.out.println(p7.toString());
    }

    public static void dumpPkcs7(String szB64Pkcs7Data) throws Exception {
        PKCS7 p7 = new PKCS7(SvsBase.base64Decode(szB64Pkcs7Data));
        System.out.println(p7.toString());
    }

    protected static byte[] digestFile(String fileName, String alg) throws NoSuchAlgorithmException, IOException {
        int nr;
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        MessageDigest md = MessageDigest.getInstance(alg);
        DigestInputStream din = new DigestInputStream(bin, md);
        byte[] data = new byte[4096];
        while ((nr = din.read(data, 0, 4096)) != -1) {
        }
        return din.getMessageDigest().digest();
    }
}

