/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.svs.SvsBase;
import com.koalii.svs.SvsException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;

public class SvsHelper
extends SvsBase {
    public static byte[] getOriData(String pkcs7B64Data) throws SvsException {
        if (pkcs7B64Data == null) {
            throw new IllegalArgumentException();
        }
        try {
            PKCS7 p7 = new PKCS7(SvsHelper.base64Decode(pkcs7B64Data));
            return p7.getContentInfo().getContent().getDataBytes();
        }
        catch (ParsingException e) {
            throw new SvsException("Data format error ,can not parse to p7");
        }
        catch (IOException e) {
            throw new SvsException("IOException:" + e.getMessage());
        }
    }

    public static X509Certificate[] getCerts(String pkcs7B64Data) throws SvsException {
        X509Certificate[] certs = null;
        try {
            PKCS7 p7 = new PKCS7(SvsHelper.base64Decode(pkcs7B64Data));
            certs = p7.getCertificates();
        }
        catch (ParsingException e) {
            throw new SvsException("Data format error ,can not parse to p7");
        }
        catch (IOException e) {
            throw new SvsException("IOException:" + e.getMessage());
        }
        return certs;
    }

    public static String[] getSubjectInfo(X509Certificate cert, String key) {
        String KEY = key.toUpperCase();
        ArrayList<String> list = new ArrayList<String>();
        String s = cert.getSubjectDN().getName();
        String[] ss = s.split(",");
        int i = 0;
        while (i < ss.length) {
            if (ss[i].trim().startsWith(String.valueOf(KEY) + "=")) {
                String[] ss2 = ss[i].split("=");
                list.add(ss2[1].trim());
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String base64EncodeCert(X509Certificate cert) {
        try {
            return SvsHelper.base64Encode(cert.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return "";
        }
    }

    public static X509Certificate base64DecodeCert(String base64Cert) throws Exception {
        X509Certificate cert = null;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(SvsHelper.base64Decode(base64Cert));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bin.available() > 0) {
                    cert = (X509Certificate)cf.generateCertificate(bin);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (CertificateException e) {
                throw e;
            }
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                    bin = null;
                }
                catch (IOException iOException) {}
            }
        }
        return cert;
    }
}

