/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.bc.asn1.ASN1EncodableVector;
import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.DEROctetString;
import com.koalii.bc.asn1.DERSet;
import com.koalii.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.bc.asn1.cms.SignedData;
import com.koalii.bc.asn1.cms.SignerIdentifier;
import com.koalii.bc.asn1.cms.SignerInfo;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.cert.X509NameUtil;
import com.koalii.svs.PfxStore;
import com.koalii.svs.SecretStoreException;
import com.koalii.svs.SvsBase;
import com.koalii.svs.SvsException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;

public class SvsSign
extends SvsBase {
    private PrivateKey privKey;

    public void initSignCertAndKey(String pfxFileName, String passwd) throws Exception {
        if (passwd == null || passwd.length() <= 0) {
            throw new SvsException("Password cannot be empty");
        }
        PfxStore store = new PfxStore(pfxFileName, passwd);
        this.signerStore = store;
        this.privKey = store.getPrivKey();
        this.signCert = store.getCert();
    }

    public void initSignCertAndKey(InputStream fileInputStream, String passwd) throws SecretStoreException, SvsException {
        if (passwd == null || passwd.length() <= 0) {
            throw new SvsException("Password cannot be empty");
        }
        PfxStore store = new PfxStore(fileInputStream, passwd);
        this.signerStore = store;
        this.privKey = store.getPrivKey();
        this.signCert = store.getCert();
    }

    public String signData(byte[] originData, int offset, int len) throws Exception {
        Signature sign = Signature.getInstance(String.valueOf(this.digestAlg) + "with" + this.cryptAlg);
        sign.initSign(this.privKey);
        sign.update(originData, offset, len);
        return SvsSign.base64Encode(sign.sign());
    }

    public String signData(byte[] originData) throws Exception {
        return this.signData(originData, 0, originData.length);
    }

    public String signFile(String fileName) throws Exception {
        byte[] digestData = SvsSign.digestFile(fileName, this.digestAlg);
        return this.signData(digestData, 0, digestData.length);
    }

    public String pkcs7SignData(byte[] originData) throws Exception {
        Signature sign = Signature.getInstance(String.valueOf(this.digestAlg) + "with" + this.cryptAlg);
        sign.initSign(this.privKey);
        sign.update(originData);
        return SvsSign.base64Encode(this.creatPkcs7(originData, sign.sign()));
    }

    public String pkcs7DetachSignData(byte[] originData) throws Exception {
        Signature sign = Signature.getInstance(String.valueOf(this.digestAlg) + "with" + this.cryptAlg);
        sign.initSign(this.privKey);
        sign.update(originData);
        return SvsSign.base64Encode(this.creatPkcs7(null, sign.sign()));
    }

    public String pkcs7SignFile(String fileName) throws Exception {
        byte[] digestData = SvsSign.digestFile(fileName, this.digestAlg);
        Signature sign = Signature.getInstance(String.valueOf(this.digestAlg) + "with" + this.cryptAlg);
        sign.initSign(this.privKey);
        String strB64 = SvsSign.base64Encode(digestData);
        sign.update(strB64.getBytes());
        return SvsSign.base64Encode(this.creatPkcs7(strB64.getBytes(), sign.sign()));
    }

    public static String sign(byte[] originData, String pfxFileName, String passwd) throws Exception {
        SvsSign sign = new SvsSign();
        sign.initSignCertAndKey(pfxFileName, passwd);
        return sign.signData(originData);
    }

    protected byte[] creatPkcs7(byte[] originData, byte[] signedData) throws Exception {
        ASN1EncodableVector digestAlgorithmIds = new ASN1EncodableVector();
        digestAlgorithmIds.add(new AlgorithmIdentifier("1.3.14.3.2.26"));
        String digestEncryptionAlgorithm = this.signerStore.getAlgorithm();
        if (digestEncryptionAlgorithm.equals("RSA")) {
            digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (digestEncryptionAlgorithm.equals("DSA")) {
            digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        }
        ContentInfo cinfo = null;
        cinfo = originData == null ? new ContentInfo(ContentInfo.data, null) : new ContentInfo(CMSObjectIdentifiers.data, new DEROctetString(originData));
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name(this.signCert.getIssuerDN()), this.signCert.getSerialNumber());
        SignerInfo signer = new SignerInfo(new SignerIdentifier(isn), new AlgorithmIdentifier("1.3.14.3.2.26"), null, new AlgorithmIdentifier(digestEncryptionAlgorithm), new DEROctetString(signedData), null);
        ASN1EncodableVector signers = new ASN1EncodableVector();
        signers.add(signer);
        ASN1EncodableVector certificates = new ASN1EncodableVector();
        try {
            certificates.add(new ASN1InputStream(this.signCert.getEncoded()).readObject());
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        SignedData sdata = new SignedData(new DERSet(digestAlgorithmIds), cinfo, new DERSet(certificates), null, new DERSet(signers));
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.signedData, sdata);
        return p7.getDEREncoded();
    }
}

