/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.bc.asn1.ASN1InputStream;
import com.koalii.bc.asn1.ASN1OctetString;
import com.koalii.bc.asn1.cms.ContentInfo;
import com.koalii.bc.asn1.cms.SignedData;
import com.koalii.bc.asn1.cms.SignerInfo;
import com.koalii.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.cert.X509CertParser;
import com.koalii.crypto.SignUtil;
import com.koalii.svs.SvsBase;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

public class SvsVerify
extends SvsBase {
    public static final int VERIFY_FAILED = 1;
    public static final int NO_SUCH_ALG_EXP = 1010;
    public static final int NO_DIGEST_ALG_EXP = 1011;
    public static final int NO_SIGN_ALG_EXP = 1012;
    public static final int B64_DECODE_IO_EXP = 1021;
    public static final int FILE_IO_EXP = 1022;
    public static final int PKCS7_PARSE_EXP = 1031;
    public static final int PKCS7_NO_SIGN_CERT = 1032;
    public static final int INVALID_KEY_EXP = 1041;
    public static final int SIGN_EXP = 1042;
    public static final int OTHER_EXP = 2000;

    public int verifySign(byte[] originData, int offset, int len, String szB64SignedData) {
        try {
            Signature sign = Signature.getInstance(String.valueOf(this.digestAlg) + "with" + this.cryptAlg);
            sign.initVerify(this.signCert);
            sign.update(originData, offset, len);
            byte[] signedData = SvsVerify.base64Decode(szB64SignedData);
            if (sign.verify(signedData)) {
                return 0;
            }
            return 1;
        }
        catch (NoSuchAlgorithmException exp) {
            return 1012;
        }
        catch (InvalidKeyException exp) {
            return 1041;
        }
        catch (SignatureException exp) {
            return 1042;
        }
        catch (IOException exp) {
            return 1021;
        }
        catch (Exception exp) {
            return 2000;
        }
    }

    public int verifySign(byte[] originData, String szB64SignedData) {
        return this.verifySign(originData, 0, originData.length, szB64SignedData);
    }

    public int verifyFileSign(String fileName, String szB64SignedData) throws Exception {
        byte[] digesData = SvsVerify.digestFile(fileName, this.digestAlg);
        return this.verifySign(digesData, 0, digesData.length, szB64SignedData);
    }

    public int verifyPkcs7Sign(byte[] originData, String szPkcs7B64Data) {
        ContentInfo cinfo;
        byte[] signedData;
        if (originData == null || szPkcs7B64Data == null) {
            return -1;
        }
        try {
            signedData = SvsVerify.base64Decode(szPkcs7B64Data);
        }
        catch (IOException e) {
            return 1021;
        }
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signedData).readObject());
        }
        catch (IOException e) {
            return 1031;
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        ContentInfo encapContent = sdata.getEncapContentInfo();
        byte[] oriToSign = null;
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        if (octets == null) {
            if (originData == null) {
                throw new IllegalArgumentException("no oridata");
            }
            oriToSign = originData;
        } else if (originData != null) {
            oriToSign = octets.getOctets();
            if (oriToSign.length != originData.length) {
                return 1;
            }
            int i = 0;
            i = 0;
            while (i < oriToSign.length) {
                if (oriToSign[i] != originData[i]) {
                    return 1;
                }
                ++i;
            }
        } else {
            oriToSign = octets.getOctets();
        }
        SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
        if (!signer.getDigestAlgorithm().equals(new AlgorithmIdentifier("1.3.14.3.2.26"))) {
            return 1012;
        }
        if (sdata.getCertificates() == null || sdata.getCertificates().size() <= 0) {
            return 1032;
        }
        X509Certificate[] scerts = X509CertParser.parseDerCert(sdata.getCertificates().getObjectAt(0).getDERObject().getDEREncoded());
        try {
            if (SignUtil.sha1WithRsaVerify(oriToSign, signer.getEncryptedDigest().getOctets(), scerts[0].getPublicKey())) {
                return 0;
            }
            return 1042;
        }
        catch (Exception exp) {
            return 2000;
        }
    }

    public int verifyPkcs7SignFile(String szFileName, String szPkcs7B64Data) {
        byte[] digestData;
        ContentInfo cinfo;
        byte[] signedData;
        try {
            signedData = SvsVerify.base64Decode(szPkcs7B64Data);
        }
        catch (IOException e) {
            return 1021;
        }
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signedData).readObject());
        }
        catch (IOException e) {
            return 1031;
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        ContentInfo encapContent = sdata.getEncapContentInfo();
        Object oriToSign = null;
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
        if (!signer.getDigestAlgorithm().equals(new AlgorithmIdentifier("1.3.14.3.2.26"))) {
            return 1012;
        }
        try {
            digestData = SvsVerify.digestFile(szFileName, "1.3.14.3.2.26");
        }
        catch (IOException exp) {
            return 1022;
        }
        catch (NoSuchAlgorithmException exp) {
            return 1011;
        }
        String strB64 = SvsVerify.base64Encode(digestData);
        return this.verifyPkcs7Sign(strB64.getBytes(), szPkcs7B64Data);
    }

    public static int verify(byte[] originData, String szB64SignedData, String szCertFileName) throws Exception {
        SvsVerify very = new SvsVerify();
        very.initSignCertFile(szCertFileName);
        return very.verifySign(originData, szB64SignedData);
    }
}

