/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.svs.SockClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class UdpSockClient
extends SockClient {
    private static final int MAX_SOCKET_WAITTIME = 500000;
    private static final int MIN_SOCKET_WAITTIME = 6000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 3000;
    private String m_szHost = null;
    private int m_nPort = 0;
    private Socket m_sockUDP = null;
    private OutputStream m_os = null;
    private InputStream m_is = null;
    private int m_nSockTimeout = 3000;
    private int m_nWaitTime = 6000;

    public UdpSockClient(String host, int port) {
        this.m_szHost = host;
        this.m_nPort = port;
    }

    public void init() throws IOException {
        this.m_sockUDP = new Socket(this.m_szHost, this.m_nPort, false);
        this.m_sockUDP.setSoTimeout(this.m_nSockTimeout);
        this.m_os = this.m_sockUDP.getOutputStream();
        this.m_is = this.m_sockUDP.getInputStream();
    }

    public void close() {
        try {
            try {
                if (this.m_os != null) {
                    this.m_os.flush();
                    this.m_os.close();
                }
                if (this.m_is != null) {
                    this.m_is.close();
                }
                if (this.m_sockUDP != null) {
                    this.m_sockUDP.close();
                }
            }
            catch (Exception exception) {
                this.m_sockUDP = null;
                this.m_os = null;
                this.m_is = null;
            }
        }
        finally {
            this.m_sockUDP = null;
            this.m_os = null;
            this.m_is = null;
        }
    }

    @Override
    public String sendAndRecv(String data) throws IOException {
        this.m_os.write(data.getBytes());
        return this.recv();
    }

    public String recv() throws IOException {
        int nLoopCount = this.m_nWaitTime / this.m_nSockTimeout + (this.m_nWaitTime % this.m_nSockTimeout == 0 ? 0 : 1);
        int nLen = 0;
        byte[] buff = new byte[8192];
        int n = 0;
        while (n < nLoopCount) {
            nLen = this.m_is.read(buff, 0, 8192);
            if (nLen > 0) break;
            ++n;
        }
        if (nLen == 0 || nLen == -1) {
            return null;
        }
        return new String(buff, 0, nLen);
    }

    public int getPort() {
        return this.m_nPort;
    }

    public String getHost() {
        return this.m_szHost;
    }

    public void setPort(int i) {
        this.m_nPort = i;
    }

    public void setHost(String string) {
        this.m_szHost = string;
    }

    public int getSockTimeout() {
        return this.m_nSockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.m_nSockTimeout = sockTimeout;
    }

    public int getWaitTime() {
        return this.m_nWaitTime;
    }

    public void setWaitTime(int waitTime) {
        this.m_nWaitTime = waitTime >= 6000 && waitTime <= 500000 ? waitTime : 6000;
    }
}

