/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs;

import com.koalii.svs.SvsBase;
import com.koalii.svs.UdpSockClient;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class X509CertChecker {
    private String svsHost = "";
    private int svsPort = 0;
    private ArrayList certChains = new ArrayList();

    public void reset() {
        this.certChains.clear();
        this.svsHost = "";
        this.svsPort = 0;
    }

    public int addCertChain(X509Certificate[] certs) {
        if (certs == null || certs.length <= 0) {
            return -1;
        }
        int nret = X509CertChecker.checkCertChain(certs);
        if (nret != 0) {
            return nret;
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < certs.length) {
            certList.add(certs[i]);
            ++i;
        }
        this.certChains.add(certList);
        return 0;
    }

    public void setRemoteHost(String host, int port) {
        this.svsHost = host;
        this.svsPort = port;
    }

    public int localCheck(X509Certificate cert) {
        if (cert == null) {
            return -1;
        }
        int nret = X509CertChecker.checkCertValidity(cert);
        if (nret != 0) {
            return 3;
        }
        boolean finded = false;
        int i = 0;
        while (i < this.certChains.size()) {
            ArrayList currentChain = (ArrayList)this.certChains.get(i);
            int j = 0;
            while (j < currentChain.size()) {
                X509Certificate currentCert = (X509Certificate)currentChain.get(j);
                if (cert.getIssuerDN().equals(currentCert.getSubjectDN())) {
                    if (X509CertChecker.checkCertSignature(cert, currentCert.getPublicKey()) == 0) {
                        return 0;
                    }
                    finded = true;
                }
                ++j;
            }
            ++i;
        }
        return finded ? 5 : 4;
    }

    public int remoteCheck(X509Certificate cert) {
        String szB64Cert;
        if (cert == null || this.svsHost == null || this.svsHost.length() <= 0 || this.svsPort <= 0) {
            return -1;
        }
        try {
            szB64Cert = SvsBase.base64Encode(cert.getEncoded());
        }
        catch (Exception exp) {
            return -2;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<msg>");
        sbuf.append("<msg_head>");
        sbuf.append("<msg_type>0</msg_type>");
        sbuf.append("<msg_id>1000</msg_id>");
        sbuf.append("<msg_sn>0</msg_sn>");
        sbuf.append("<version>1</version>");
        sbuf.append("</msg_head>");
        sbuf.append("<msg_body>");
        sbuf.append("<ocsp_flag>0</ocsp_flag>");
        sbuf.append("<crl_flag>1</crl_flag>");
        sbuf.append("<b64_cert>" + szB64Cert + "</b64_cert>");
        sbuf.append("</msg_body>");
        sbuf.append("</msg>");
        String szEcho = "";
        int i = 0;
        while (i < 3) {
            UdpSockClient udpClient = new UdpSockClient(this.svsHost, this.svsPort);
            try {
                udpClient.init();
                szEcho = udpClient.sendAndRecv(sbuf.toString());
            }
            catch (SocketTimeoutException exp) {
                return -3;
            }
            catch (Exception exp) {
                return -4;
            }
            if (szEcho != null && szEcho.length() > 0) {
                udpClient.close();
                break;
            }
            udpClient.close();
            ++i;
        }
        if (szEcho == null || szEcho.length() <= 0) {
            return -1;
        }
        String szRet = X509CertChecker.getXPathValue("/msg/msg_body/error_no", szEcho);
        int nRet = szRet == null ? 0 : Integer.parseInt(szRet);
        return nRet;
    }

    public static String getXPathValue(String szPath, String szData) {
        ArrayList<String> nameList = new ArrayList<String>();
        int nBegin = 0;
        int nEnd = 0;
        if ('/' == szPath.charAt(0)) {
            nBegin = 1;
        }
        while (true) {
            if (-1 == (nEnd = szPath.indexOf("/", nBegin))) {
                if (nBegin >= szPath.length()) break;
                nameList.add(szPath.substring(nBegin));
                break;
            }
            nameList.add(szPath.substring(nBegin, nEnd));
            nBegin = nEnd + 1;
        }
        String szRet = szData;
        int i = 0;
        while (i < nameList.size()) {
            szRet = X509CertChecker.parseXml((String)nameList.get(i), szRet);
            if (szRet == null) {
                return null;
            }
            ++i;
        }
        return szRet;
    }

    protected static String parseXml(String name, String szData) {
        String szHead = "<" + name + ">";
        String szTail = "</" + name + ">";
        int nbegin = szData.indexOf(szHead);
        if (-1 == nbegin) {
            return null;
        }
        int nEnd = szData.indexOf(szTail);
        if (-1 == nEnd) {
            return null;
        }
        return szData.substring(nbegin + szHead.length(), nEnd);
    }

    public static int checkCertValidity(X509Certificate cert) {
        if (cert == null) {
            return -1;
        }
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException exp) {
            return 1;
        }
        catch (CertificateNotYetValidException exp) {
            return 2;
        }
        return 0;
    }

    public static int checkCertSignature(X509Certificate cert, PublicKey pubKey) {
        if (cert == null || pubKey == null) {
            return -1;
        }
        try {
            cert.verify(pubKey);
        }
        catch (SignatureException exp) {
            return 1;
        }
        catch (CertificateException exp) {
            return 2;
        }
        catch (InvalidKeyException exp) {
            return 3;
        }
        catch (NoSuchAlgorithmException exp) {
            return 4;
        }
        catch (NoSuchProviderException exp) {
            return 5;
        }
        return 0;
    }

    public static X509Certificate parseX509Cert(String fileName) throws Exception {
        FileInputStream fin = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(fin);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        if (bin.available() > 0) {
            return (X509Certificate)cf.generateCertificate(bin);
        }
        return null;
    }

    public static int checkCertChain(X509Certificate[] certs) {
        int nret;
        if (certs == null || certs.length <= 0) {
            return -1;
        }
        int nCert = certs.length;
        int i = 0;
        while (i < nCert - 1) {
            nret = X509CertChecker.checkCertValidity(certs[i]);
            if (nret != 0) {
                return 300 + i;
            }
            if (!certs[i].getIssuerDN().equals(certs[i + 1].getSubjectDN())) {
                return 600 + i;
            }
            nret = X509CertChecker.checkCertSignature(certs[i], certs[i + 1].getPublicKey());
            if (nret != 0) {
                return 900 + i;
            }
            ++i;
        }
        nret = X509CertChecker.checkCertValidity(certs[nCert - 1]);
        if (nret != 0) {
            return 300 + nCert - 1;
        }
        if (certs[nCert - 1].getSubjectDN().equals(certs[nCert - 1].getIssuerDN()) && (nret = X509CertChecker.checkCertSignature(certs[nCert - 1], certs[nCert - 1].getPublicKey())) != 0) {
            return 900 + nCert - 1;
        }
        return 0;
    }

    public static int checkCert(X509Certificate pCert, X509Certificate cert) {
        if (pCert == null || cert == null) {
            return -1;
        }
        int nret = X509CertChecker.checkCertValidity(cert);
        if (nret != 0) {
            return 300;
        }
        if (!cert.getIssuerDN().equals(pCert.getSubjectDN())) {
            return 600;
        }
        nret = X509CertChecker.checkCertSignature(cert, pCert.getPublicKey());
        if (nret != 0) {
            return 900;
        }
        nret = X509CertChecker.checkCertValidity(pCert);
        if (nret != 0) {
            return 400;
        }
        if (pCert.getSubjectDN().equals(pCert.getIssuerDN()) && (nret = X509CertChecker.checkCertSignature(pCert, pCert.getPublicKey())) != 0) {
            return 1000;
        }
        return 0;
    }

    public static int checkCertNotCheckTime(X509Certificate pCert, X509Certificate cert) {
        if (pCert == null || cert == null) {
            return -1;
        }
        if (!cert.getIssuerDN().equals(pCert.getSubjectDN())) {
            return 600;
        }
        int nret = X509CertChecker.checkCertSignature(cert, pCert.getPublicKey());
        if (nret != 0) {
            return 900;
        }
        if (pCert.getSubjectDN().equals(pCert.getIssuerDN()) && (nret = X509CertChecker.checkCertSignature(pCert, pCert.getPublicKey())) != 0) {
            return 1000;
        }
        return 0;
    }
}

