/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client;

import com.koalii.asn1.ASN1InputStream;
import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.ASN1Set;
import com.koalii.asn1.DERObjectIdentifier;
import com.koalii.asn1.pkcs.ContentInfo;
import com.koalii.asn1.pkcs.IssuerAndSerialNumber;
import com.koalii.asn1.pkcs.SignedData;
import com.koalii.asn1.pkcs.SignerInfo;
import com.koalii.asn1.x509.X509CertificateStructure;
import com.koalii.asn1.x509.X509Extension;
import com.koalii.asn1.x509.X509Extensions;
import com.koalii.asn1.x509.X509Name;
import com.koalii.cert.X509CertParser;
import com.koalii.cert.X509NameUtil;
import com.koalii.crypto.DESUtil;
import com.koalii.sock.client.SockClientPool;
import com.koalii.sock.client.TcpSockClient;
import com.koalii.sock.client.TcpSockClientException;
import com.koalii.svs.client.Svs2ClientException;
import com.koalii.svs.enums.PKCS7Opts;
import com.koalii.util.cert.X509Cert;
import com.koalii.util.digest.Sm3WithSm2;
import com.koalii.util.encoders.Base64;
import com.koalii.util.log.LogUtil;
import com.koalii.util.pkcs7.PKCS7EnvelopUtil;
import com.koalii.util.pkcs7.PKCS7Exception;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Svs2ClientHelper {
    public static final int DIGEST_ALGO_NONE = -1;
    public static final int DIGEST_ALGO_MD5 = 1;
    public static final int DIGEST_ALGO_SHA1 = 2;
    public static final int DIGEST_ALGO_SHA256 = 3;
    public static final int DIGEST_ALGO_SHA512 = 4;
    public static final int DIGEST_ALGO_SM3 = 5;
    public static final int DIGEST_ALGO_SM3WITHSM2 = 6;
    public static final String DIGEST_NAME_NONE = "";
    public static final String DIGEST_NAME_MD5 = "MD5";
    public static final String DIGEST_NAME_SHA1 = "SHA1";
    public static final String DIGEST_NAME_SHA256 = "SHA256";
    public static final String DIGEST_NAME_SHA512 = "SHA512";
    public static final String DIGEST_NAME_SM3 = "SM3";
    public static final String DIGEST_NAME_SM3WITHSM2 = "SM3WITHSM2";
    public static final String DIGEST_ALIAS_MD5 = "MD-5";
    public static final String DIGEST_ALIAS_SHA1 = "SHA-1";
    public static final String DIGEST_ALIAS_SHA256 = "SHA-256";
    public static final String DIGEST_ALIAS_SHA512 = "SHA-512";
    public static final int MAX_EVP_DATA_LEN = 102400;
    protected SockClientPool m_sock_pool = null;
    protected String m_remote_host = "";
    protected int m_remote_port = 0;
    protected int m_timeout_sec = 30;
    protected boolean m_use_pool = true;
    protected boolean m_use_lb = false;
    private boolean m_is_set_retry = false;
    private int m_retry_times;
    private int m_retry_wait_sec;
    private static final int MSG_ID_VERIFY_CERT = 1000;
    private static final int MSG_ID_VERIFY_SIGN = 1001;
    private static final int MSG_ID_PKCS7_SIGN = 1005;
    private static final int MSG_ID_PKCS7_VERIFY = 1006;
    private static final int MSG_ID_SIGN = 1007;
    private static final int MSG_ID_PKCS7_DETACHE_SIGN = 1040;
    private static final int MSG_ID_PKCS7_DETACHE_VERIFY = 1041;
    private static final int MSG_ID_PKCS7_DETACHE_VERIFY_EXT = 1042;
    private static final int MSG_ID_SM2_VERIFY_SIGN = 1201;
    private static final int MSG_ID_SM2_SIGN = 1207;
    private static final int MSG_ID_SM2_PKCS7_SIGN = 1205;
    private static final int MSG_ID_SM2_PKCS7_VERIFY = 1206;
    private static final int MSG_ID_SM2_PKCS7_DETACH_SIGN = 1208;
    private static final int MSG_ID_SM2_PKCS7_DETACH_VERIFY = 1209;
    private static final int MSG_ID_CDB_SIGN = 1500;
    private static final int MSG_ID_CDB_VERIFY_SIGN = 1501;
    private static final int MSG_ID_CDB_PKCS7_DETACH_SIGN_EXT = 1504;
    private static final int MSG_ID_CDB_PKCS7_DETACH_VERIFY_EXT_CNAPS = 1505;
    private static final int MSG_ID_CDB_GET_CERT_LIST = 1511;
    private static final int MSG_ID_CDB_GET_CERT_ALIAS_LIST = 1552;
    private static final int MSG_ID_CDB_GET_SIGNCERT_LIST = 1551;
    private static final int MSG_ID_CDB_GET_SIGNCERT_ALIAS_LIST = 1553;
    private static final int MSG_ID_CDB_GET_SIGNCERT = 1554;
    private static final int MSG_ID_CDB_PKCS7_SIGN = 1526;
    private static final int MSG_ID_CDB_PKCS7_VERIFY = 1527;
    private static final int MSG_ID_CDB_PKCS7_DETACH_VERIFY_EXT = 1506;
    private static final int MSG_ID_CDB_PKCS7_ENVELOP_ENCRYPT = 1521;
    private static final int MSG_ID_CDB_PKCS7_ENVELOP_DECRYPT = 1522;
    private static final int MSG_ID_CDB_PUBLIC_KEY_ENCRYPT = 1531;
    private static final int MSG_ID_CDB_PRIVATE_KEY_DECRYPT = 1533;
    private static final int MSG_ID_CDB_PKCS7_DETACH_SIGN_BY_DIGEST = 1570;
    private static final int MSG_ID_CDB_PKCS7_DETACH_VERIFY_BY_DIGEST = 1571;
    private static final int MSG_ID_CDB_PKCS7_ATTACHED_AUTH_SIGN = 1822;
    private static final int MSG_ID_CDB_PKCS7_ATTACHED_AUTH_VERIFY = 1823;
    private static final int MSG_ID_CDB_PKCS7_DETACHED_AUTH_SIGN = 1824;
    private static final int MSG_ID_CDB_PKCS7_DETACHED_AUTH_VERIFY = 1825;
    private static final int MSG_ID_CDB_SIGN_DATA_BY_DIGEST = 1826;
    private static final int MSG_ID_CDB_VERIFY_SIGN_BY_DIGEST = 1827;
    private static final int MSG_ID_CDB_SIGN_WITH_USERID = 1828;
    private static final int MSG_ID_CDB_VERIFY_SIGN_WITH_USERID = 1829;
    private static final int KSVSC_MESSAGE_VERSION_1 = 1;
    private static final String KSVSC_MESSAGE_ENCODING_1 = "gb2312";
    private static final int KSVSC_MESSAGE_VERSION_2 = 2;
    private static final String KSVSC_MESSAGE_ENCODING_2 = "utf-8";
    private static final int MSG_ID_GET_KEY_TYPE = 1517;
    private PKCS7Opts PKCS7Opts;
    private Map<String, String> privKeyPasswd = new HashMap<String, String>();
    private int m_msgVersion = 2;
    private String m_msgEncoding = "utf-8";
    public static final String version = "2.6.9";
    private static final Map<String, String> oidMap = new HashMap<String, String>(){
        {
            this.put("1.2.840.113549.2.2", "MD2");
            this.put("1.2.840.113549.2.4", "MD4");
            this.put("1.2.840.113549.2.5", Svs2ClientHelper.DIGEST_NAME_MD5);
            this.put("1.3.14.3.2.26", Svs2ClientHelper.DIGEST_NAME_SHA1);
            this.put("2.16.840.1.101.3.4.2.1", Svs2ClientHelper.DIGEST_NAME_SHA256);
            this.put("2.16.840.1.101.3.4.2.2", "SHA384");
            this.put("2.16.840.1.101.3.4.2.3", Svs2ClientHelper.DIGEST_NAME_SHA512);
            this.put("1.2.840.113549.1.1.5", "RSA");
            this.put("1.2.840.113549.1.1.1", "RSA");
            this.put("1.2.156.10197.1.401", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.401.1", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.401.2", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.301", "SM2");
            this.put("1.2.156.10197.1.301.1", "SM2");
            this.put("1.2.156.10197.1.301.2", "SM2");
            this.put("1.2.156.10197.1.301.3", "SM2");
            this.put("1.2.156.10197.1.104", "SM4");
            this.put("1.2.840.10045.2.1", "ECC");
            this.put("1.2.156.10197.1.501", "SM2");
        }
    };
    private static Svs2ClientHelper m_helper;

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        m_helper = null;
    }

    protected Svs2ClientHelper() {
    }

    public static String version() {
        return version;
    }

    public void setLogFile(String filePath) {
        if (filePath == null) {
            LogUtil.clean();
        } else {
            LogUtil.init(filePath);
        }
    }

    public void setMessageVersion(int ver) {
        this.m_msgVersion = 1 == ver ? 1 : 2;
    }

    public static Svs2ClientHelper getInstance() {
        if (m_helper == null) {
            m_helper = new Svs2ClientHelper();
        }
        return m_helper;
    }

    public void clean() {
        if (this.m_sock_pool != null) {
            try {
                LogUtil.info("closing the pool");
                this.m_sock_pool.clean();
            }
            catch (Exception e) {
                LogUtil.error("close the pool failed: " + e.getMessage());
            }
            this.m_sock_pool = null;
        }
    }

    public boolean initNoPool(String remotehost, int port, int timeout_sec) {
        if (remotehost == null || remotehost.length() == 0 || port <= 0) {
            return false;
        }
        this.m_remote_host = remotehost;
        this.m_remote_port = port;
        this.m_timeout_sec = timeout_sec;
        this.m_use_pool = false;
        LogUtil.info("init api without pool, ip is:" + this.m_remote_host + " port is:" + port + " timeout is:" + this.m_timeout_sec + "s");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String remotehost, int port, int timeout_sec) {
        if (remotehost == null || remotehost.length() == 0 || port <= 0) {
            return false;
        }
        if (remotehost.equals(this.m_remote_host) && port == this.m_remote_port && timeout_sec == this.m_timeout_sec && this.m_sock_pool != null) {
            LogUtil.info("the api has been inited, ip is:" + this.m_remote_host + " port is:" + port + " timeout is:" + this.m_timeout_sec + "s");
            return true;
        }
        Svs2ClientHelper svs2ClientHelper = this;
        synchronized (svs2ClientHelper) {
            block7: {
                if (!remotehost.equals(this.m_remote_host) || port != this.m_remote_port || timeout_sec != this.m_timeout_sec || this.m_sock_pool == null) break block7;
                return true;
            }
            this.m_remote_host = remotehost;
            this.m_remote_port = port;
            this.m_timeout_sec = timeout_sec;
            LogUtil.info("init api using pool, ip is:" + remotehost + " port is:" + port + " timeout is:" + timeout_sec + "s");
            if (this.m_sock_pool != null) {
                this.clean();
            }
            this.m_use_pool = true;
            this.m_sock_pool = new SockClientPool();
            this.m_sock_pool.init(remotehost, port, timeout_sec);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String remotehost, int port, int timeout_sec, int concurrent) {
        if (remotehost == null || remotehost.length() == 0 || port <= 0) {
            return false;
        }
        if (remotehost.equals(this.m_remote_host) && port == this.m_remote_port && timeout_sec == this.m_timeout_sec && this.m_sock_pool != null) {
            LogUtil.info("the api has been inited, ip is:" + this.m_remote_host + " port is:" + port + " timeout is:" + this.m_timeout_sec + "s");
            return true;
        }
        Svs2ClientHelper svs2ClientHelper = this;
        synchronized (svs2ClientHelper) {
            block7: {
                if (!remotehost.equals(this.m_remote_host) || port != this.m_remote_port || timeout_sec != this.m_timeout_sec || this.m_sock_pool == null) break block7;
                return true;
            }
            this.m_remote_host = remotehost;
            this.m_remote_port = port;
            this.m_timeout_sec = timeout_sec;
            LogUtil.info("init api using pool, ip is:" + remotehost + " port is:" + port + " timeout is:" + timeout_sec + "s");
            if (this.m_sock_pool != null) {
                this.clean();
            }
            this.m_use_pool = true;
            this.m_sock_pool = new SockClientPool();
            this.m_sock_pool.init(remotehost, port, timeout_sec, concurrent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String remotehost, int port, int timeout_sec, int nconcurrent, int nmax_size) {
        if (remotehost == null || remotehost.length() == 0 || port <= 0) {
            return false;
        }
        if (remotehost.equals(this.m_remote_host) && port == this.m_remote_port && timeout_sec == this.m_timeout_sec && this.m_sock_pool != null) {
            LogUtil.info("the api has been inited, ip is:" + this.m_remote_host + " port is:" + port + " timeout is:" + this.m_timeout_sec + "s");
            return true;
        }
        Svs2ClientHelper svs2ClientHelper = this;
        synchronized (svs2ClientHelper) {
            block7: {
                if (!remotehost.equals(this.m_remote_host) || port != this.m_remote_port || timeout_sec != this.m_timeout_sec || this.m_sock_pool == null) break block7;
                return true;
            }
            this.m_remote_host = remotehost;
            this.m_remote_port = port;
            this.m_timeout_sec = timeout_sec;
            LogUtil.info("init api using pool, ip is:" + remotehost + " port is:" + port + " timeout is:" + timeout_sec + "s");
            if (this.m_sock_pool != null) {
                this.clean();
            }
            this.m_use_pool = true;
            this.m_sock_pool = new SockClientPool();
            this.m_sock_pool.init(remotehost, port, timeout_sec, nconcurrent, nmax_size);
        }
        return true;
    }

    public void setRetry(int nretry, int retry_wait_sec) {
        this.m_is_set_retry = true;
        this.m_retry_times = nretry;
        this.m_retry_wait_sec = retry_wait_sec;
        if (this.m_sock_pool != null) {
            this.m_sock_pool.setRetry(nretry, retry_wait_sec);
        }
    }

    public void setConcurrent(int concurrent) {
        if (this.m_sock_pool != null) {
            this.m_sock_pool.setConcurrent(concurrent);
        }
    }

    private SvsResultData parseResponse(String result) {
        SvsResultData svsResultData = new SvsResultData();
        if (result == null) {
            svsResultData.m_errno = 1101;
            return svsResultData;
        }
        int nErrorNo = this.getErrorFromResult(result);
        if (nErrorNo != 0) {
            svsResultData.m_errno = nErrorNo;
            return svsResultData;
        }
        svsResultData.m_errno = 0;
        svsResultData.m_msgId = this.getIntFromResult(result, "msg_id");
        svsResultData.m_b64SignedCert = this.getValueFromResult(result, "b64_cert");
        svsResultData.m_b64Cert = this.getValueFromResult(result, "b64_cert");
        svsResultData.m_b64SignedData = this.getValueFromResult(result, "signed_data");
        svsResultData.m_b64EvpData = this.getValueFromResult(result, "evp_data");
        svsResultData.m_b64CipherData = this.getValueFromResult(result, "cipher_data");
        String b64Ori = this.getValueFromResult(result, "origin_data");
        if (b64Ori != null && b64Ori.length() > 0) {
            svsResultData.m_originData = Svs2ClientHelper.base64Decode(b64Ori.getBytes());
        }
        svsResultData.m_certCnt = this.getIntFromResult(result, "DN_Count");
        if (svsResultData.m_certCnt > 0) {
            svsResultData.m_certs = new ArrayList();
            String s = null;
            byte[] b = null;
            int i = 1;
            while (i <= svsResultData.m_certCnt) {
                s = this.getValueFromResult(result, new String("dn" + i));
                if (s == null) {
                    LogUtil.warn("parse dn" + (i + 1) + " return null, omit it!");
                } else if (1511 == svsResultData.m_msgId || 1551 == svsResultData.m_msgId) {
                    b = Svs2ClientHelper.base64Decode(s.getBytes());
                    svsResultData.m_certs.add(new String(b, Charset.forName("UTF-8")));
                } else if (1552 == svsResultData.m_msgId || 1553 == svsResultData.m_msgId) {
                    svsResultData.m_certs.add(s);
                }
                ++i;
            }
        }
        return svsResultData;
    }

    private StringBuffer createReqMsgHeader(int msg_id) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<?xml version=\"1.0\" encoding=\"");
        sbuf.append(this.m_msgEncoding);
        sbuf.append("\"?><msg><msg_head><msg_type>0</msg_type><msg_id>");
        sbuf.append(msg_id);
        sbuf.append("</msg_id><msg_sn>0</msg_sn><version>");
        sbuf.append(this.m_msgVersion);
        sbuf.append("</version></msg_head>");
        return sbuf;
    }

    private StringBuffer createRequest(SvsMessage smeg) {
        StringBuffer sbuf = null;
        String s = null;
        sbuf = this.createReqMsgHeader(smeg.msgId);
        sbuf = sbuf.append("<msg_body>");
        String b64Data = null;
        if (smeg.oriData != null) {
            b64Data = new String(Svs2ClientHelper.base64Encode(smeg.oriData));
            sbuf.append("<origin_data_len>" + b64Data.length() + "</origin_data_len>");
            sbuf.append("<origin_data>" + b64Data + "</origin_data>");
        }
        if (smeg.oriDataHash != null) {
            b64Data = new String(Svs2ClientHelper.base64Encode(smeg.oriDataHash));
            sbuf.append("<origin_data_hash>" + b64Data + "</origin_data_hash>");
        }
        if (smeg.signData != null) {
            s = Svs2ClientHelper.trim(smeg.signData);
            sbuf.append("<signed_data>" + s + "</signed_data>");
        }
        if (smeg.certData != null) {
            s = Svs2ClientHelper.trim(smeg.certData);
            sbuf.append("<b64_cert>" + s + "</b64_cert>");
        }
        switch (smeg.digestAlg) {
            case 2: {
                sbuf.append("<alg_digest>sha1</alg_digest>");
                break;
            }
            case 1: {
                sbuf.append("<alg_digest>md5</alg_digest>");
                break;
            }
            case 3: {
                sbuf.append("<alg_digest>sha256</alg_digest>");
                break;
            }
            case 4: {
                sbuf.append("<alg_digest>sha512</alg_digest>");
                break;
            }
        }
        if (smeg.certId != null) {
            b64Data = new String(Svs2ClientHelper.base64Encode(smeg.certId.getBytes(Charset.forName("UTF-8"))));
            if (X509NameUtil.isX509Name((String)smeg.certId)) {
                sbuf.append("<CERT_DN>" + b64Data + "</CERT_DN>");
                sbuf.append("<CERT_DN_len>" + b64Data.length() + "</CERT_DN_len>");
            } else {
                sbuf.append("<cert_id>" + b64Data + "</cert_id>");
            }
        }
        if (smeg.privKeyPasswd != null) {
            sbuf.append("<passwd>" + smeg.privKeyPasswd + "</passwd>");
        }
        if (smeg.signType != null) {
            sbuf.append("<signType>" + smeg.signType.getOption() + "</signType>");
        }
        if (smeg.isGetCert != 0) {
            sbuf.append("<getcert>" + smeg.isGetCert + "</getcert>");
        }
        if (smeg.maxCertCnt != 0) {
            sbuf.append("<MAX_CERT_Count>" + smeg.maxCertCnt + "</MAX_CERT_Count>");
        }
        if (smeg.evpData != null) {
            sbuf.append("<evp_data>" + smeg.evpData + "</evp_data>");
        }
        if (smeg.cipherData != null) {
            sbuf.append("<cipher_data>" + smeg.cipherData + "</cipher_data>");
        }
        if (smeg.certSn != null) {
            sbuf.append("<cert_sn>" + smeg.certSn + "</cert_sn>");
        }
        if (1 == this.m_msgVersion && smeg.msgId == 1001) {
            sbuf.append("<sign_type>-1</sign_type>");
            sbuf.append("<crl_flag>1</crl_flag>");
            sbuf.append("<sign_stytle>0</sign_stytle>");
        }
        if (smeg.userId != null) {
            b64Data = new String(Svs2ClientHelper.base64Encode(smeg.userId));
            sbuf.append("<userid>" + b64Data + "</userid>");
        }
        sbuf.append("</msg_body></msg>");
        return sbuf;
    }

    public SvsResultData signDataBySM2(byte[] originData) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1207;
        smeg.oriData = originData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public int verifySignBySM2(byte[] originData, String b64SignedData, String b64SignCert) {
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            return e.getErrorNo();
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1201;
        smeg.oriData = originData;
        smeg.certData = b64SignCert;
        smeg.signData = b64SignedData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            return e.getErrorNo();
        }
        return this.getErrorFromResult(resp);
    }

    public int verifySignDataBySM2(byte[] originData, String b64SignedData, String b64SignCert) {
        return this.verifySignBySM2(originData, b64SignedData, b64SignCert);
    }

    public int verifySignDataBySM2(byte[] originData, int hash, String b64SignedData, String b64SignCert) {
        return this.verifySignBySM2(originData, b64SignedData, b64SignCert);
    }

    public SvsResultData pkcs7SignBySM2(byte[] originData) {
        SvsMessage smeg = new SvsMessage();
        smeg.oriData = originData;
        smeg.msgId = 1205;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        SvsResultData ret = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parseResponse(resp);
        if (ret.m_errno == 0) {
            SvsResultData p7ret = this.parsePkcs7Sign(ret.m_b64SignedData);
            ret.m_b64SignedCert = p7ret.m_b64Cert;
            ret.m_b64Cert = p7ret.m_b64Cert;
        }
        return ret;
    }

    public SvsResultData pkcs7AttachSignBySM2(byte[] originData) {
        return this.pkcs7SignBySM2(originData);
    }

    public SvsResultData pkcs7SignFileBySM2(String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7SignBySM2(fdata);
    }

    public SvsResultData pkcs7VerifyBySM2(String b64SignedData, byte[] originData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignedData);
        if (ret.m_errno != 0) {
            return ret;
        }
        if (ret.m_originData == null && originData == null) {
            ret.m_errno = 1108;
            return ret;
        }
        if (ret.m_originData != null && originData != null) {
            if (ret.m_originData.length != originData.length) {
                ret.m_errno = 1109;
                return ret;
            }
            int i = 0;
            while (i < originData.length) {
                if (ret.m_originData[i] != originData[i]) {
                    ret.m_errno = 1109;
                    return ret;
                }
                ++i;
            }
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1206;
        smeg.oriData = ret.m_originData == null ? originData : ret.m_originData;
        smeg.signData = b64SignedData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData pkcs7VerifyFileBySM2(String b64SignedData, String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7VerifyBySM2(b64SignedData, fdata);
    }

    public SvsResultData pkcs7DetachSignBySM2(byte[] originData) {
        SvsMessage smeg = new SvsMessage();
        smeg.oriData = originData;
        smeg.msgId = 1208;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        SvsResultData ret = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parseResponse(resp);
        if (ret.m_errno == 0) {
            SvsResultData p7ret = this.parsePkcs7Sign(ret.m_b64SignedData);
            ret.m_b64SignedCert = p7ret.m_b64Cert;
            ret.m_b64Cert = p7ret.m_b64Cert;
        }
        return ret;
    }

    public SvsResultData pkcs7DetachSignFileBySM2(String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachSignBySM2(fdata);
    }

    public SvsResultData pkcs7DetachVerifyExBySM2(String b64SignedData, byte[] originData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignedData);
        if (ret.m_errno != 0) {
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1209;
        smeg.oriData = originData;
        smeg.signData = b64SignedData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData pkcs7DetachVerifyFileExBySM2(String b64SignedData, String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachVerifyExBySM2(b64SignedData, fdata);
    }

    public SvsResultData signData(byte[] originData) {
        return this.signData(originData, -1);
    }

    public SvsResultData signData(byte[] originData, int digestAlg) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1007;
        smeg.oriData = originData;
        smeg.digestAlg = digestAlg;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public void setPrivateKeyPassword(String certId, String password) {
        this.privKeyPasswd.put(certId, password);
    }

    public SvsResultData cdbSignData(byte[] originData, String certId) {
        return this.cdbSignData(originData, -1, certId);
    }

    public SvsResultData cdbSignData(byte[] originData, int digestAlg, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1500;
        smeg.oriData = originData;
        smeg.digestAlg = digestAlg;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbSignDataByDigest(byte[] originDataDigest, String certId) {
        return this.cdbSignDataByDigest(originDataDigest, -1, certId);
    }

    public SvsResultData cdbSignDataByDigest(byte[] originDataDigest, int digestAlg, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1826;
        smeg.oriDataHash = originDataDigest;
        smeg.digestAlg = digestAlg;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbSignDataWithUserId(byte[] originData, String certId, byte[] userId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1828;
        smeg.oriData = originData;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        smeg.userId = userId;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public void setP7Opts(PKCS7Opts flag) {
        this.PKCS7Opts = flag;
    }

    public SvsResultData cdbPkcs7AttachSignWithAttr(byte[] originData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1822;
        smeg.oriData = originData;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        smeg.signType = this.PKCS7Opts;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7AttachVerifyWithAttr(String b64SignedData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignedData);
        if (ret.m_errno != 0) {
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1823;
        smeg.signData = b64SignedData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData cdbPkcs7DetachSignWithAttr(byte[] originData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1824;
        smeg.oriData = originData;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        smeg.signType = this.PKCS7Opts;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7DetachVerifyWithAttr(String b64SignedData, byte[] originData, String certId) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        if (originData == null || originData.length == 0) {
            ret = new SvsResultData();
            ret.m_errno = 1108;
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignedData);
        if (ret.m_errno != 0) {
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1825;
        smeg.signData = b64SignedData;
        smeg.oriData = originData;
        smeg.certId = certId;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData cdbPkcs7SignByDigist(byte[] originData, int digestAlg, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1526;
        smeg.oriData = originData;
        smeg.digestAlg = digestAlg;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7Sign(byte[] originData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1526;
        smeg.oriData = originData;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7DetachSignEx(byte[] originData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1504;
        smeg.oriData = originData;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public Boolean isSm2Cert(String b64SignCert) throws Svs2ClientException {
        X509Cert cert = null;
        try {
            cert = new X509Cert(b64SignCert);
        }
        catch (IOException e) {
            throw new Svs2ClientException(1107, (Throwable)e);
        }
        try {
            if (cert.getCertType().equalsIgnoreCase("SM2")) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1114, (Throwable)e);
        }
        return false;
    }

    public SvsResultData cdbPkcs7DetachSignByDigest(byte[] digest, String certId, int digestAlg) throws Svs2ClientException {
        SvsResultData ret = new SvsResultData();
        if (digest == null || certId == null) {
            ret.m_errno = 1101;
            return ret;
        }
        if (-1 == digestAlg) {
            digestAlg = 2;
        }
        ret = this.cdbGetSignCert(certId);
        if (ret.m_errno < 0) {
            return ret;
        }
        if (this.isSm2Cert(ret.m_b64SignedCert).booleanValue() && 6 != digestAlg) {
            ret.m_errno = 1113;
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1570;
        smeg.oriData = digest;
        smeg.digestAlg = digestAlg;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7Verify(String b64SignData, byte[] originData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignData = Svs2ClientHelper.b64SignedDataFormat(b64SignData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignData);
        if (ret.m_errno != 0) {
            return ret;
        }
        if (ret.m_originData == null && originData == null) {
            ret.m_errno = 1108;
            return ret;
        }
        if (ret.m_originData != null && originData != null && this.cmpData(ret.m_originData, originData) != 0) {
            ret.m_errno = 1109;
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1527;
        smeg.oriData = ret.m_originData == null ? originData : ret.m_originData;
        smeg.signData = b64SignData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData cdbPkcs7DetachVerifyEx(String b64SignData, byte[] originData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignData = Svs2ClientHelper.b64SignedDataFormat(b64SignData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        if (originData == null || originData.length == 0) {
            ret = new SvsResultData();
            ret.m_errno = 1108;
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignData);
        if (ret.m_errno != 0) {
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1506;
        smeg.oriData = originData;
        smeg.signData = b64SignData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData cdbPkcs7DetachVerifyByDigest(String b64SignData, byte[] digest, int algDigest) throws Svs2ClientException {
        SvsResultData ret = new SvsResultData();
        try {
            b64SignData = Svs2ClientHelper.b64SignedDataFormat(b64SignData);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        if (digest == null || digest.length == 0) {
            ret = new SvsResultData();
            ret.m_errno = 1108;
            return ret;
        }
        ret = this.parsePkcs7Sign(b64SignData);
        if (ret.m_errno != 0) {
            return ret;
        }
        if (this.isSm2Cert(ret.m_b64Cert).booleanValue() && 6 != algDigest) {
            ret.m_errno = 1113;
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1571;
        smeg.oriData = digest;
        smeg.signData = b64SignData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData cdbVerifySign(byte[] originData, String b64SignedData, String certId) {
        return this.cdbVerifySign(originData, -1, b64SignedData, certId);
    }

    public SvsResultData cdbVerifySign(byte[] originData, int digestAlg, String b64SignedData, String certId) {
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1501;
        smeg.oriData = originData;
        smeg.digestAlg = digestAlg;
        smeg.signData = b64SignedData;
        smeg.certId = certId;
        smeg.isGetCert = 1;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbVerifySignByDigest(byte[] originDataDigest, String b64SignedData, String certId) {
        return this.cdbVerifySignByDigest(originDataDigest, -1, b64SignedData, certId);
    }

    public SvsResultData cdbVerifySignByDigest(byte[] originDataDigest, int digestAlg, String b64SignedData, String certId) {
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1827;
        smeg.oriDataHash = originDataDigest;
        smeg.digestAlg = digestAlg;
        smeg.signData = b64SignedData;
        smeg.certId = certId;
        smeg.isGetCert = 1;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbVerifySignWithUserId(byte[] originData, String b64SignedData, String certId, byte[] userId) {
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1829;
        smeg.oriData = originData;
        smeg.signData = b64SignedData;
        smeg.certId = certId;
        smeg.isGetCert = 1;
        smeg.userId = userId;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7EvpEncrypt(byte[] originData, String certId) {
        if (originData.length >= 102400) {
            return this.cdbPkcs7EvpEncryptEx(originData, certId);
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1521;
        smeg.oriData = originData;
        smeg.certId = certId;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7EvpDecrypt(String b64EvpData) {
        if (b64EvpData.length() >= 102400) {
            return this.cdbPkcs7EvpDecryptEx(b64EvpData);
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1522;
        smeg.evpData = b64EvpData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbPkcs7EvpEncryptEx(byte[] originData, String certId) {
        byte[] key = DESUtil.generateKey(null);
        SvsResultData ret = this.cdbPublicKeyEncrypt(key, certId);
        if (ret.m_errno != 0) {
            return ret;
        }
        X509Certificate[] cert = X509CertParser.parseCert(ret.m_b64Cert.getBytes());
        if (cert == null || cert[0] == null) {
            ret.m_errno = 1107;
            return ret;
        }
        byte[] encryptkey = Svs2ClientHelper.base64Decode(ret.m_b64CipherData.getBytes());
        byte[] evpdata = null;
        try {
            evpdata = PKCS7EnvelopUtil.createEnvelop(cert[0], originData, encryptkey, key);
        }
        catch (PKCS7Exception e) {
            ret.m_errno = 1110;
            return ret;
        }
        ret.m_b64EvpData = new String(Svs2ClientHelper.base64Encode(evpdata));
        return ret;
    }

    public SvsResultData cdbPkcs7EvpDecryptEx(String b64EvpData) {
        PKCS7EnvelopUtil util = new PKCS7EnvelopUtil();
        PKCS7EnvelopUtil.EnvelopResult env = null;
        SvsResultData ret = null;
        try {
            env = util.parseEnvelopKey(Svs2ClientHelper.base64Decode(b64EvpData.getBytes()));
        }
        catch (Exception e) {
            ret = new SvsResultData();
            ret.m_errno = 1111;
            return ret;
        }
        ret = this.cdbPrivateKeyDecryptBySn(env.envelop_key, env.cert_sn);
        if (ret.m_errno != 0) {
            return ret;
        }
        byte[] deskey = ret.m_originData;
        try {
            ret.m_originData = PKCS7EnvelopUtil.parseEnvelopData(deskey, env.envelop_content, env.envelop_ivparam);
        }
        catch (PKCS7Exception e) {
            ret.m_errno = 1111;
            return ret;
        }
        return ret;
    }

    protected SvsResultData cdbPublicKeyEncrypt(byte[] originData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1531;
        smeg.oriData = originData;
        smeg.certId = certId;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    protected SvsResultData cdbPrivateKeyDecrypt(byte[] cipherData, String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1533;
        smeg.cipherData = new String(Svs2ClientHelper.base64Encode(cipherData));
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    protected SvsResultData cdbPrivateKeyDecryptBySn(byte[] cipherData, String certSn) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1533;
        smeg.cipherData = new String(Svs2ClientHelper.base64Encode(cipherData));
        smeg.certSn = certSn;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbGetSignCert(String certId) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1554;
        smeg.certId = certId;
        smeg.privKeyPasswd = this.privKeyPasswd.get(certId);
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    protected SvsResultData cdbGetList(int msdId, int maxCount) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = msdId;
        smeg.maxCertCnt = maxCount > 0 ? maxCount : 256;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            SvsResultData ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        return this.parseResponse(resp);
    }

    public SvsResultData cdbGetCertList(int maxCount) {
        return this.cdbGetList(1511, maxCount);
    }

    public SvsResultData cdbGetCertList() {
        return this.cdbGetList(1511, 0);
    }

    public SvsResultData cdbGetCertAliasList(int maxCount) {
        return this.cdbGetList(1552, maxCount);
    }

    public SvsResultData cdbGetCertAliasList() {
        return this.cdbGetList(1552, 0);
    }

    public SvsResultData cdbGetSignCertList(int maxCount) {
        return this.cdbGetList(1551, maxCount);
    }

    public SvsResultData cdbGetSignCertList() {
        return this.cdbGetList(1551, 0);
    }

    public SvsResultData cdbGetSignCertAliasList(int maxCount) {
        return this.cdbGetList(1553, maxCount);
    }

    public SvsResultData cdbGetSignCertAliasList() {
        return this.cdbGetList(1553, 0);
    }

    public int verifySign(byte[] originData, int digestAlg, String b64SignedData, String b64SignCert) {
        try {
            b64SignedData = Svs2ClientHelper.b64SignedDataFormat(b64SignedData);
        }
        catch (Svs2ClientException e) {
            return e.getErrorNo();
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1001;
        smeg.oriData = originData;
        smeg.digestAlg = digestAlg;
        smeg.certData = b64SignCert;
        smeg.signData = b64SignedData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            return e.getErrorNo();
        }
        return this.getErrorFromResult(resp);
    }

    public int verifySign(byte[] originData, String b64SignedData, String b64SignCert) {
        return this.verifySign(originData, -1, b64SignedData, b64SignCert);
    }

    public int verifyCert(String b64SignCert) {
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1000;
        smeg.certData = b64SignCert;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            return e.getErrorNo();
        }
        return this.getErrorFromResult(resp);
    }

    public SvsResultData pkcs7Sign(byte[] originData) {
        SvsResultData ret = null;
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1005;
        smeg.oriData = originData;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parseResponse(resp);
        if (ret.m_errno == 0) {
            SvsResultData p7ret = this.parsePkcs7Sign(ret.m_b64SignedData);
            ret.m_b64SignedCert = p7ret.m_b64Cert;
            ret.m_b64Cert = p7ret.m_b64Cert;
        }
        return ret;
    }

    public SvsResultData pkcs7SignFile(String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7Sign(fdata);
    }

    public SvsResultData pkcs7AttachSign(byte[] oriData) {
        return this.pkcs7Sign(oriData);
    }

    public SvsResultData pkcs7AttachSignFile(String filename) {
        return this.pkcs7SignFile(filename);
    }

    public SvsResultData pkcs7SignFileHash(String filename) {
        return this.pkcs7SignFileHash(filename, 2);
    }

    public SvsResultData pkcs7SignFileHash(String filename, int fileDigestAlg) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        byte[] data = null;
        try {
            data = Svs2ClientHelper.digest(fdata, fileDigestAlg);
        }
        catch (Svs2ClientException e) {
            result = new SvsResultData();
            result.m_errno = e.getErrorNo();
            return result;
        }
        return this.pkcs7Sign(data);
    }

    public SvsResultData pkcs7Verify(String b64Pkcs7Data, byte[] originData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64Pkcs7Data = Svs2ClientHelper.b64SignedDataFormat(b64Pkcs7Data);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parsePkcs7Sign(b64Pkcs7Data);
        if (ret.m_errno != 0) {
            return ret;
        }
        if (ret.m_originData == null && originData == null) {
            ret.m_errno = 1108;
            return ret;
        }
        if (ret.m_originData != null && originData != null && this.cmpData(ret.m_originData, originData) != 0) {
            ret.m_errno = 1109;
            return ret;
        }
        byte[] oriData = ret.m_originData == null ? originData : ret.m_originData;
        SvsMessage msg = new SvsMessage();
        msg.msgId = 1006;
        msg.oriData = oriData;
        msg.signData = b64Pkcs7Data;
        StringBuffer req = this.createRequest(msg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData pkcs7VerifyFile(String b64Pkcs7Data, String filename) {
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            SvsResultData result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7Verify(b64Pkcs7Data, fdata);
    }

    public SvsResultData pkcs7VerifyFileHash(String b64Pkcs7Data, String filename) {
        return this.pkcs7VerifyFileHash(b64Pkcs7Data, filename, 2);
    }

    public SvsResultData pkcs7VerifyFileHash(String b64Pkcs7Data, String filename, int fileDigestAlg) {
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            SvsResultData result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        byte[] data = null;
        try {
            data = Svs2ClientHelper.digest(fdata, fileDigestAlg);
        }
        catch (Svs2ClientException e) {
            SvsResultData result = new SvsResultData();
            result.m_errno = e.getErrorNo();
            return result;
        }
        return this.pkcs7Verify(b64Pkcs7Data, data);
    }

    public SvsResultData pkcs7DetachSign(byte[] originData) {
        return this.pkcs7DetachSign(originData, -1);
    }

    public SvsResultData pkcs7DetachSign(byte[] originData, int digestAlg) {
        SvsResultData ret = null;
        byte[] pDigest = null;
        try {
            pDigest = Svs2ClientHelper.digest(originData, digestAlg);
        }
        catch (Svs2ClientException e) {
            ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1040;
        smeg.digestAlg = digestAlg;
        smeg.oriData = pDigest;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException e) {
            ret = new SvsResultData();
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        ret = this.parseResponse(resp);
        if (ret.m_errno == 0) {
            SvsResultData p7ret = this.parsePkcs7Sign(ret.m_b64SignedData);
            ret.m_b64SignedCert = p7ret.m_b64Cert;
            ret.m_b64Cert = p7ret.m_b64Cert;
        }
        return ret;
    }

    public SvsResultData pkcs7DetachVerify(String b64Pkcs7Data, byte[] originData) {
        return this.pkcs7DetachVerify(b64Pkcs7Data, originData, -1);
    }

    public SvsResultData pkcs7DetachVerify(String b64Pkcs7Data, byte[] originData, int digestAlg) {
        SvsResultData ret = new SvsResultData();
        try {
            b64Pkcs7Data = Svs2ClientHelper.b64SignedDataFormat(b64Pkcs7Data);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        if (originData == null || originData.length == 0) {
            ret = new SvsResultData();
            ret.m_errno = 1108;
            return ret;
        }
        ret = this.parsePkcs7Sign(b64Pkcs7Data);
        if (ret.m_errno != 0) {
            return ret;
        }
        byte[] pDigest = null;
        try {
            pDigest = Svs2ClientHelper.digest(originData, digestAlg);
        }
        catch (Svs2ClientException exp) {
            ret.m_errno = exp.getErrorNo();
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1041;
        smeg.oriData = pDigest;
        smeg.signData = b64Pkcs7Data;
        smeg.digestAlg = digestAlg;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException exp) {
            ret.m_errno = exp.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData pkcs7DetachVerifyFile(String b64Pkcs7Data, String filename) {
        return this.pkcs7DetachVerifyFile(b64Pkcs7Data, filename, -1);
    }

    public SvsResultData pkcs7DetachVerifyFile(String b64Pkcs7Data, String filename, int digestAlg) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachVerify(b64Pkcs7Data, fdata, digestAlg);
    }

    public SvsResultData pkcs7DetachSignFile(String filename) {
        return this.pkcs7DetachSignFile(filename, -1);
    }

    public SvsResultData pkcs7DetachSignFile(String filename, int digestAlg) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachSign(fdata, digestAlg);
    }

    public SvsResultData pkcs7DetachVerifyEx(String b64Pkcs7Data, byte[] oriData) {
        SvsResultData ret = new SvsResultData();
        try {
            b64Pkcs7Data = Svs2ClientHelper.b64SignedDataFormat(b64Pkcs7Data);
        }
        catch (Svs2ClientException e) {
            ret.m_errno = e.getErrorNo();
            return ret;
        }
        if (oriData == null || oriData.length == 0) {
            ret = new SvsResultData();
            ret.m_errno = 1108;
            return ret;
        }
        ret = this.parsePkcs7Sign(b64Pkcs7Data);
        if (ret.m_errno != 0) {
            return ret;
        }
        SvsMessage smeg = new SvsMessage();
        smeg.msgId = 1042;
        smeg.oriData = oriData;
        smeg.signData = b64Pkcs7Data;
        StringBuffer req = this.createRequest(smeg);
        String resp = null;
        try {
            resp = this.sendAndRecv(req.toString());
        }
        catch (Svs2ClientException exp) {
            ret.m_errno = exp.getErrorNo();
            return ret;
        }
        ret.m_errno = this.getErrorFromResult(resp);
        return ret;
    }

    public SvsResultData pkcs7DetachVerifyFileEx(String b64Pkcs7Data, String filename) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (fdata == null) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachVerifyEx(b64Pkcs7Data, fdata);
    }

    public static byte[] digest(byte[] originData) throws Svs2ClientException {
        return Svs2ClientHelper.digest(originData, 2);
    }

    public static byte[] digest(byte[] originData, int digestAlg) throws Svs2ClientException {
        if (originData == null) {
            throw new Svs2ClientException(1101);
        }
        MessageDigest messageDigest = null;
        String algName = null;
        try {
            algName = Svs2ClientHelper.digestAlgID2Name(digestAlg);
            messageDigest = MessageDigest.getInstance(algName);
        }
        catch (NoSuchAlgorithmException exp) {
            throw new Svs2ClientException(1105, "no such digest algorithm" + algName, exp);
        }
        messageDigest.update(originData, 0, originData.length);
        return messageDigest.digest();
    }

    public static String digestAlgID2Name(int algId) {
        if (2 == algId) {
            return DIGEST_NAME_SHA1;
        }
        if (3 == algId) {
            return DIGEST_NAME_SHA256;
        }
        if (4 == algId) {
            return DIGEST_NAME_SHA512;
        }
        if (1 == algId) {
            return DIGEST_NAME_MD5;
        }
        if (5 == algId) {
            return DIGEST_NAME_SM3;
        }
        if (6 == algId) {
            return DIGEST_NAME_SM3WITHSM2;
        }
        return DIGEST_NAME_SHA1;
    }

    public static int digestName2AlgID(String name) {
        if (DIGEST_NAME_MD5.equalsIgnoreCase(name) || DIGEST_ALIAS_MD5.equalsIgnoreCase(name)) {
            return 1;
        }
        if (DIGEST_NAME_SHA1.equalsIgnoreCase(name) || DIGEST_ALIAS_SHA1.equalsIgnoreCase(name)) {
            return 2;
        }
        if (DIGEST_NAME_SHA256.equalsIgnoreCase(name) || DIGEST_ALIAS_SHA256.equalsIgnoreCase(name)) {
            return 3;
        }
        if (DIGEST_NAME_SHA512.equalsIgnoreCase(name) || DIGEST_ALIAS_SHA512.equalsIgnoreCase(name)) {
            return 4;
        }
        if (DIGEST_NAME_SM3.equalsIgnoreCase(name)) {
            return 5;
        }
        if (DIGEST_NAME_SM3WITHSM2.equalsIgnoreCase(name)) {
            return 6;
        }
        return -1;
    }

    public static MessageDigest createDigest(int algorithm) throws Svs2ClientException {
        String alg = Svs2ClientHelper.digestAlgID2Name(algorithm);
        return Svs2ClientHelper.createDigest(alg);
    }

    public static MessageDigest createDigest(String algorithm) throws Svs2ClientException {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1105, "not such digest algorithm " + algorithm, e);
        }
        return digest;
    }

    public static MessageDigest createDigest(int algorithm, String b64SignCert) throws Svs2ClientException {
        String alg = Svs2ClientHelper.digestAlgID2Name(algorithm);
        return Svs2ClientHelper.createDigest(alg, b64SignCert);
    }

    public static MessageDigest createDigest(String algorithm, String b64SignCert) throws Svs2ClientException {
        if (algorithm.equalsIgnoreCase("sm3WithSm2")) {
            if (b64SignCert == null) {
                return null;
            }
            return Svs2ClientHelper.createSM3SignDigest(b64SignCert);
        }
        return Svs2ClientHelper.createDigest(algorithm);
    }

    public static MessageDigest createSM3SignDigest(String b64SignCert) throws Svs2ClientException {
        Sm3WithSm2 digest = null;
        X509Cert cert = null;
        try {
            cert = new X509Cert(b64SignCert);
        }
        catch (IOException e) {
            throw new Svs2ClientException(1107, "parse certificate data error\r\n" + b64SignCert, e);
        }
        try {
            if (!cert.getCertType().equalsIgnoreCase("SM2")) {
                throw new Svs2ClientException(1113, "not sm2 cert type\r\n" + b64SignCert, null);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1114, "unkown cert type", e);
        }
        SubjectPublicKeyInfo pubKeyInfo = cert.getSubjectPubKeyInfo();
        ECPublicKeyParameters ecPubKeyParam = null;
        try {
            ecPubKeyParam = (ECPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)pubKeyInfo);
        }
        catch (IOException e) {
            throw new Svs2ClientException(1115, "parse public key info" + b64SignCert, e);
        }
        try {
            String userId = System.getProperty("KOALII.SM2.USERID");
            digest = userId != null ? new Sm3WithSm2(userId, ecPubKeyParam) : new Sm3WithSm2(ecPubKeyParam);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1105, "no such sm2 curve or sm3 messageDigest not available", e);
        }
        return digest;
    }

    public static void updateDigestData(MessageDigest digest, byte[] data, int offset, int len) {
        digest.update(data, offset, len);
    }

    public static byte[] digest(MessageDigest digest) {
        return digest.digest();
    }

    public static byte[] readFile(String filename) {
        FileInputStream fin = null;
        byte[] fdata = null;
        try {
            fin = new FileInputStream(filename);
            fdata = new byte[fin.available()];
            fin.read(fdata);
        }
        catch (Exception e) {
            fdata = null;
        }
        try {
            fin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fdata;
    }

    public static byte[] base64Encode(byte[] originData) {
        return Base64.encode(originData);
    }

    public static byte[] base64Decode(byte[] base64Data) {
        String temp = new String(base64Data);
        temp = temp.replaceAll("\\s*", DIGEST_NAME_NONE);
        base64Data = temp.getBytes();
        return Base64.decode(base64Data);
    }

    public static String b64SignedDataFormat(String b64SignedData) throws Svs2ClientException {
        char[] b64SignedDataChars = b64SignedData.toCharArray();
        int b64count = 0;
        int i = 0;
        while (i < b64SignedDataChars.length) {
            if (b64SignedDataChars[i] >= '0' & b64SignedDataChars[i] <= '9' || b64SignedDataChars[i] >= 'A' & b64SignedDataChars[i] <= 'Z' || b64SignedDataChars[i] >= 'a' & b64SignedDataChars[i] <= 'z' || b64SignedDataChars[i] == '+' || b64SignedDataChars[i] == '/' || b64SignedDataChars[i] == '=') {
                ++b64count;
            } else if (b64SignedDataChars[i] != '\t' && b64SignedDataChars[i] != '\n' && b64SignedDataChars[i] != '\r' && b64SignedDataChars[i] != ' ') {
                throw new Svs2ClientException(1112);
            }
            ++i;
        }
        if (b64count % 4 != 0) {
            i = 0;
            while (i < 4 - b64count % 4) {
                b64SignedData = String.valueOf(b64SignedData) + "=";
                ++i;
            }
        }
        return b64SignedData;
    }

    public static String trim(String s) {
        return s.replaceAll("\\s*", DIGEST_NAME_NONE);
    }

    public SvsResultData parsePkcs7Sign(String b64P7Data) {
        SvsResultData result = new SvsResultData();
        int keyLen = -1;
        if (b64P7Data == null) {
            result.m_errno = 1101;
            return result;
        }
        byte[] derData = Svs2ClientHelper.base64Decode(b64P7Data.getBytes());
        ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(derData));
        try {
            Enumeration ec;
            ASN1Set certs;
            ASN1OctetString oct;
            ContentInfo cinfo = ContentInfo.getInstance(bIn.readObject());
            SignedData sdata = SignedData.getInstance(cinfo.getContent());
            ContentInfo content = sdata.getContentInfo();
            if (content.getContent() != null && (oct = ASN1OctetString.getInstance(content.getContent())).getOctets().length > 0) {
                result.m_originData = oct.getOctets();
            }
            if ((certs = sdata.getCertificates()) != null && (ec = certs.getObjects()).hasMoreElements()) {
                byte[] dercert = X509CertificateStructure.getInstance(ec.nextElement()).getEncoded();
                result.m_b64SignedCert = new String(Svs2ClientHelper.base64Encode(dercert));
                result.m_b64Cert = new String(Svs2ClientHelper.base64Encode(dercert));
            }
            SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
            String digestAlg = signer.getDigestAlgorithm().getObjectId().getId();
            result.m_digestAlg = oidMap.get(digestAlg);
            if (digestAlg != null && result.m_digestAlg == null) {
                result.m_digestAlg = digestAlg;
            }
            String encDigestAlg = signer.getDigestEncryptionAlgorithm().getObjectId().getId();
            String signAlg = oidMap.get(encDigestAlg);
            if (result.m_b64Cert != null && "RSA".equals(signAlg)) {
                Certificate cert = null;
                Security.addProvider((Provider)new BouncyCastleProvider());
                X509Certificate[] x509Certs = X509CertParser.parseB64Cert(result.m_b64Cert);
                IssuerAndSerialNumber is = signer.getIssuerAndSerialNumber();
                BigInteger sn = is.getCertificateSerialNumber().getValue();
                X509Certificate[] x509CertificateArray = x509Certs;
                int n = x509Certs.length;
                int n2 = 0;
                while (n2 < n) {
                    X509Certificate c = x509CertificateArray[n2];
                    if (sn == c.getSerialNumber()) {
                        cert = c;
                        break;
                    }
                    ++n2;
                }
                if (cert != null) {
                    PublicKey key = cert.getPublicKey();
                    String algorithm = key.getAlgorithm();
                    KeyFactory keyFact = KeyFactory.getInstance(algorithm);
                    BigInteger prime = null;
                    if ("RSA".equals(algorithm)) {
                        RSAPublicKeySpec keySpec = keyFact.getKeySpec(key, RSAPublicKeySpec.class);
                        prime = keySpec.getModulus();
                        keyLen = prime.toString(2).length();
                    }
                }
            }
            result.m_signAlg = "RSA".equals(signAlg) && keyLen != -1 ? String.valueOf(signAlg) + String.valueOf(keyLen) : signAlg;
            if (encDigestAlg != null && result.m_signAlg == null) {
                result.m_signAlg = encDigestAlg;
            }
            byte[] signedData = signer.getEncryptedDigest().getOctets();
            result.m_b64SignedData = new String(Svs2ClientHelper.base64Encode(signedData));
        }
        catch (Exception exp) {
            result.m_errno = 1106;
            try {
                bIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        try {
            bIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.m_errno = 0;
        return result;
    }

    public String parseX509Cert(String b64cert, String tag) throws Svs2ClientException {
        byte[] derData = Svs2ClientHelper.base64Decode(b64cert.getBytes());
        ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(derData));
        X509CertificateStructure x509cert = null;
        try {
            x509cert = X509CertificateStructure.getInstance(bIn.readObject());
            bIn.close();
        }
        catch (Exception exp) {
            throw new Svs2ClientException(1107);
        }
        if (tag.equalsIgnoreCase("DN")) {
            return x509cert.getSubject().toString();
        }
        if (tag.equalsIgnoreCase("CN")) {
            X509Name dn = x509cert.getSubject();
            int index = dn.getOIDs().indexOf(X509Name.CN);
            return dn.getValues().get(index).toString();
        }
        if (tag.equalsIgnoreCase("SN")) {
            return x509cert.getSerialNumber().getValue().toString();
        }
        if (tag.equalsIgnoreCase("SN_HEX")) {
            return Svs2ClientHelper.bytesToHex(x509cert.getSerialNumber().getValue().toByteArray());
        }
        if (tag.equalsIgnoreCase("ISSUER")) {
            return x509cert.getIssuer().toString();
        }
        if (tag.equalsIgnoreCase("START")) {
            return x509cert.getStartDate().getDate().toGMTString();
        }
        if (tag.equalsIgnoreCase("END")) {
            return x509cert.getEndDate().getDate().toGMTString();
        }
        if (tag.equalsIgnoreCase("VERSION")) {
            return String.valueOf(x509cert.getVersion());
        }
        throw new Svs2ClientException(1107);
    }

    public static String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public byte[] parseX509CertExt(String b64cert, String oid) throws Svs2ClientException {
        byte[] derData = Svs2ClientHelper.base64Decode(b64cert.getBytes());
        ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(derData));
        X509CertificateStructure x509cert = null;
        try {
            x509cert = X509CertificateStructure.getInstance(bIn.readObject());
        }
        catch (Exception exp) {
            throw new Svs2ClientException(1107);
        }
        X509Extensions exts = x509cert.getTBSCertificate().getExtensions();
        X509Extension ext = exts.getExtension(new DERObjectIdentifier(oid));
        return ext.getValue().getOctets();
    }

    public String sendAndRecv(String data) throws Svs2ClientException {
        String result = this.m_use_pool ? this.sendAndRecv_P(data) : this.sendAndRecv_S(data);
        return result;
    }

    private String sendAndRecv_P(String data) throws Svs2ClientException {
        if (this.m_sock_pool == null) {
            LogUtil.error("pool is null and return:1102");
            throw new Svs2ClientException(1102);
        }
        byte[] retdata = null;
        TcpSockClient sclient = new TcpSockClient();
        int ntry = 3;
        String endTag = new String("</msg>");
        String address = DIGEST_NAME_NONE;
        while (ntry > 0) {
            try {
                sclient = this.m_sock_pool.pop();
                if (sclient == null) {
                    LogUtil.warn("pool is full, retry left " + --ntry);
                    try {
                        if (ntry <= 0) continue;
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                address = sclient.toString();
                LogUtil.info(String.valueOf(address) + ": sending[" + data.length() + "]");
                retdata = sclient.sendAndRecv(data, endTag);
                address = sclient.toString();
                LogUtil.info(String.valueOf(address) + ": sended[" + data.length() + "]: " + data);
                this.m_sock_pool.push(sclient);
                break;
            }
            catch (TcpSockClientException e) {
                LogUtil.error(String.valueOf(address) + ": send or recv failed " + e.getErrorNo());
                this.m_sock_pool.push(sclient);
                throw new Svs2ClientException(e.getErrorNo());
            }
        }
        if (ntry == 0) {
            LogUtil.error("pool is full and return 1104");
            throw new Svs2ClientException(1104);
        }
        String result = new String(retdata);
        LogUtil.info(String.valueOf(address) + ": recved[" + result.length() + "]: " + result);
        return result;
    }

    private String sendAndRecv_S(String data) throws Svs2ClientException {
        TcpSockClient sock = new TcpSockClient(this.m_remote_host, this.m_remote_port, this.m_timeout_sec);
        if (this.m_is_set_retry) {
            sock.setRetry(this.m_retry_times, this.m_retry_wait_sec);
        }
        byte[] res = null;
        String endTag = new String("</msg>");
        String address = DIGEST_NAME_NONE;
        try {
            address = sock.toString();
            LogUtil.info(String.valueOf(address) + " sending [" + data.length() + "]: " + new String(data));
            res = sock.sendAndRecv(data, endTag);
            address = sock.toString();
            LogUtil.info(String.valueOf(address) + " recved [" + res.length + "]: " + new String(res));
            sock.close();
        }
        catch (TcpSockClientException e) {
            LogUtil.error(String.valueOf(address) + " failed " + e.getErrorNo());
            sock.close();
            throw new Svs2ClientException(e.getErrorNo());
        }
        String result = new String(res);
        LogUtil.info(String.valueOf(address) + ": recved[" + result.length() + "]: " + result);
        return result;
    }

    protected ArrayList<String> getListFromResult(String result, String field) {
        if (result == null || field == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        String beginTag = "<" + field + ">";
        String endTag = "</" + field + ">";
        int nBeginIndex = 0;
        int nEndIndex = 0;
        while ((nBeginIndex = result.indexOf(beginTag, nBeginIndex)) != -1) {
            nEndIndex = result.indexOf(endTag, nBeginIndex += beginTag.length());
            ret.add(result.substring(nBeginIndex, nEndIndex));
        }
        return ret;
    }

    protected String getValueFromResult(String result, String field) {
        if (result == null || field == null) {
            return null;
        }
        String fieldValue = null;
        String beginTag = "<" + field + ">";
        String endTag = "</" + field + ">";
        try {
            int nBeginIndex = result.indexOf(beginTag);
            if (nBeginIndex == -1) {
                fieldValue = null;
            } else {
                int nEndIndex = result.indexOf(endTag, nBeginIndex += beginTag.length());
                fieldValue = result.substring(nBeginIndex, nEndIndex);
            }
        }
        catch (Exception e) {
            fieldValue = null;
        }
        return fieldValue;
    }

    protected int getIntFromResult(String result, String field) {
        if (result == null || field == null) {
            return 0;
        }
        String fieldValue = null;
        String beginTag = "<" + field + ">";
        String endTag = "</" + field + ">";
        try {
            int nBeginIndex = result.indexOf(beginTag);
            if (nBeginIndex == -1) {
                fieldValue = null;
            } else {
                int nEndIndex = result.indexOf(endTag, nBeginIndex += beginTag.length());
                fieldValue = result.substring(nBeginIndex, nEndIndex);
            }
        }
        catch (Exception e) {
            return 0;
        }
        return fieldValue == null ? 0 : Integer.parseInt(fieldValue);
    }

    protected int getErrorFromResult(String result) {
        if (result == null) {
            return -1;
        }
        int nRet = -2;
        try {
            int nBeginIndex = result.indexOf("<error_no>");
            if (nBeginIndex == -1) {
                nRet = 0;
            } else {
                int nEndIndex = result.indexOf("</error_no>", nBeginIndex += "<error_no>".length());
                nRet = Integer.parseInt(result.substring(nBeginIndex, nEndIndex));
            }
        }
        catch (Exception e) {
            nRet = -2;
        }
        return nRet;
    }

    protected int cmpData(byte[] d1, byte[] d2) {
        if (d1 != null && d2 != null) {
            if (d1.length != d2.length) {
                return -1;
            }
            int i = 0;
            while (i < d1.length) {
                if (d1[i] != d2[i]) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
        return -1;
    }

    private class SvsMessage {
        private int msgId;
        private int digestAlg = -1;
        private PKCS7Opts signType = null;
        private byte[] oriData = null;
        private byte[] oriDataHash = null;
        private String signData = null;
        private String certData = null;
        private String certId = null;
        private String privKeyPasswd = null;
        private int maxCertCnt = 0;
        private int isGetCert = 0;
        private String evpData = null;
        private String cipherData = null;
        private String certSn = null;
        private byte[] userId = null;

        private SvsMessage() {
        }
    }

    public class SvsResultData {
        public int m_msgId = 0;
        public int m_errno = -1;
        public byte[] m_originData = null;
        public String m_b64SignedData = null;
        public String m_b64EvpData = null;
        public String m_b64EncData = null;
        public String m_b64CipherData = null;
        public String m_b64SignedCert = null;
        public String m_b64Cert = null;
        public int m_certCnt = 0;
        public String m_certId = null;
        public ArrayList<String> m_certs = null;
        public String m_digestAlg = null;
        public String m_signAlg = null;
    }
}

