/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.io.RASInputStream;
import com.itextpdf.text.io.RandomAccessSource;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.itextpdf.text.pdf.security.ProviderDigest;
import com.koalii.asn1.ASN1InputStream;
import com.koalii.asn1.DERObject;
import com.koalii.asn1.DEROutputStream;
import com.koalii.asn1.cms.SignerInfo;
import com.koalii.svs.client.Svs2ClientException;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.client.Svs2ClientPDFException;
import com.koalii.util.log.LogUtil;
import com.koalii.util.pdf.SvsSignature;
import com.koalii.util.pkcs7.PKCS7Exception;
import com.koalii.util.pkcs7.PKCS7SignUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Svs2ClientPDFHelper {
    private static final boolean SLOW_VER = false;
    Svs2ClientHelper m_clientHelper = null;
    private PdfReader m_reader = null;
    private PdfStamper m_stamper = null;
    private PdfSignatureAppearance m_appearance = null;
    String m_certId = null;
    FileInputStream m_fin = null;
    FileOutputStream m_fout = null;
    FileInputStream m_pfx = null;
    private KeyStore m_keyStore = null;
    private PrivateKey m_privKey = null;
    private Certificate[] m_certChain = null;
    private String m_hashAlg = "SHA-1";
    private String m_providerName = "BC";
    private int reserveSignSize = 8192;
    private String fieldNameString = "sig";

    static {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
    }

    public int setReason(String reason) {
        if (this.m_appearance == null) {
            return -2127;
        }
        this.m_appearance.setReason(reason);
        return 0;
    }

    public int setLocation(String location) {
        if (this.m_appearance == null) {
            return -2127;
        }
        this.m_appearance.setLocation(location);
        return 0;
    }

    public void setReservedSignSize(int reserveSignSize) {
        this.reserveSignSize = reserveSignSize;
    }

    public int setVisibleAppearence(Image sealImage, int pageIndex) {
        return this.setVisibleAppearence(sealImage, pageIndex, null, 1.0f);
    }

    public int setVisibleAppearence(String sealImagePath, int pageIndex) {
        return this.setVisibleAppearence(sealImagePath, pageIndex, null, 1.0f);
    }

    public int setVisibleAppearence(String sealImagePath, int pageIndex, Rectangle rectangle, float sealImageOpacity) {
        Image sealImage = null;
        int errCode = 0;
        try {
            if (sealImagePath != null) {
                sealImage = Image.getInstance((String)sealImagePath);
            }
            errCode = this.setVisibleAppearence(sealImage, pageIndex, rectangle, sealImageOpacity);
        }
        catch (IOException e) {
            return -2119;
        }
        catch (DocumentException e) {
            return -2110;
        }
        return errCode;
    }

    public int setVisibleAppearence(Image sealImage, int pageIndex, Rectangle rectangle, float sealImageOpacity) {
        if (pageIndex <= 0 || pageIndex > this.m_reader.getNumberOfPages()) {
            pageIndex = this.m_reader.getNumberOfPages();
        }
        if (sealImage == null && rectangle != null) {
            this.m_appearance.setVisibleSignature(rectangle, pageIndex, this.fieldNameString);
        } else if (sealImage != null) {
            if (rectangle == null) {
                rectangle = this.getDefaultRectangle(pageIndex);
            }
            if (sealImageOpacity < 0.0f || sealImageOpacity > 1.0f) {
                sealImageOpacity = 1.0f;
            }
            this.m_appearance.setVisibleSignature(rectangle, pageIndex, this.fieldNameString);
            PdfTemplate layer = this.m_appearance.getLayer(0);
            PdfGState gstate = new PdfGState();
            float x = layer.getBoundingBox().getLeft();
            float y = layer.getBoundingBox().getBottom();
            gstate.setFillOpacity(sealImageOpacity);
            gstate.setBlendMode(PdfGState.BM_MULTIPLY);
            layer.setGState(gstate);
            sealImage.setAbsolutePosition(x, y);
            sealImage.scaleToFit(rectangle);
            try {
                layer.addImage(sealImage);
            }
            catch (DocumentException e) {
                return -2110;
            }
            this.m_appearance.setLayer2Text("");
        }
        return 0;
    }

    private Rectangle getDefaultRectangle(int pageIndex) {
        float width;
        float pageHeight;
        Rectangle pageRectangle = this.m_reader.getPageSize(pageIndex);
        float pageWidth = pageRectangle.getWidth();
        float base = pageWidth <= (pageHeight = pageRectangle.getHeight()) ? pageWidth : pageHeight;
        float height = width = base / 4.0f;
        float margin = base / 10.0f;
        float llx = pageRectangle.getLeft() + pageWidth - (width + margin);
        float lly = pageRectangle.getBottom() + margin;
        float urx = pageWidth - margin;
        float ury = height + margin;
        Rectangle rectangle = new Rectangle(llx, lly, urx, ury);
        return rectangle;
    }

    private void initAppearance() throws Svs2ClientPDFException {
        this.m_appearance.setReason("defaultReason");
        this.m_appearance.setLocation("defaultLocation");
        this.fieldNameString = new String("sig" + new Long(Calendar.getInstance().getTimeInMillis()).toString());
        this.m_appearance.setVisibleSignature(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f), this.m_reader.getNumberOfPages(), this.fieldNameString);
    }

    public Svs2ClientPDFHelper(Svs2ClientHelper clientHelper, String certId) {
        this.m_clientHelper = clientHelper;
        this.m_certId = certId;
    }

    public Svs2ClientPDFHelper(String p12File, String passwd) throws Svs2ClientPDFException {
        this.loadPfx(p12File, passwd);
    }

    public Svs2ClientPDFHelper(InputStream p12Stream, String passwd) throws Svs2ClientPDFException {
        this.loadPfx(p12Stream, passwd);
    }

    protected void cleanFileInfo() {
        if (this.m_fin != null) {
            try {
                this.m_fin.close();
            }
            catch (IOException e) {
                LogUtil.error("close pdf inputStream error");
            }
            this.m_fin = null;
        }
        if (this.m_fout != null) {
            try {
                this.m_fout.close();
            }
            catch (IOException e) {
                LogUtil.error("close pdf outputStream error");
            }
            this.m_fout = null;
        }
        if (this.m_pfx != null) {
            try {
                this.m_pfx.close();
            }
            catch (IOException e) {
                LogUtil.error("close pfx inputStream error");
            }
            this.m_pfx = null;
        }
    }

    protected void cleanSignInfo() {
        this.m_reader = null;
        this.m_stamper = null;
        this.m_appearance = null;
    }

    protected void cleanKeyInfo() {
        this.m_keyStore = null;
        this.m_privKey = null;
        this.m_certChain = null;
    }

    protected void loadPfx(String p12File, String passwd) throws Svs2ClientPDFException {
        this.cleanFileInfo();
        try {
            this.m_pfx = new FileInputStream(p12File);
        }
        catch (FileNotFoundException e1) {
            throw new Svs2ClientPDFException(-2125, "pdf file not found", e1);
        }
        this.loadPfx(this.m_pfx, passwd);
    }

    protected void loadPfx(InputStream p12Stream, String passwd) throws Svs2ClientPDFException {
        this.cleanKeyInfo();
        try {
            this.m_keyStore = KeyStore.getInstance("pkcs12", this.m_providerName);
        }
        catch (KeyStoreException e) {
            throw new Svs2ClientPDFException(-2118, "key store error", e);
        }
        catch (NoSuchProviderException e) {
            throw new Svs2ClientPDFException(-2124, (Throwable)e);
        }
        BufferedInputStream p12BufferedStream = new BufferedInputStream(p12Stream);
        try {
            p12BufferedStream.mark(p12BufferedStream.available());
        }
        catch (IOException e) {
            throw new Svs2ClientPDFException(-2123, (Throwable)e);
        }
        try {
            this.m_keyStore.load(p12BufferedStream, passwd.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientPDFException(-2112, "the algorithm used to check the integrity of the keystore cannot be found", e);
        }
        catch (CertificateException e) {
            throw new Svs2ClientPDFException(-2115, "load certificat in keystore error", e);
        }
        catch (IOException e) {
            try {
                this.m_keyStore = KeyStore.getInstance("pkcs12");
            }
            catch (KeyStoreException e1) {
                throw new Svs2ClientPDFException(-2118, "key store error", e1);
            }
            try {
                p12BufferedStream.reset();
            }
            catch (IOException e1) {
                throw new Svs2ClientPDFException(-2130, (Throwable)e1);
            }
            try {
                this.m_keyStore.load(p12BufferedStream, passwd.toCharArray());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new Svs2ClientPDFException(-2112, "the algorithm used to check the integrity of the keystore cannot be found", e1);
            }
            catch (CertificateException e1) {
                throw new Svs2ClientPDFException(-2115, "load certificat in keystore error", e1);
            }
            catch (IOException e1) {
                throw new Svs2ClientPDFException(-2114, "your passwd or pkcs12 formation error", e1);
            }
        }
        try {
            String alias = this.m_keyStore.aliases().nextElement();
            this.m_privKey = (PrivateKey)this.m_keyStore.getKey(alias, passwd.toCharArray());
            this.m_certChain = this.m_keyStore.getCertificateChain(alias);
        }
        catch (UnrecoverableKeyException e) {
            throw new Svs2ClientPDFException(-2106, "unrecoverable key error", e);
        }
        catch (KeyStoreException e) {
            throw new Svs2ClientPDFException(-2118, "key store error", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientPDFException(-2112, "the algorithm used to check the integrity of the keystore cannot be found", e);
        }
    }

    public void loadPdf(String pdfInputFile, String pdfOutputFile) throws Svs2ClientPDFException {
        this.cleanFileInfo();
        try {
            this.m_fin = new FileInputStream(pdfInputFile);
            this.m_fout = new FileOutputStream(pdfOutputFile);
            this.loadPdf(this.m_fin, this.m_fout);
        }
        catch (FileNotFoundException e1) {
            throw new Svs2ClientPDFException(-2125, "pdf file not found", e1);
        }
    }

    private static PdfReader getPdfReader(InputStream pdfIn) throws Svs2ClientPDFException {
        PdfReader reader = null;
        RandomAccessFileOrArray rafa = null;
        RandomAccessSourceFactory rasf = new RandomAccessSourceFactory();
        RandomAccessSource ras = null;
        try {
            if (pdfIn instanceof FileInputStream) {
                FileInputStream fPdfIn = (FileInputStream)pdfIn;
                ras = rasf.createBestSource(fPdfIn.getChannel());
            } else {
                ras = rasf.createSource(pdfIn);
            }
            rafa = new RandomAccessFileOrArray(ras);
            reader = new PdfReader(rafa, null, true);
        }
        catch (IOException e) {
            throw new Svs2ClientPDFException(-2101, "load pdf data failed", e);
        }
        return reader;
    }

    public void loadPdf(InputStream pdfIn, OutputStream pdfOut) throws Svs2ClientPDFException {
        this.cleanSignInfo();
        try {
            this.m_reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
            this.m_stamper = PdfStamper.createSignature((PdfReader)this.m_reader, (OutputStream)pdfOut, (char)'\u0000', null, (boolean)true);
            this.m_appearance = this.m_stamper.getSignatureAppearance();
            this.initAppearance();
        }
        catch (DocumentException e) {
            throw new Svs2ClientPDFException(-2101, "load pdf data failed", e);
        }
        catch (IOException e) {
            throw new Svs2ClientPDFException(-2101, "load pdf data failed", e);
        }
    }

    public int sign() {
        try {
            try {
                if (this.m_keyStore != null && this.m_privKey != null) {
                    LogUtil.info("local sign ");
                    this.localSign();
                } else {
                    LogUtil.info("svs sign ");
                    this.svsSign();
                }
            }
            catch (Svs2ClientPDFException e) {
                this.cleanSignInfo();
                LogUtil.error(e.log());
                int n = e.errCode;
                this.cleanFileInfo();
                return n;
            }
        }
        finally {
            this.cleanFileInfo();
        }
        LogUtil.info("successfully");
        return 0;
    }

    protected void localSign() throws Svs2ClientPDFException {
        if (this.m_keyStore == null || this.m_privKey == null) {
            throw new Svs2ClientPDFException(-2126);
        }
        PrivateKeySignature signature = new PrivateKeySignature(this.m_privKey, this.m_hashAlg, this.m_providerName);
        this.signInner((ExternalSignature)signature);
    }

    protected void svsSign() throws Svs2ClientPDFException {
        SvsSignature signature = new SvsSignature(this.m_clientHelper, this.m_certId);
        this.m_certChain = new Certificate[1];
        try {
            this.m_certChain[0] = signature.getSignCert();
            if (this.m_certChain[0] == null) {
                throw new Svs2ClientPDFException(-2128, "get sign certificate when svs sign");
            }
        }
        catch (CertificateException e) {
            throw new Svs2ClientPDFException(-2128, "get sign certificate when svs sign", e);
        }
        this.signInner(signature);
    }

    protected void signInner(ExternalSignature signature) throws Svs2ClientPDFException {
        if (this.m_appearance == null) {
            throw new Svs2ClientPDFException(-2127);
        }
        try {
            ProviderDigest digest = new ProviderDigest(this.m_providerName);
            MakeSignature.signDetached((PdfSignatureAppearance)this.m_appearance, (ExternalDigest)digest, (ExternalSignature)signature, (Certificate[])this.m_certChain, null, null, null, (int)this.reserveSignSize, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CMS);
        }
        catch (DocumentException e) {
            throw new Svs2ClientPDFException(-2111, "document operation error", e);
        }
        catch (GeneralSecurityException e) {
            throw new Svs2ClientPDFException(-2113, "general security error", e);
        }
        catch (IOException e) {
            if (e.getMessage().equals("Not enough space")) {
                throw new Svs2ClientPDFException(-2117, (Throwable)e);
            }
            throw new Svs2ClientPDFException(-2119, "io exception when make signature", e);
        }
    }

    private static byte[] getOri(PdfReader reader, PdfArray byteRange) throws Svs2ClientPDFException {
        ByteBuffer byteBuffer;
        RandomAccessFileOrArray rf = reader.getSafeFile();
        InputStream rg = null;
        try {
            try {
                int rd;
                rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), byteRange.asLongArray()));
                byteBuffer = new ByteBuffer();
                byte[] buf = new byte[8192];
                while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                    byteBuffer.append(buf, 0, rd);
                }
            }
            catch (IOException e) {
                throw new Svs2ClientPDFException(-2100, "read orignal content of signature error", e);
            }
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e) {
                throw new Svs2ClientPDFException(-2100, "close input stream error", e);
            }
        }
        return byteBuffer.toByteArray();
    }

    private static byte[] getOri(PdfReader reader, AcroFields fields, String name) throws Svs2ClientPDFException {
        ByteBuffer byteBuffer;
        RandomAccessFileOrArray rf = reader.getSafeFile();
        InputStream rg = null;
        PdfDictionary sigDictionary = fields.getSignatureDictionary(name);
        PdfArray byteRange = sigDictionary.getAsArray(PdfName.BYTERANGE);
        try {
            try {
                int rd;
                rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), byteRange.asLongArray()));
                byteBuffer = new ByteBuffer();
                byte[] buf = new byte[8192];
                while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                    byteBuffer.append(buf, 0, rd);
                }
            }
            catch (IOException e) {
                throw new Svs2ClientPDFException(-2100, "read orignal content of signature error", e);
            }
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e) {
                throw new Svs2ClientPDFException(-2100, "close input stream error", e);
            }
        }
        return byteBuffer.toByteArray();
    }

    private static int getSigCoverRange(AcroFields fields, String name) {
        PdfDictionary sigDictionary = fields.getSignatureDictionary(name);
        PdfArray sigRange = sigDictionary.getAsArray(PdfName.BYTERANGE);
        return sigRange.getAsNumber(sigRange.size() - 2).intValue() + sigRange.getAsNumber(sigRange.size() - 1).intValue();
    }

    private static int getSigCoverRange(PdfArray byteRange) {
        return byteRange.getAsNumber(byteRange.size() - 2).intValue() + byteRange.getAsNumber(byteRange.size() - 1).intValue();
    }

    private static int getMaxSigRange(PdfReader reader) {
        int maxRange = 0;
        AcroFields fields = reader.getAcroFields();
        ArrayList names = fields.getSignatureNames();
        for (String name : names) {
            int range = Svs2ClientPDFHelper.getSigCoverRange(fields, name);
            if (range <= maxRange) continue;
            maxRange = range;
        }
        return maxRange;
    }

    private static Boolean changedAfterSign(PdfReader reader) throws Svs2ClientPDFException {
        if (reader.getFileLength() > (long)Svs2ClientPDFHelper.getMaxSigRange(reader)) {
            return true;
        }
        return false;
    }

    private static int localVerify(byte[] sig, byte[] sigOri, PdfName filterSubtype) throws Svs2ClientPDFException {
        PdfPKCS7 pdfPkcs7 = new PdfPKCS7(sig, filterSubtype, null);
        try {
            pdfPkcs7.update(sigOri, 0, sigOri.length);
        }
        catch (SignatureException e) {
            throw new Svs2ClientPDFException(-2138, "add sigOri", e);
        }
        try {
            if (!pdfPkcs7.verify()) {
                throw new Svs2ClientPDFException(-2107, "pkcs7 Detach Verify error");
            }
            return 0;
        }
        catch (Svs2ClientPDFException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new Svs2ClientPDFException(-2107, "verify signature error", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int svsVerify(byte[] sigContent, byte[] sigOri, Svs2ClientHelper clientHelper) throws Svs2ClientPDFException {
        block6: {
            String b64OriDigest;
            SignerInfo signerInfo = null;
            if (clientHelper == null) {
                throw new Svs2ClientPDFException(-2121, "client helper  is NULL");
            }
            signerInfo = PKCS7SignUtil.getSignerInfo(sigContent);
            byte[] authenticatedAttrs = PKCS7SignUtil.getAuthenticatedAttrs(signerInfo);
            if (authenticatedAttrs == null) throw new Svs2ClientPDFException(-2102, "parse p7 not format with authAttr error");
            int digestAlg = PKCS7SignUtil.getDigestAlgorithm(signerInfo);
            byte[] encryptedDigest = PKCS7SignUtil.getEncryptedDigest(signerInfo);
            String b64EncryptedDigeString = new String(Svs2ClientHelper.base64Encode(encryptedDigest));
            String certDn = PKCS7SignUtil.getSignerCertDN(sigContent);
            Svs2ClientHelper.SvsResultData svsResultData = clientHelper.cdbVerifySign(authenticatedAttrs, digestAlg, b64EncryptedDigeString, certDn);
            if (svsResultData.m_errno != 0) {
                throw new Svs2ClientPDFException(svsResultData.m_errno, "pkcs7 Detach Verify error");
            }
            byte[] messgeDigest = PKCS7SignUtil.getMessageDigestAttrInAuthenticatedAttris(signerInfo);
            String b64MessageDigest = new String(Svs2ClientHelper.base64Encode(messgeDigest));
            if (!b64MessageDigest.equals(b64OriDigest = new String(Svs2ClientHelper.base64Encode(Svs2ClientHelper.digest(sigOri, digestAlg))))) break block6;
            return 0;
        }
        try {
            throw new Svs2ClientPDFException(-2131, "origin digest not equal digest in attrs");
        }
        catch (PKCS7Exception e) {
            throw new Svs2ClientPDFException(-2102, "parse p7 signature error", e);
        }
        catch (Svs2ClientException e) {
            throw new Svs2ClientPDFException(-2103, "digest error ", e);
        }
    }

    public static int verify(String pdfIn, Svs2ClientHelper clientHelper) {
        int errCode;
        FileInputStream pdfInStream = null;
        try {
            try {
                pdfInStream = new FileInputStream(pdfIn);
                errCode = Svs2ClientPDFHelper.verify(pdfInStream, clientHelper);
            }
            catch (FileNotFoundException e1) {
                try {
                    pdfInStream.close();
                }
                catch (IOException e) {
                    LogUtil.error("file close error " + pdfIn);
                }
                return -2125;
            }
        }
        finally {
            try {
                pdfInStream.close();
            }
            catch (IOException e) {
                LogUtil.error("file close error " + pdfIn);
            }
        }
        return errCode;
    }

    private static int innerSlowVerify(InputStream pdfIn, Svs2ClientHelper clientHelper) throws Svs2ClientPDFException {
        PdfReader reader;
        boolean changedAfterLastSign = true;
        try {
            reader = new PdfReader(pdfIn);
        }
        catch (IOException e) {
            throw new Svs2ClientPDFException(-2101, "load pdf data failed", e);
        }
        AcroFields fields = reader.getAcroFields();
        ArrayList names = fields.getSignatureNames();
        if (names.size() == 0) {
            throw new Svs2ClientPDFException(-2109, "no have signature in pdf");
        }
        for (String name : names) {
            PdfDictionary sigDic = fields.getSignatureDictionary(name);
            PdfString sigContent = sigDic.getAsString(PdfName.CONTENTS);
            if (sigContent == null) {
                throw new Svs2ClientPDFException(-2136, "get sigContent error (pdf formation invalid)");
            }
            byte[] sigOri = Svs2ClientPDFHelper.getOri(reader, fields, name);
            if (clientHelper != null) {
                Svs2ClientPDFHelper.svsVerify(sigContent.getOriginalBytes(), sigOri, clientHelper);
            } else {
                PdfName filterSubtype = sigDic.getAsName(PdfName.FILTER);
                Svs2ClientPDFHelper.localVerify(sigContent.getOriginalBytes(), sigOri, filterSubtype);
            }
            if (!fields.signatureCoversWholeDocument(name)) continue;
            changedAfterLastSign = false;
        }
        if (changedAfterLastSign) {
            return 1;
        }
        return 0;
    }

    private static int innerVerify(InputStream pdfIn, Svs2ClientHelper clientHelper) throws Svs2ClientPDFException {
        int maxSigCoverRange = 0;
        int sigCoverRange = 0;
        boolean hasSig = false;
        PdfReader reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
        ArrayList<PRAcroForm.FieldInformation> fieldInfos = Svs2ClientPDFHelper.getFieldInformations(reader);
        ArrayList<PdfDictionary> signFields = Svs2ClientPDFHelper.getSignFields(fieldInfos);
        for (PdfDictionary fieldDic : signFields) {
            hasSig = true;
            PdfDictionary sigDic = fieldDic.getAsDict(PdfName.V);
            if (sigDic == null) {
                throw new Svs2ClientPDFException(-2135, "get sigDic error (pdf formation invalid)");
            }
            PdfString sigContent = sigDic.getAsString(PdfName.CONTENTS);
            if (sigContent == null) {
                throw new Svs2ClientPDFException(-2136, "get sigContent error (pdf formation invalid)");
            }
            byte[] sig = sigContent.getOriginalBytes();
            PdfArray byteRange = sigDic.getAsArray(PdfName.BYTERANGE);
            if (byteRange == null) {
                throw new Svs2ClientPDFException(-2137, "get sig byte range error (pdf formation invalid)");
            }
            byte[] sigOri = Svs2ClientPDFHelper.getOri(reader, byteRange);
            sigCoverRange = Svs2ClientPDFHelper.getSigCoverRange(byteRange);
            if (sigCoverRange > maxSigCoverRange) {
                maxSigCoverRange = sigCoverRange;
            }
            if (clientHelper != null) {
                if (Svs2ClientPDFHelper.svsVerify(sig, sigOri, clientHelper) != 0) continue;
                continue;
            }
            PdfName filterSubtype = sigDic.getAsName(PdfName.FILTER);
            if (filterSubtype == null) {
                throw new Svs2ClientPDFException(-2139, "get subFilterType error(pdf formation error)");
            }
            if (Svs2ClientPDFHelper.localVerify(sig, sigOri, filterSubtype) != 0) continue;
        }
        if (!hasSig) {
            throw new Svs2ClientPDFException(-2109, "no have signature in pdf");
        }
        if ((long)maxSigCoverRange < reader.getFileLength()) {
            return 1;
        }
        return 0;
    }

    public static int verify(InputStream pdfIn, Svs2ClientHelper clientHelper) {
        int errCode = 0;
        try {
            errCode = Svs2ClientPDFHelper.innerVerify(pdfIn, clientHelper);
        }
        catch (Svs2ClientPDFException e) {
            LogUtil.error(e.log());
            return e.errCode;
        }
        LogUtil.info("ok with code " + errCode);
        return errCode;
    }

    private static byte[] trimSigContent(byte[] sigContent) throws Svs2ClientPDFException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1InputStream asn1InputStream = new ASN1InputStream(sigContent);
        try {
            DERObject derObject = asn1InputStream.readObject();
            DEROutputStream derOutputStream = new DEROutputStream(byteArrayOutputStream);
            derOutputStream.writeObject(derObject);
        }
        catch (IOException e) {
            throw new Svs2ClientPDFException(-2122, "pkcs7 Detach Verify error", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getVersion() {
        return Svs2ClientHelper.version();
    }

    public static ArrayList<byte[]> getSignatures(String pdfIn) throws Svs2ClientPDFException {
        ArrayList<byte[]> arrayList;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(pdfIn);
                arrayList = Svs2ClientPDFHelper.getSignatures(inputStream);
            }
            catch (IOException e) {
                LogUtil.error("file open error " + pdfIn);
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    LogUtil.error("file close error " + pdfIn);
                }
                return null;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogUtil.error("file close error " + pdfIn);
            }
        }
        return arrayList;
    }

    public static ArrayList<byte[]> getSignatures(InputStream pdfIn) {
        try {
            return Svs2ClientPDFHelper.getInnerSignatures(pdfIn);
        }
        catch (Svs2ClientPDFException e) {
            LogUtil.error("get signatures error" + e.log());
            return null;
        }
    }

    public static ArrayList<byte[]> getInnerSignaturesSlow(InputStream pdfIn) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try (PdfReader reader = null;){
            try {
                reader = new PdfReader(pdfIn);
            }
            catch (IOException e) {
                if (reader != null) {
                    reader.close();
                }
                return null;
            }
            AcroFields fields = reader.getAcroFields();
            ArrayList names = fields.getSignatureNames();
            for (String name : names) {
                try {
                    PdfDictionary sigDic = fields.getSignatureDictionary(name);
                    PdfString sigContent = sigDic.getAsString(PdfName.CONTENTS);
                    if (sigContent == null) {
                        throw new Svs2ClientPDFException(-2136, "get sigContent error (pdf formation invalid)");
                    }
                    arrayList.add(Svs2ClientPDFHelper.trimSigContent(sigContent.getOriginalBytes()));
                }
                catch (Svs2ClientPDFException e) {
                    LogUtil.error("inputStream invalide ,fail to create pdf reader");
                    if (reader != null) {
                        reader.close();
                    }
                    return null;
                }
            }
        }
        return arrayList;
    }

    private static ArrayList<PRAcroForm.FieldInformation> getFieldInformations(PdfReader reader) throws Svs2ClientPDFException {
        PRAcroForm prAcroForm = reader.getAcroForm();
        if (prAcroForm == null) {
            throw new Svs2ClientPDFException(-2132, "no have acroform in this pdf");
        }
        ArrayList fieldInfos = prAcroForm.getFields();
        if (fieldInfos == null || fieldInfos.size() == 0) {
            throw new Svs2ClientPDFException(-2133, "no have fields  in this acroform or count of fields is zero");
        }
        return fieldInfos;
    }

    private static ArrayList<PdfDictionary> getSignFields(ArrayList<PRAcroForm.FieldInformation> fieldInfos) throws Svs2ClientPDFException {
        ArrayList<PdfDictionary> signFields = new ArrayList<PdfDictionary>();
        for (PRAcroForm.FieldInformation field : fieldInfos) {
            PdfDictionary fieldDic = field.getInfo();
            PdfName fieldType = fieldDic.getAsName(PdfName.FT);
            if (fieldType == null) {
                throw new Svs2ClientPDFException(-2134, "get fieldtype error (pdf formation invalid)");
            }
            if (!fieldType.equals((Object)PdfName.SIG)) continue;
            signFields.add(fieldDic);
        }
        return signFields;
    }

    private static ArrayList<byte[]> getInnerSignatures(InputStream pdfIn) throws Svs2ClientPDFException {
        PdfReader reader = null;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
        ArrayList<PRAcroForm.FieldInformation> fieldInfos = Svs2ClientPDFHelper.getFieldInformations(reader);
        ArrayList<PdfDictionary> signFields = Svs2ClientPDFHelper.getSignFields(fieldInfos);
        for (PdfDictionary fieldDic : signFields) {
            PdfDictionary sigDic = fieldDic.getAsDict(PdfName.V);
            if (sigDic == null) {
                throw new Svs2ClientPDFException(-2135, "get sigDic error (pdf formation invalid)");
            }
            PdfString sigContent = sigDic.getAsString(PdfName.CONTENTS);
            if (sigContent == null) {
                throw new Svs2ClientPDFException(-2136, "get sigContent error (pdf formation invalid)");
            }
            byte[] sig = sigContent.getOriginalBytes();
            arrayList.add(Svs2ClientPDFHelper.trimSigContent(sig));
        }
        return arrayList;
    }

    public static ArrayList<String> getInnerSignReasonsSlow(InputStream pdfIn) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (PdfReader reader = null;){
            try {
                reader = new PdfReader(pdfIn);
            }
            catch (IOException e) {
                if (reader != null) {
                    reader.close();
                }
                return null;
            }
            AcroFields fields = reader.getAcroFields();
            ArrayList names = fields.getSignatureNames();
            for (String name : names) {
                try {
                    PdfDictionary sigDic = fields.getSignatureDictionary(name);
                    PdfString sigContent = sigDic.getAsString(PdfName.CONTENTS);
                    if (sigContent == null) {
                        throw new Svs2ClientPDFException(-2136, "get sigContent error (pdf formation invalid)");
                    }
                    PdfString sigReason = sigDic.getAsString(PdfName.REASON);
                    if (sigReason == null) {
                        throw new Svs2ClientPDFException(-2140, "get sigature reason error (pdf formation invalid)");
                    }
                    arrayList.add(sigReason.toString());
                }
                catch (Svs2ClientPDFException e) {
                    LogUtil.error("inputStream invalide ,fail to create pdf reader");
                    if (reader != null) {
                        reader.close();
                    }
                    return null;
                }
            }
        }
        return arrayList;
    }

    private static ArrayList<String> getInnerSignReasons(InputStream pdfIn) throws Svs2ClientPDFException {
        PdfReader reader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
        ArrayList<PRAcroForm.FieldInformation> fieldInfos = Svs2ClientPDFHelper.getFieldInformations(reader);
        ArrayList<PdfDictionary> signFields = Svs2ClientPDFHelper.getSignFields(fieldInfos);
        for (PdfDictionary fieldDic : signFields) {
            PdfDictionary sigDic = fieldDic.getAsDict(PdfName.V);
            if (sigDic == null) {
                throw new Svs2ClientPDFException(-2135, "get sigDic error (pdf formation invalid)");
            }
            PdfString sigReason = sigDic.getAsString(PdfName.REASON);
            if (sigReason == null) {
                throw new Svs2ClientPDFException(-2140, "get sigature reason error (pdf formation invalid)");
            }
            arrayList.add(sigReason.toString());
        }
        return arrayList;
    }

    public static ArrayList<String> getSignReasons(InputStream pdfIn) {
        try {
            return Svs2ClientPDFHelper.getInnerSignReasons(pdfIn);
        }
        catch (Svs2ClientPDFException e) {
            LogUtil.error("get signatures error" + e.log());
            return null;
        }
    }

    public static ArrayList<String> getSignReasons(String pdfIn) {
        ArrayList<String> arrayList;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(pdfIn);
                arrayList = Svs2ClientPDFHelper.getSignReasons(inputStream);
            }
            catch (IOException e) {
                LogUtil.error("file open error " + pdfIn);
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    LogUtil.error("file close error " + pdfIn);
                }
                return null;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogUtil.error("file close error " + pdfIn);
            }
        }
        return arrayList;
    }

    public static Rectangle getPageSize(String pdfIn, int pageIndex) {
        Rectangle rectangle;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(pdfIn);
                rectangle = Svs2ClientPDFHelper.getPageSize(inputStream, pageIndex);
            }
            catch (IOException e) {
                LogUtil.error("file open error " + pdfIn);
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    LogUtil.error("file close error " + pdfIn);
                }
                return null;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogUtil.error("file close error " + pdfIn);
            }
        }
        return rectangle;
    }

    public static Rectangle getPageSize(InputStream pdfIn, int pageIndex) {
        PdfReader reader;
        try {
            reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
        }
        catch (Svs2ClientPDFException e) {
            LogUtil.error("inputStream invalide ,fail to create pdf reader" + e.log());
            return null;
        }
        if (pageIndex > reader.getNumberOfPages() || pageIndex <= 0) {
            LogUtil.error("pageIndex invalide");
            return null;
        }
        return reader.getPageSize(pageIndex);
    }

    public static int getPageCount(String pdfIn) {
        int result = 0;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(pdfIn);
                result = Svs2ClientPDFHelper.getPageCount(inputStream);
            }
            catch (IOException e) {
                LogUtil.error("file open error " + pdfIn);
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    LogUtil.error("file close error " + pdfIn);
                }
                return -2101;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogUtil.error("file close error " + pdfIn);
            }
        }
        return result;
    }

    public static int getPageCount(InputStream pdfIn) {
        PdfReader reader;
        try {
            reader = Svs2ClientPDFHelper.getPdfReader(pdfIn);
        }
        catch (Svs2ClientPDFException e) {
            LogUtil.error("inputStream invalide ,fail to create pdf reader" + e.log());
            return e.errCode;
        }
        return reader.getNumberOfPages();
    }

    public int setLogFile(String filePath) {
        if (LogUtil.getFileLogger() != null) {
            return -1;
        }
        if (filePath == null) {
            LogUtil.clean();
        } else {
            LogUtil.init(filePath);
        }
        return 0;
    }
}

