/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.test;

import com.koalii.svs.SvsHelper;
import com.koalii.svs.SvsSign;
import com.koalii.svs.X509CertChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class SvsHelperTest
extends TestCase {
    public static String p7s = "MIIFYQYJKoZIhvcNAQcCoIIFUjCCBU4CAQExCzAJBgUrDgMCGgUAMBsGCSqGSIb3DQEHAaAOBAxIZWxsbywgS29hbCGgggQVMIIEETCCA3qgAwIBAgIMBYfFNafRExSveQLcMA0GCSqGSIb3DQEBBQUAME4xDTALBgNVBAYeBABDAE4xDTALBgNVBAgeBABTAEgxETAPBgNVBAoeCABLAE8AQQBMMRswGQYDVQQDHhIAVABlAHMAdABOAGUAdwBDAEEwHhcNMDYwNjA3MDMxMDIyWhcNMDgwNjA2MDMxMDIyWjCCARsxDTALBgNVBAYeBE4tVv0xDTALBgNVBAgeBABiAGoxDTALBgNVBAceBABqAGIxEzARBgNVBAoeCgBjAGEAcwBpAGMxFTATBgNVBAseDABzAGUAYwBvAG4AZDE7MDkGCSqGSIb3DQEJAR4sAHQAZQBzAHQAdwBpAG4AZABjAGgAaQBsAGwAQABrAG8AYQBsAC4AYwBvAG0xIzAhBgNVBCoeGgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsMS0wKwYDVQQBHiQAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADExLzAtBgNVBAMeJgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsADkAMgA2ADAANwAzMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC0LZkGcWwC+Fs7V8XtbmgIqYr+hFHMzPMOsZFmelP2998sTzo9L8viHpnA4QdcHLtkT0zUor0VBukT4uvejRxR2mLTFJXxqNswPj97S/17Vev9L1jTVTfPcOjjZUwzfDlz5m046EGyjpaY+Lhh461as3X+gqxDCcQ6lvyaKZOhPQIDAQABo4IBIzCCAR8wDwYDVR0TAQEABAUwAwEBADAOBgNVHQ8BAQAEBAMCAOgwFgYDVR0lAQEABAwwCgYIKwYBBQUHAwIwIgYDVR0jAQEABBgwFoAUMCrw9mq2mKMGSBbHiMXwVij0Yx8wTQYDVR0fAQEABEMwQTA/oD2gO4Y5aHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9lbnRpdHlpZDE0Z3JvdXBpZDAuY3JsME8GCCsGAQUFBwEBAQEABEAwPjA8BggrBgEFBQcwAoYwaHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9UZXN0TmV3Q0EuY2VyMCAGA1UdDgEBAAQWBBSv/lwU5uPHe269MO74mWtMOeU9azANBgkqhkiG9w0BAQUFAAOBgQBEdDno3Is9kAvP1+uA/K7XYvjqWkJcJEa/JkWG7ypY26yQpYdKKbrOhs5XN96eqy0PGS84jYrlRwdzXc4743dRD9QHYYtDln47euVxY+7IPcgHzEu9xXEsl03KEKnun0R2aDbgTSe8i+wBLc/r0UyhTCXK3igz9wGPpKwdfJjsfjGCAQQwggEAAgEBMF4wTjENMAsGA1UEBh4EAEMATjENMAsGA1UECB4EAFMASDERMA8GA1UECh4IAEsATwBBAEwxGzAZBgNVBAMeEgBUAGUAcwB0AE4AZQB3AEMAQQIMBYfFNafRExSveQLcMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYCbC3YlYuFHHidfs8e/x9fmtfSHU9vHC+7ZIglznYKBTTZl369PRbreurAzg13PabIdGeR/paUCk4KZYezqVXDTbCk6YT4PeWmQq0TM0WPic/51f9UUF4rPbQmOIQg0yZp8QeLnOwwUUvbukM0e0I3doXOdriWQApgPFNSbVhbAaQ==";
    public static String testSignCert = "cert\\test1.cer";
    public static String testSignPfx = "cert\\test1.pfx";
    public static String testSignPfxPw = "123456";

    public static void main(String[] args) {
        TestRunner.run(SvsHelperTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGetOriData() {
        String oriString = "\ufffd\ufffd\ufffd\ufffd \u052d\ufffd\u0123\ufffd\ufffd\ufffd\ufffd\u0523\ufffdtest6";
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String p7 = signer.pkcs7SignData(oriString.getBytes());
            String test = new String(SvsHelper.getOriData(p7));
            if (test.equals(oriString)) {
                System.out.println("OK--- testGetOriData ");
            } else {
                System.out.println("ERROR--- testGetOriData ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void testGetCerts() {
        String oriString = "\ufffd\ufffd\ufffd\ufffd \u052d\ufffd\u0123\ufffd\ufffd\ufffd\ufffd\u0523\ufffdtest6";
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String p7 = signer.pkcs7SignData(oriString.getBytes());
            X509Certificate[] certs = SvsHelper.getCerts(p7);
            X509Certificate cert = null;
            cert = X509CertChecker.parseX509Cert(testSignCert);
            System.out.println(cert.getSubjectDN().getName());
            int i = 0;
            while (i < certs.length) {
                System.out.println(certs[i].getSubjectDN().getName());
                if (cert.getSubjectDN().getName().toString().equals(certs[i].getSubjectDN().getName().toString())) {
                    System.out.println("OK--- testGetCerts ");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void testGetCertSubjectInfo() {
        X509Certificate cert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(cert.getSubjectDN().getName());
        System.out.println(SvsHelper.getSubjectInfo(cert, "cn")[0]);
        System.out.println(SvsHelper.getSubjectInfo(cert, "o")[0]);
        System.out.println(SvsHelper.getSubjectInfo(cert, "ou")[0]);
        String s = "CN=testwindchill926073, OID.2.5.4.1=111111111111111111, GIVENNAME=testwindchill, EMAILADDRESS=testwindchill@koal.com, OU=second, O=casic, L=jb, ST=bj, C=\ufffd\u0439\ufffd, OU=Customers, OU=CZBANK";
        String KEY = "ou".toUpperCase();
        ArrayList<String> list = new ArrayList<String>();
        String[] ss = s.split(",");
        int i = 0;
        while (i < ss.length) {
            if (ss[i].trim().startsWith(String.valueOf(KEY) + "=")) {
                String[] ss2 = ss[i].split("=");
                list.add(ss2[1].trim());
            }
            ++i;
        }
        String[] ss1 = list.toArray(new String[list.size()]);
        System.out.println(ss1[0]);
        System.out.println(ss1[1]);
        System.out.println(ss1[2]);
    }
}

