/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.test;

import com.koalii.svs.SvsSign;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import junit.framework.TestCase;

public class SvsSignTest
extends TestCase {
    public static String testSignCert = "cert\\test1.cer";
    public static String testSignPfx = "cert\\test1.pfx";
    public static String testSignPfxPw = "123456";
    public static String testFile = "cert\\test1.pfx";

    public static void main(String[] args) {
        new SvsSignTest().testPkcs7SignData();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public SvsSignTest(String arg0) {
        super(arg0);
    }

    public SvsSignTest() {
    }

    public final void testListAllProviders() {
    }

    public final void testInitSignCertAndKey() {
        System.out.println("====== testInitSignCertAndKey ======");
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testInitSignCertAndKeyInputStream() {
        System.out.println("====== testInitSignCertAndKeyInputStream ======");
        SvsSign signer = new SvsSign();
        try {
            FileInputStream fin = new FileInputStream(testSignPfx);
            signer.initSignCertAndKey(fin, testSignPfxPw);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testSignDatabyteArrayintint() {
        System.out.println("====== testSignDatabyteArrayintint ======");
        String szData = "Hello, Koal!";
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String szRet = signer.signData(szData.getBytes(), 0, szData.getBytes().length);
            System.out.println(szRet);
            String szCert = signer.getEncodedSignCert();
            System.out.println("Sign cert ->");
            System.out.println(szCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testSignDataAndVerifyCert() {
        System.out.println("====== testSignDataAndVerifyCert ======");
        String szData = "Hello, Koal!";
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            int nRet = signer.checkSignCert();
            if (nRet == 0) {
                System.out.println("[OK] Verify sign cert OK");
            } else {
                System.out.println("[ERROR] Verify sign cert ERROR: " + nRet);
            }
            String szRet = signer.signData(szData.getBytes());
            X509Certificate signCert = signer.getSignCert();
            String dn = signCert.getSubjectDN().getName();
            BigInteger sn = signCert.getSerialNumber();
            System.out.println("Sign cert DN ->");
            System.out.println(dn);
            System.out.println("Sign cert SN ->");
            System.out.println(sn);
        }
        catch (Exception exp) {
            System.out.println(exp);
            exp.printStackTrace();
        }
    }

    public final void testSignFile() {
        System.out.println("====== testSignFile ======");
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String szRet = signer.signFile(testFile);
            System.out.println(szRet);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testPkcs7SignData() {
        System.out.println("====== testPkcs7SignData ======");
        String szData = "Hello, Koal!";
        SvsSign signer = new SvsSign();
        try {
            FileInputStream fin = new FileInputStream(testSignPfx);
            signer.initSignCertAndKey(fin, testSignPfxPw);
            String szRet = signer.pkcs7SignData(szData.getBytes());
            System.out.println(szRet);
            System.out.println("Dump PKCS7");
            SvsSign.dumpPkcs7(szRet);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testPkcs7DetachSignData() {
        System.out.println("====== testPkcs7DetachSignData ======");
        String szData = "Hello, Koal!";
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String szRet = signer.pkcs7DetachSignData(szData.getBytes());
            System.out.println(szRet);
            System.out.println("Dump PKCS7");
            SvsSign.dumpPkcs7(szRet);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testPkcs7SignFile() {
        System.out.println("====== testPkcs7SignFile ======");
        SvsSign signer = new SvsSign();
        try {
            signer.initSignCertAndKey(testSignPfx, testSignPfxPw);
            String szRet = signer.pkcs7SignFile(testFile);
            System.out.println(szRet);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

