/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.test;

import com.koalii.svs.SvsVerify;
import com.koalii.svs.X509CertChecker;
import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS7;

public class SvsVerifyTest
extends TestCase {
    public static String testSignCert = "cert\\test1.cer";
    public static String testSignCertB64 = "cert\\test1B64.cer";
    public static String testFile = "cert\\test1.pfx";
    public static String testSubCaCert = "cert\\TestNewCA.cer";
    public static String testRootCaCert = "cert\\TestRootCA.cer";
    public static String testOriginFile = "cert\\origin.txt";

    public static byte[] getPkcs7OriginData(String strP7B64Data) throws Exception {
        BASE64Decoder b64Dec = new BASE64Decoder();
        PKCS7 p7 = new PKCS7(b64Dec.decodeBuffer(strP7B64Data));
        if (p7 != null) {
            return p7.getContentInfo().getContentBytes();
        }
        return null;
    }

    public static String getPkcs7SignCertB64(String strP7B64Data) throws Exception {
        PKCS7 p7 = new PKCS7(new BASE64Decoder().decodeBuffer(strP7B64Data));
        if (p7 == null) {
            throw new IllegalArgumentException();
        }
        X509Certificate[] certs = p7.getCertificates();
        if (certs == null || certs.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] dercert = certs[0].getEncoded();
        return new BASE64Encoder().encode(dercert);
    }

    public static void main(String[] args) {
        SvsVerifyTest.testVerifySignCert();
        String szSignedData = "MIIFSAYJKoZIhvcNAQcCoIIFOTCCBTUCAQExCTAHBgUrDgMCGjAbBgkqhkiG9w0BBwGgDgQMSGVsbG8sIEtvYWwhoIIEFTCCBBEwggN6oAMCAQICDAWHxTWn0RMUr3kC3DANBgkqhkiG9w0BAQUFADBOMQ0wCwYDVQQGHgQAQwBOMQ0wCwYDVQQIHgQAUwBIMREwDwYDVQQKHggASwBPAEEATDEbMBkGA1UEAx4SAFQAZQBzAHQATgBlAHcAQwBBMB4XDTA2MDYwNzAzMTAyMloXDTA4MDYwNjAzMTAyMlowggEbMQ0wCwYDVQQGHgROLVb9MQ0wCwYDVQQIHgQAYgBqMQ0wCwYDVQQHHgQAagBiMRMwEQYDVQQKHgoAYwBhAHMAaQBjMRUwEwYDVQQLHgwAcwBlAGMAbwBuAGQxOzA5BgkqhkiG9w0BCQEeLAB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsAEAAawBvAGEAbAAuAGMAbwBtMSMwIQYDVQQqHhoAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbDEtMCsGA1UEAR4kADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxMS8wLQYDVQQDHiYAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbAA5ADIANgAwADcAMzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtC2ZBnFsAvhbO1fF7W5oCKmK/oRRzMzzDrGRZnpT9vffLE86PS/L4h6ZwOEHXBy7ZE9M1KK9FQbpE+Lr3o0cUdpi0xSV8ajbMD4/e0v9e1Xr/S9Y01U3z3Do42VMM3w5c+ZtOOhBso6WmPi4YeOtWrN1/oKsQwnEOpb8mimToT0CAwEAAaOCASMwggEfMA8GA1UdEwEBAAQFMAMBAQAwDgYDVR0PAQEABAQDAgDoMBYGA1UdJQEBAAQMMAoGCCsGAQUFBwMCMCIGA1UdIwEBAAQYMBaAFDAq8PZqtpijBkgWx4jF8FYo9GMfME0GA1UdHwEBAARDMEEwP6A9oDuGOWh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvZW50aXR5aWQxNGdyb3VwaWQwLmNybDBPBggrBgEFBQcBAQEBAARAMD4wPAYIKwYBBQUHMAKGMGh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvVGVzdE5ld0NBLmNlcjAgBgNVHQ4BAQAEFgQUr/5cFObjx3tuvTDu+JlrTDnlPWswDQYJKoZIhvcNAQEFBQADgYEARHQ56NyLPZALz9frgPyu12L46lpCXCRGvyZFhu8qWNuskKWHSim6zobOVzfenqstDxkvOI2K5UcHc13OO+N3UQ/UB2GLQ5Z+O3rlcWPuyD3IB8xLvcVxLJdNyhCp7p9Edmg24E0nvIvsAS3P69FMoUwlyt4oM/cBj6SsHXyY7H4xge4wgesCAQEwTTA9MRIwEAYDVQQDDAlUZXN0TmV3Q0ExDTALBgNVBAoMBEtPQUwxCzAJBgNVBAgMAlNIMQswCQYDVQQGEwJDTgIMBYfFNafRExSveQLcMAcGBSsOAwIaMAsGCSqGSIb3DQEBAQSBgJsLdiVi4UceJ1+zx7/H1+a19IdT28cL7tkiCXOdgoFNNmXfr09Fut66sDODXc9psh0Z5H+lpQKTgplh7OpVcNNsKTphPg95aZCrRMzRY+Jz/nV/1RQXis9tCY4hCDTJmnxB4uc7DBRS9u6QzR7Qjd2hc52uJZACmA8U1JtWFsBp";
        SvsVerify very = new SvsVerify();
        int nret = very.verifyPkcs7Sign("Hello, Koal!".getBytes(), szSignedData);
        System.out.println(nret);
        try {
            byte[] oridata = SvsVerifyTest.getPkcs7OriginData(szSignedData);
            System.out.println(new String(oridata));
            String b64cert = SvsVerifyTest.getPkcs7SignCertB64(szSignedData);
            System.out.println(b64cert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public SvsVerifyTest(String arg0) {
        super(arg0);
    }

    public final void testVerifySignbyteArrayintintString() {
        System.out.println("====== testVerifySignbyteArrayintintString ======");
        String szData = "Hello, Koal!";
        String szSignedData = "mwt2JWLhRx4nX7PHv8fX5rX0h1Pbxwvu2SIJc52CgU02Zd+vT0W63rqwM4Ndz2myHRnkf6WlApOCmWHs6lVw02wpOmE+D3lpkKtEzNFj4nP+dX/VFBeKz20JjiEINMmafEHi5zsMFFL27pDNHtCN3aFzna4lkAKYDxTUm1YWwGk=";
        SvsVerify very = new SvsVerify();
        try {
            very.initSignCertFile(testSignCertB64);
            int nRet = very.verifySign(szData.getBytes(), szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            String szCert = very.getEncodedSignCert();
            System.out.println("Sign Cert ->");
            System.out.println(szCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testVerifyFileSign() {
        System.out.println("====== testVerifyFileSign ======");
        String szSignedData = "NHfYITR77Ls0vhVzAlrGC32CeEdITrEAkVmNQVxoPYtR7trliar6CR+Y2ZxYgGn0oJ2+XmKvBsFcERckGsgt2uoA1ZVrGzjrlwzNdD/NtDUlnyoc3BlMNJ8vq/JkDzdhWoUufMchjTITgVsBXwCBQ9pGvNdVN4bkyxvABeqdrPg=";
        String szInvalidSignedData = szSignedData.substring(1);
        SvsVerify very = new SvsVerify();
        try {
            very.initSignCertFile(testSignCert);
            int nRet = very.verifyFileSign(testFile, szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            nRet = very.verifyFileSign(testFile, szInvalidSignedData);
            if (nRet == 0) {
                System.out.println("[ERROR] Verify Return OK ");
            } else {
                System.out.println("[OK] Verify Return ERROR: " + nRet);
            }
        }
        catch (Exception exp) {
            System.out.println(exp);
            exp.printStackTrace();
        }
    }

    public final void testVerifyPkcs7DetachSign() {
        System.out.println("====== testVerifyPkcs7DetachSign ======");
        String szData = "Hello, Koal!";
        String szSignedData = "MIIFOAYJKoZIhvcNAQcCoIIFKTCCBSUCAQExCTAHBgUrDgMCGjALBgkqhkiG9w0BBwGgggQVMIIEETCCA3qgAwIBAgIMBYfFNafRExSveQLcMA0GCSqGSIb3DQEBBQUAME4xDTALBgNVBAYeBABDAE4xDTALBgNVBAgeBABTAEgxETAPBgNVBAoeCABLAE8AQQBMMRswGQYDVQQDHhIAVABlAHMAdABOAGUAdwBDAEEwHhcNMDYwNjA3MDMxMDIyWhcNMDgwNjA2MDMxMDIyWjCCARsxDTALBgNVBAYeBE4tVv0xDTALBgNVBAgeBABiAGoxDTALBgNVBAceBABqAGIxEzARBgNVBAoeCgBjAGEAcwBpAGMxFTATBgNVBAseDABzAGUAYwBvAG4AZDE7MDkGCSqGSIb3DQEJAR4sAHQAZQBzAHQAdwBpAG4AZABjAGgAaQBsAGwAQABrAG8AYQBsAC4AYwBvAG0xIzAhBgNVBCoeGgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsMS0wKwYDVQQBHiQAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADExLzAtBgNVBAMeJgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsADkAMgA2ADAANwAzMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC0LZkGcWwC+Fs7V8XtbmgIqYr+hFHMzPMOsZFmelP2998sTzo9L8viHpnA4QdcHLtkT0zUor0VBukT4uvejRxR2mLTFJXxqNswPj97S/17Vev9L1jTVTfPcOjjZUwzfDlz5m046EGyjpaY+Lhh461as3X+gqxDCcQ6lvyaKZOhPQIDAQABo4IBIzCCAR8wDwYDVR0TAQEABAUwAwEBADAOBgNVHQ8BAQAEBAMCAOgwFgYDVR0lAQEABAwwCgYIKwYBBQUHAwIwIgYDVR0jAQEABBgwFoAUMCrw9mq2mKMGSBbHiMXwVij0Yx8wTQYDVR0fAQEABEMwQTA/oD2gO4Y5aHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9lbnRpdHlpZDE0Z3JvdXBpZDAuY3JsME8GCCsGAQUFBwEBAQEABEAwPjA8BggrBgEFBQcwAoYwaHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9UZXN0TmV3Q0EuY2VyMCAGA1UdDgEBAAQWBBSv/lwU5uPHe269MO74mWtMOeU9azANBgkqhkiG9w0BAQUFAAOBgQBEdDno3Is9kAvP1+uA/K7XYvjqWkJcJEa/JkWG7ypY26yQpYdKKbrOhs5XN96eqy0PGS84jYrlRwdzXc4743dRD9QHYYtDln47euVxY+7IPcgHzEu9xXEsl03KEKnun0R2aDbgTSe8i+wBLc/r0UyhTCXK3igz9wGPpKwdfJjsfjGB7jCB6wIBATBNMD0xEjAQBgNVBAMMCVRlc3ROZXdDQTENMAsGA1UECgwES09BTDELMAkGA1UECAwCU0gxCzAJBgNVBAYTAkNOAgwFh8U1p9ETFK95AtwwBwYFKw4DAhowCwYJKoZIhvcNAQEBBIGAmwt2JWLhRx4nX7PHv8fX5rX0h1Pbxwvu2SIJc52CgU02Zd+vT0W63rqwM4Ndz2myHRnkf6WlApOCmWHs6lVw02wpOmE+D3lpkKtEzNFj4nP+dX/VFBeKz20JjiEINMmafEHi5zsMFFL27pDNHtCN3aFzna4lkAKYDxTUm1YWwGk=";
        SvsVerify very = new SvsVerify();
        try {
            very.initSignCertFile(testSignCertB64);
            int nRet = very.verifyPkcs7Sign(szData.getBytes(), szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            PKCS7 p7 = new PKCS7(SvsVerify.base64Decode(szSignedData));
            X509Certificate[] certs = p7.getCertificates();
            X509Certificate cert = certs[0];
            if (cert.equals(very.getSignCert())) {
                System.out.println("[OK] Verify OK: cert matched");
            } else {
                System.out.println("[ERROR] Verify ERROR: cert dismattched");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testVerifyPkcs7Sign() {
        System.out.println("====== testVerifyPKCS7Sign ======");
        String szData = "Hello, Koal!";
        String szSignedData = "MIIFSAYJKoZIhvcNAQcCoIIFOTCCBTUCAQExCTAHBgUrDgMCGjAbBgkqhkiG9w0BBwGgDgQMSGVsbG8sIEtvYWwhoIIEFTCCBBEwggN6oAMCAQICDAWHxTWn0RMUr3kC3DANBgkqhkiG9w0BAQUFADBOMQ0wCwYDVQQGHgQAQwBOMQ0wCwYDVQQIHgQAUwBIMREwDwYDVQQKHggASwBPAEEATDEbMBkGA1UEAx4SAFQAZQBzAHQATgBlAHcAQwBBMB4XDTA2MDYwNzAzMTAyMloXDTA4MDYwNjAzMTAyMlowggEbMQ0wCwYDVQQGHgROLVb9MQ0wCwYDVQQIHgQAYgBqMQ0wCwYDVQQHHgQAagBiMRMwEQYDVQQKHgoAYwBhAHMAaQBjMRUwEwYDVQQLHgwAcwBlAGMAbwBuAGQxOzA5BgkqhkiG9w0BCQEeLAB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsAEAAawBvAGEAbAAuAGMAbwBtMSMwIQYDVQQqHhoAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbDEtMCsGA1UEAR4kADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxMS8wLQYDVQQDHiYAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbAA5ADIANgAwADcAMzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtC2ZBnFsAvhbO1fF7W5oCKmK/oRRzMzzDrGRZnpT9vffLE86PS/L4h6ZwOEHXBy7ZE9M1KK9FQbpE+Lr3o0cUdpi0xSV8ajbMD4/e0v9e1Xr/S9Y01U3z3Do42VMM3w5c+ZtOOhBso6WmPi4YeOtWrN1/oKsQwnEOpb8mimToT0CAwEAAaOCASMwggEfMA8GA1UdEwEBAAQFMAMBAQAwDgYDVR0PAQEABAQDAgDoMBYGA1UdJQEBAAQMMAoGCCsGAQUFBwMCMCIGA1UdIwEBAAQYMBaAFDAq8PZqtpijBkgWx4jF8FYo9GMfME0GA1UdHwEBAARDMEEwP6A9oDuGOWh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvZW50aXR5aWQxNGdyb3VwaWQwLmNybDBPBggrBgEFBQcBAQEBAARAMD4wPAYIKwYBBQUHMAKGMGh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvVGVzdE5ld0NBLmNlcjAgBgNVHQ4BAQAEFgQUr/5cFObjx3tuvTDu+JlrTDnlPWswDQYJKoZIhvcNAQEFBQADgYEARHQ56NyLPZALz9frgPyu12L46lpCXCRGvyZFhu8qWNuskKWHSim6zobOVzfenqstDxkvOI2K5UcHc13OO+N3UQ/UB2GLQ5Z+O3rlcWPuyD3IB8xLvcVxLJdNyhCp7p9Edmg24E0nvIvsAS3P69FMoUwlyt4oM/cBj6SsHXyY7H4xge4wgesCAQEwTTA9MRIwEAYDVQQDDAlUZXN0TmV3Q0ExDTALBgNVBAoMBEtPQUwxCzAJBgNVBAgMAlNIMQswCQYDVQQGEwJDTgIMBYfFNafRExSveQLcMAcGBSsOAwIaMAsGCSqGSIb3DQEBAQSBgJsLdiVi4UceJ1+zx7/H1+a19IdT28cL7tkiCXOdgoFNNmXfr09Fut66sDODXc9psh0Z5H+lpQKTgplh7OpVcNNsKTphPg95aZCrRMzRY+Jz/nV/1RQXis9tCY4hCDTJmnxB4uc7DBRS9u6QzR7Qjd2hc52uJZACmA8U1JtWFsBp";
        SvsVerify very = new SvsVerify();
        try {
            very.initSignCertFile(testSignCertB64);
            int nRet = very.verifyPkcs7Sign(szData.getBytes(), szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            PKCS7 p7 = new PKCS7(SvsVerify.base64Decode(szSignedData));
            String strOri = new String(p7.getContentInfo().getContentBytes());
            System.out.println(strOri);
            if (strOri.equals(szData)) {
                System.out.println("[OK] Verify OK: data matched");
            } else {
                System.out.println("[ERROR] Verify ERROR: data dismattched");
            }
            X509Certificate[] certs = p7.getCertificates();
            X509Certificate cert = certs[0];
            if (cert.equals(very.getSignCert())) {
                System.out.println("[OK] Verify OK: cert matched");
            } else {
                System.out.println("[ERROR] Verify ERROR: cert dismattched");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testVerifyPkcs7SignFile() {
        System.out.println("====== testVerifyPKCS7SignFile ======");
        String szSignedData = "MIIFSAYJKoZIhvcNAQcCoIIFOTCCBTUCAQExCTAHBgUrDgMCGjAbBgkqhkiG9w0BBwGgDgQMSGVsbG8sIEtvYWwhoIIEFTCCBBEwggN6oAMCAQICDAWHxTWn0RMUr3kC3DANBgkqhkiG9w0BAQUFADBOMQ0wCwYDVQQGHgQAQwBOMQ0wCwYDVQQIHgQAUwBIMREwDwYDVQQKHggASwBPAEEATDEbMBkGA1UEAx4SAFQAZQBzAHQATgBlAHcAQwBBMB4XDTA2MDYwNzAzMTAyMloXDTA4MDYwNjAzMTAyMlowggEbMQ0wCwYDVQQGHgROLVb9MQ0wCwYDVQQIHgQAYgBqMQ0wCwYDVQQHHgQAagBiMRMwEQYDVQQKHgoAYwBhAHMAaQBjMRUwEwYDVQQLHgwAcwBlAGMAbwBuAGQxOzA5BgkqhkiG9w0BCQEeLAB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsAEAAawBvAGEAbAAuAGMAbwBtMSMwIQYDVQQqHhoAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbDEtMCsGA1UEAR4kADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxMS8wLQYDVQQDHiYAdABlAHMAdAB3AGkAbgBkAGMAaABpAGwAbAA5ADIANgAwADcAMzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtC2ZBnFsAvhbO1fF7W5oCKmK/oRRzMzzDrGRZnpT9vffLE86PS/L4h6ZwOEHXBy7ZE9M1KK9FQbpE+Lr3o0cUdpi0xSV8ajbMD4/e0v9e1Xr/S9Y01U3z3Do42VMM3w5c+ZtOOhBso6WmPi4YeOtWrN1/oKsQwnEOpb8mimToT0CAwEAAaOCASMwggEfMA8GA1UdEwEBAAQFMAMBAQAwDgYDVR0PAQEABAQDAgDoMBYGA1UdJQEBAAQMMAoGCCsGAQUFBwMCMCIGA1UdIwEBAAQYMBaAFDAq8PZqtpijBkgWx4jF8FYo9GMfME0GA1UdHwEBAARDMEEwP6A9oDuGOWh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvZW50aXR5aWQxNGdyb3VwaWQwLmNybDBPBggrBgEFBQcBAQEBAARAMD4wPAYIKwYBBQUHMAKGMGh0dHA6Ly8xOTIuMTY4LjIxMC4yMzk6ODEvZG93bmxvYWQvVGVzdE5ld0NBLmNlcjAgBgNVHQ4BAQAEFgQUr/5cFObjx3tuvTDu+JlrTDnlPWswDQYJKoZIhvcNAQEFBQADgYEARHQ56NyLPZALz9frgPyu12L46lpCXCRGvyZFhu8qWNuskKWHSim6zobOVzfenqstDxkvOI2K5UcHc13OO+N3UQ/UB2GLQ5Z+O3rlcWPuyD3IB8xLvcVxLJdNyhCp7p9Edmg24E0nvIvsAS3P69FMoUwlyt4oM/cBj6SsHXyY7H4xge4wgesCAQEwTTA9MRIwEAYDVQQDDAlUZXN0TmV3Q0ExDTALBgNVBAoMBEtPQUwxCzAJBgNVBAgMAlNIMQswCQYDVQQGEwJDTgIMBYfFNafRExSveQLcMAcGBSsOAwIaMAsGCSqGSIb3DQEBAQSBgJsLdiVi4UceJ1+zx7/H1+a19IdT28cL7tkiCXOdgoFNNmXfr09Fut66sDODXc9psh0Z5H+lpQKTgplh7OpVcNNsKTphPg95aZCrRMzRY+Jz/nV/1RQXis9tCY4hCDTJmnxB4uc7DBRS9u6QzR7Qjd2hc52uJZACmA8U1JtWFsBp";
        SvsVerify very = new SvsVerify();
        try {
            very.initSignCertFile(testSignCertB64);
            int nRet = very.verifyPkcs7SignFile(testOriginFile, szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            PKCS7 p7 = new PKCS7(SvsVerify.base64Decode(szSignedData));
            X509Certificate[] certs = p7.getCertificates();
            X509Certificate cert = certs[0];
            if (cert.equals(very.getSignCert())) {
                System.out.println("[OK] Verify OK: cert matched");
            } else {
                System.out.println("[ERROR] Verify ERROR: cert dismattched");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static final void testVerifySignCert() {
        System.out.println("====== testVerifySignCert ======");
        String szData = "Hello, Koal!";
        String szSignedData = "MIIFYQYJKoZIhvcNAQcCoIIFUjCCBU4CAQExCzAJBgUrDgMCGgUAMBsGCSqGSIb3DQEHAaAOBAxIZWxsbywgS29hbCGgggQVMIIEETCCA3qgAwIBAgIMBYfFNafRExSveQLcMA0GCSqGSIb3DQEBBQUAME4xDTALBgNVBAYeBABDAE4xDTALBgNVBAgeBABTAEgxETAPBgNVBAoeCABLAE8AQQBMMRswGQYDVQQDHhIAVABlAHMAdABOAGUAdwBDAEEwHhcNMDYwNjA3MDMxMDIyWhcNMDgwNjA2MDMxMDIyWjCCARsxDTALBgNVBAYeBE4tVv0xDTALBgNVBAgeBABiAGoxDTALBgNVBAceBABqAGIxEzARBgNVBAoeCgBjAGEAcwBpAGMxFTATBgNVBAseDABzAGUAYwBvAG4AZDE7MDkGCSqGSIb3DQEJAR4sAHQAZQBzAHQAdwBpAG4AZABjAGgAaQBsAGwAQABrAG8AYQBsAC4AYwBvAG0xIzAhBgNVBCoeGgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsMS0wKwYDVQQBHiQAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADEAMQAxADExLzAtBgNVBAMeJgB0AGUAcwB0AHcAaQBuAGQAYwBoAGkAbABsADkAMgA2ADAANwAzMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC0LZkGcWwC+Fs7V8XtbmgIqYr+hFHMzPMOsZFmelP2998sTzo9L8viHpnA4QdcHLtkT0zUor0VBukT4uvejRxR2mLTFJXxqNswPj97S/17Vev9L1jTVTfPcOjjZUwzfDlz5m046EGyjpaY+Lhh461as3X+gqxDCcQ6lvyaKZOhPQIDAQABo4IBIzCCAR8wDwYDVR0TAQEABAUwAwEBADAOBgNVHQ8BAQAEBAMCAOgwFgYDVR0lAQEABAwwCgYIKwYBBQUHAwIwIgYDVR0jAQEABBgwFoAUMCrw9mq2mKMGSBbHiMXwVij0Yx8wTQYDVR0fAQEABEMwQTA/oD2gO4Y5aHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9lbnRpdHlpZDE0Z3JvdXBpZDAuY3JsME8GCCsGAQUFBwEBAQEABEAwPjA8BggrBgEFBQcwAoYwaHR0cDovLzE5Mi4xNjguMjEwLjIzOTo4MS9kb3dubG9hZC9UZXN0TmV3Q0EuY2VyMCAGA1UdDgEBAAQWBBSv/lwU5uPHe269MO74mWtMOeU9azANBgkqhkiG9w0BAQUFAAOBgQBEdDno3Is9kAvP1+uA/K7XYvjqWkJcJEa/JkWG7ypY26yQpYdKKbrOhs5XN96eqy0PGS84jYrlRwdzXc4743dRD9QHYYtDln47euVxY+7IPcgHzEu9xXEsl03KEKnun0R2aDbgTSe8i+wBLc/r0UyhTCXK3igz9wGPpKwdfJjsfjGCAQQwggEAAgEBMF4wTjENMAsGA1UEBh4EAEMATjENMAsGA1UECB4EAFMASDERMA8GA1UECh4IAEsATwBBAEwxGzAZBgNVBAMeEgBUAGUAcwB0AE4AZQB3AEMAQQIMBYfFNafRExSveQLcMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYCbC3YlYuFHHidfs8e/x9fmtfSHU9vHC+7ZIglznYKBTTZl369PRbreurAzg13PabIdGeR/paUCk4KZYezqVXDTbCk6YT4PeWmQq0TM0WPic/51f9UUF4rPbQmOIQg0yZp8QeLnOwwUUvbukM0e0I3doXOdriWQApgPFNSbVhbAaQ==";
        SvsVerify very = new SvsVerify();
        try {
            int nRet = very.verifyPkcs7Sign(szData.getBytes(), szSignedData);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
            nRet = very.checkSignCert();
            if (nRet == 0) {
                System.out.println("[OK] Verify sign cert OK");
            } else {
                System.out.println("[ERROR] Verify sign cert ERROR: " + nRet);
            }
            X509Certificate caCert = null;
            X509Certificate rootCert = null;
            try {
                caCert = X509CertChecker.parseX509Cert(testSubCaCert);
                rootCert = X509CertChecker.parseX509Cert(testRootCaCert);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            X509Certificate[] certChain = new X509Certificate[]{caCert, rootCert};
            X509CertChecker checker = new X509CertChecker();
            nRet = checker.addCertChain(certChain);
            if (nRet != 0) {
                System.out.println("[ERROR] Add cert chain error");
            }
            very.setCertChecker(checker);
            nRet = very.localCheckSignCert();
            if (nRet == 0) {
                System.out.println("[OK] Local check OK");
            } else {
                System.out.println("[ERROR] Local check failed: " + nRet);
            }
            X509CertChecker checker2 = new X509CertChecker();
            checker2.setRemoteHost("127.0.0.1", 5000);
            very.setCertChecker(checker2);
            nRet = very.remoteCheckSignCert();
            if (nRet == 0) {
                System.out.println("[OK] Remote check OK");
            } else {
                System.out.println("[ERROR] Remote check failed: " + nRet);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public final void testVerify() {
        System.out.println("====== testVerify ======");
        String szData = "Hello, Koal!";
        String szSignedData = "mwt2JWLhRx4nX7PHv8fX5rX0h1Pbxwvu2SIJc52CgU02Zd+vT0W63rqwM4Ndz2myHRnkf6WlApOCmWHs6lVw02wpOmE+D3lpkKtEzNFj4nP+dX/VFBeKz20JjiEINMmafEHi5zsMFFL27pDNHtCN3aFzna4lkAKYDxTUm1YWwGk=";
        SvsVerify very = new SvsVerify();
        try {
            int nRet = SvsVerify.verify(szData.getBytes(), szSignedData, testSignCertB64);
            if (nRet == 0) {
                System.out.println("[OK] Verify Return OK");
            } else {
                System.out.println("[ERROR] Verify Return ERROR: " + nRet);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

