/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.test;

import com.koalii.svs.X509CertChecker;
import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class X509CertCheckerTest
extends TestCase {
    public static String testSignCert = "cert\\test1.cer";
    public static String testSubCaCert = "cert\\TestNewCA.cer";
    public static String testRootCaCert = "cert\\TestRootCA.cer";

    public static void main(String[] args) {
        TestRunner.run(X509CertCheckerTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public X509CertCheckerTest(String arg0) {
        super(arg0);
    }

    public final void testAddCertChain() {
        System.out.println("====== testAddCertChain ======");
        X509Certificate cert = null;
        X509Certificate rootCert = null;
        X509Certificate invalidRootCert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
            rootCert = X509CertChecker.parseX509Cert(testSubCaCert);
            invalidRootCert = X509CertChecker.parseX509Cert(testRootCaCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        X509Certificate[] certs = new X509Certificate[]{rootCert};
        X509Certificate[] invalidCerts = new X509Certificate[]{invalidRootCert};
        X509CertChecker checker = new X509CertChecker();
        int nRet = checker.addCertChain(certs);
        if (nRet != 0) {
            System.out.println("[ERROR] Add cert chain error");
        }
        if ((nRet = checker.addCertChain(invalidCerts)) != 0) {
            System.out.println("[ERROR] Add cert chain error");
        }
        if ((nRet = checker.localCheck(cert)) == 0) {
            System.out.println("[OK] localCheck OK");
        } else {
            System.out.println("[ERROR] localCheck failed");
        }
    }

    public final void testCheckCertChain() {
        System.out.println("====== testCheckCertChain ======");
        X509Certificate cert = null;
        X509Certificate rootCert = null;
        X509Certificate invalidRootCert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
            rootCert = X509CertChecker.parseX509Cert(testSubCaCert);
            invalidRootCert = X509CertChecker.parseX509Cert(testRootCaCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        X509Certificate[] certs = new X509Certificate[]{cert, rootCert};
        X509Certificate[] invalidCerts = new X509Certificate[]{cert, invalidRootCert};
        int nRet = X509CertChecker.checkCertChain(certs);
        if (nRet == 0) {
            System.out.println("[OK] Cert chain OK");
        } else {
            System.out.println("[ERROR] Cert chain invalid");
        }
        nRet = X509CertChecker.checkCertChain(invalidCerts);
        if (nRet == 0) {
            System.out.println("[ERROR] Cert chain OK");
        } else {
            System.out.println("[OK] Cert chain invalid");
        }
    }

    public final void testLocalCheck() {
        System.out.println("====== testLocalCheck ======");
        X509Certificate cert = null;
        X509Certificate caCert = null;
        X509Certificate rootCert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
            caCert = X509CertChecker.parseX509Cert(testSubCaCert);
            rootCert = X509CertChecker.parseX509Cert(testRootCaCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        X509Certificate[] certs = new X509Certificate[]{caCert, rootCert};
        X509Certificate[] invalidCerts = new X509Certificate[]{rootCert};
        X509CertChecker checker = new X509CertChecker();
        int nRet = checker.addCertChain(invalidCerts);
        if (nRet != 0) {
            System.out.println("[ERROR] Add cert chain error");
        }
        if ((nRet = checker.addCertChain(certs)) != 0) {
            System.out.println("[ERROR] Add cert chain error");
        }
        if ((nRet = checker.localCheck(cert)) == 0) {
            System.out.println("[OK] localCheck OK");
        } else {
            System.out.println("[ERROR] localCheck failed");
        }
    }

    public final void testRemoteCheck() {
        System.out.println("====== testRemoteCheck ======");
        X509Certificate cert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        X509CertChecker checker = new X509CertChecker();
        checker.setRemoteHost("127.0.0.1", 5000);
        int nRet = -1;
        try {
            nRet = checker.remoteCheck(cert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (nRet == 0) {
            System.out.println("[OK] remoteCheck OK");
        } else {
            System.out.println("[ERROR] remoteCheck ERROR: " + nRet);
        }
    }

    public final void testGetXPathValue() {
        System.out.println("====== testGetXPathValue ======");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<msg>");
        sbuf.append("<msg_head>");
        sbuf.append("<msg_type>0</msg_type>");
        sbuf.append("<msg_id>1000</msg_id>");
        sbuf.append("<msg_sn>0</msg_sn>");
        sbuf.append("<version>1</version>");
        sbuf.append("</msg_head>");
        sbuf.append("<msg_body>");
        sbuf.append("<ocsp_flag>0</ocsp_flag>");
        sbuf.append("<crl_flag>1</crl_flag>");
        sbuf.append("</msg_body>");
        sbuf.append("</msg>");
        String szRet = X509CertChecker.getXPathValue("/msg/msg_head/msg_id", sbuf.toString());
        if (szRet != null) {
            System.out.println("XPath value: " + szRet);
        } else {
            System.out.println("Cannot get XPath value");
        }
    }

    public final void testCheckCertValidity() {
        System.out.println("====== testCheckCertValidity ======");
        X509Certificate cert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (cert == null) {
            System.out.println("[ERROR] Cannot parse x509 cert");
            return;
        }
        int nRet = X509CertChecker.checkCertValidity(cert);
        if (nRet == 0) {
            System.out.println("[OK] Cert is valid");
        } else {
            System.out.println("Cert is invalid: " + nRet);
        }
    }

    public final void testCheckCertSignature() {
        System.out.println("====== testCheckCertSignature ======");
        X509Certificate cert = null;
        X509Certificate rootCert = null;
        X509Certificate invalidRootCert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
            rootCert = X509CertChecker.parseX509Cert(testSubCaCert);
            invalidRootCert = X509CertChecker.parseX509Cert(testRootCaCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (cert == null || rootCert == null) {
            System.out.println("[ERROR] Cannot parse x509 cert");
            return;
        }
        int nRet = X509CertChecker.checkCertSignature(cert, rootCert.getPublicKey());
        if (nRet == 0) {
            System.out.println("[OK] Signature is valid");
        } else {
            System.out.println("[ERROR] Signature is invalid: " + nRet);
        }
        nRet = X509CertChecker.checkCertSignature(cert, invalidRootCert.getPublicKey());
        if (nRet == 0) {
            System.out.println("[ERROR] Signature is valid");
        } else {
            System.out.println("[OK] Signature is invalid: " + nRet);
        }
    }

    public final void testCheckCert() {
        System.out.println("====== testCheckCert ======");
        X509Certificate cert = null;
        X509Certificate rootCert = null;
        X509Certificate invalidRootCert = null;
        try {
            cert = X509CertChecker.parseX509Cert(testSignCert);
            rootCert = X509CertChecker.parseX509Cert(testSubCaCert);
            invalidRootCert = X509CertChecker.parseX509Cert(testRootCaCert);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        int nRet = X509CertChecker.checkCert(rootCert, cert);
        if (nRet == 0) {
            System.out.println("[OK] Cert chain OK");
        } else {
            System.out.println("[ERROR] Cert chain invalid");
        }
        nRet = X509CertChecker.checkCert(invalidRootCert, rootCert);
        if (nRet == 0) {
            System.out.println("[ERROR] Cert chain OK");
        } else {
            System.out.println("[OK] Cert chain invalid");
        }
    }
}

