/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Scanner;

public class ScannerUtil {
    private boolean isAuto = false;
    private String inpath = null;
    private String outpath = null;
    private static File[] files = null;
    private BufferedReader bf = null;
    private InputStreamReader isr = null;
    private FileInputStream fis = null;
    private static Scanner sc = new Scanner(System.in);

    public ScannerUtil() {
    }

    public ScannerUtil(String path, boolean isAuto) {
        if (path != null) {
            this.inpath = path;
        }
        this.isAuto = isAuto;
    }

    public void init() {
        try {
            if (this.inpath != null) {
                this.fis = new FileInputStream(this.inpath);
                this.isr = new InputStreamReader(this.fis);
                this.bf = new BufferedReader(this.isr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOutpath() {
        return this.outpath;
    }

    public void setOutpath(String outpath) {
        this.outpath = outpath;
    }

    public void reset(String path, boolean isAuto) {
        this.inpath = path;
        this.isAuto = isAuto;
        this.init();
    }

    public void close() {
        try {
            try {
                if (this.bf != null && this.isr != null && this.fis != null) {
                    this.bf.close();
                    this.isr.close();
                    this.fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.bf = null;
                this.isr = null;
                this.fis = null;
            }
        }
        finally {
            this.bf = null;
            this.isr = null;
            this.fis = null;
        }
    }

    public int nextInt() {
        if (this.isAuto) {
            try {
                return Integer.parseInt(this.readFileByLine());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sc.nextInt();
    }

    public String next() {
        if (this.isAuto) {
            try {
                return this.readFileByLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sc.next();
    }

    public float nextFloat() {
        if (this.isAuto) {
            try {
                return Float.parseFloat(this.readFileByLine());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sc.nextFloat();
    }

    public long nextLong() {
        if (this.isAuto) {
            try {
                return Long.parseLong(this.readFileByLine());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sc.nextLong();
    }

    public byte nextByte() {
        if (this.isAuto) {
            try {
                return Byte.parseByte(this.readFileByLine());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sc.nextByte();
    }

    public String readFileByLine() {
        String readStr = null;
        try {
            if (this.bf != null) {
                String tempstr = null;
                tempstr = this.bf.readLine();
                while (tempstr != null && ("".equals(tempstr) || "#".equals(tempstr.substring(0, 1)))) {
                    if (tempstr.length() > 1 && "#".equals(tempstr.substring(0, 1))) {
                        this.writeFileByLine(tempstr);
                    }
                    tempstr = this.bf.readLine();
                }
                String[] strs = null;
                if (tempstr != null) {
                    strs = tempstr.split("=>");
                    readStr = strs[1].trim();
                } else {
                    readStr = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readStr;
    }

    public void writeFileByLine(String outPut) {
        if (this.outpath == null) {
            return;
        }
        BufferedWriter out = null;
        try {
            try {
                if (this.outpath != null && this.outpath.length() > 0) {
                    out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.outpath, true)));
                    out.write(outPut);
                    out.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File[] getAllFiles(String dir) {
        File file = null;
        if (dir != null) {
            file = new File(dir);
        }
        if (!file.exists()) {
            System.out.println("dir is not exist!!!");
            return null;
        }
        files = file.listFiles();
        return files;
    }
}

