/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util;

import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;

public class AlgorithmUtil {
    public static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    public static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    public static final String ID_MD5 = "1.2.840.113549.2.5";
    public static final String ID_MD2 = "1.2.840.113549.2.2";
    public static final String ID_SHA1 = "1.3.14.3.2.26";
    public static final String ID_RSA = "1.2.840.113549.1.1.1";
    public static final String ID_DSA = "1.2.840.10040.4.1";
    public static final int SHA1 = 0;
    public static final int MD5 = 1;

    public static byte[] disestSHA1(byte[] input) {
        return AlgorithmUtil.disestSHA1(input, 0, input.length);
    }

    public static byte[] disestSHA1(byte[] input, int offset, int len) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exp) {
            throw new SecurityException(exp.getMessage());
        }
        digest.update(input, offset, len);
        return digest.digest();
    }

    public static boolean verifySignature(byte[] oriData, byte[] signData, PublicKey pubKey) {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(pubKey);
            sig.update(oriData);
            return sig.verify(signData);
        }
        catch (Exception exp) {
            throw new SecurityException(exp.getMessage());
        }
    }
}

